/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.pagemem.wal.record.IncrementalSnapshotFinishRecord;
import org.apache.ignite.internal.pagemem.wal.record.IncrementalSnapshotStartRecord;
import org.apache.ignite.internal.pagemem.wal.record.RolloverType;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.transactions.TransactionState;

class IncrementalSnapshotMarkWalFuture
extends GridFutureAdapter<WALPointer> {
    private final GridCacheSharedContext<?, ?> cctx;
    private final UUID id;
    private final long topVer;
    private final IgniteLogger log;
    @GridToStringInclude
    private final Set<GridCacheVersion> included = ConcurrentHashMap.newKeySet();
    @GridToStringInclude
    private final Set<GridCacheVersion> excluded = ConcurrentHashMap.newKeySet();
    private final Set<IgniteInternalFuture<IgniteInternalTx>> removedFromActive = ConcurrentHashMap.newKeySet();

    IncrementalSnapshotMarkWalFuture(GridCacheSharedContext<?, ?> cctx, UUID id, long topVer) {
        this.cctx = cctx;
        this.id = id;
        this.topVer = topVer;
        this.log = cctx.logger(IncrementalSnapshotMarkWalFuture.class);
        cctx.tm().onCommitCallback(tx -> this.removedFromActive.add(tx.finishFuture()));
    }

    void init() {
        try {
            this.cctx.wal().log(new IncrementalSnapshotStartRecord(this.id));
            GridCompoundFuture<Boolean, Boolean> checkFut = new GridCompoundFuture<Boolean, Boolean>(CU.boolReducer());
            Iterator<IgniteInternalFuture<IgniteInternalTx>> finFutIt = this.cctx.tm().activeTransactions().stream().filter(tx -> tx.state() != TransactionState.ACTIVE).map(IgniteInternalTx::finishFuture).iterator();
            this.checkTransactions(finFutIt, checkFut);
            this.checkTransactions(this.removedFromActive.iterator(), checkFut);
            checkFut.markInitialized();
            checkFut.listen(finish -> {
                if (this.isDone()) {
                    return;
                }
                if (Boolean.FALSE.equals(finish.result())) {
                    this.onDone(new IgniteCheckedException("Incremental snapshot is inconsistent [id=" + this.id + ']'));
                    return;
                }
                WALPointer ptr = null;
                IgniteCheckedException err = null;
                this.cctx.database().checkpointReadLock();
                try {
                    ptr = this.cctx.wal().log(new IncrementalSnapshotFinishRecord(this.id, this.included, this.excluded), RolloverType.CURRENT_SEGMENT);
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to write IncrementalSnapshotFinishRecord to WAL for [id=" + this.id + ']', e);
                    err = e;
                }
                finally {
                    this.cctx.database().checkpointReadUnlock();
                }
                this.onDone(ptr, err);
            });
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
            U.error(this.log, "Failed to init incremental snapshot [id=" + this.id + ']', e);
        }
        finally {
            this.cctx.tm().onCommitCallback(null);
        }
    }

    private void checkTransactions(Iterator<IgniteInternalFuture<IgniteInternalTx>> activeTxFinFuts, GridCompoundFuture<Boolean, Boolean> checkFut) {
        while (activeTxFinFuts.hasNext()) {
            IgniteInternalFuture<Boolean> txCheckFut = activeTxFinFuts.next().chain(txFut -> {
                IgniteInternalTx tx = (IgniteInternalTx)txFut.result();
                if (tx.state() == TransactionState.ROLLED_BACK || tx.state() == TransactionState.MARKED_ROLLBACK) {
                    return true;
                }
                if (tx.state() != TransactionState.COMMITTED) {
                    U.warn(this.log, "Incremental snapshot is inconsistent due to transaction is in unexpected state [id=" + this.id + ", tx=" + tx + ']');
                    return false;
                }
                if (tx.finalizationStatus() == IgniteInternalTx.FinalizationStatus.RECOVERY_FINISH) {
                    U.warn(this.log, "Incremental snapshot is inconsistent due to transaction committed after recovery process [id=" + this.id + ", tx=" + tx + ']');
                    return false;
                }
                AffinityTopologyVersion txTopVer = tx.topologyVersionSnapshot();
                if (txTopVer == null) {
                    U.warn(this.log, "Incremental snapshot is inconsistent due to transaction doesn't map to topology [id=" + this.id + ", tx=" + tx + ']');
                    return false;
                }
                if (this.id.equals(tx.incrementalSnapshotId()) || txTopVer.topologyVersion() > this.topVer) {
                    this.excluded.add(tx.nearXidVersion());
                } else {
                    this.included.add(tx.nearXidVersion());
                }
                return true;
            });
            checkFut.add(txCheckFut);
        }
    }
}

