/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheReturnCompletableWrapper;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheVersionedFuture;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappings;
import org.apache.ignite.internal.processors.cache.distributed.near.NearTxFinishFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccFuture;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionRollbackException;
import org.apache.ignite.transactions.TransactionState;

public final class GridNearTxFinishFuture<K, V>
extends GridCacheCompoundIdentityFuture<IgniteInternalTx>
implements GridCacheFuture<IgniteInternalTx>,
NearTxFinishFuture {
    private static final long serialVersionUID = 0L;
    public static final String ALL_PARTITION_OWNERS_LEFT_GRID_MSG = "Failed to commit a transaction (all partition owners have left the grid, partition data has been lost)";
    private Span span;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    protected static IgniteLogger msgLog;
    private GridCacheSharedContext<K, V> cctx;
    private final IgniteUuid futId;
    @GridToStringInclude
    private GridNearTxLocal tx;
    private boolean commit;
    private IgniteTxMappings mappings;
    private boolean trackable = true;
    private boolean finishOnePhaseCalled;

    public GridNearTxFinishFuture(GridCacheSharedContext<K, V> cctx, GridNearTxLocal tx, boolean commit) {
        super(F.identityReducer(tx));
        this.cctx = cctx;
        this.tx = tx;
        this.commit = commit;
        this.ignoreInterrupts();
        this.mappings = tx.mappings();
        this.futId = IgniteUuid.randomUuid();
        if (tx.explicitLock()) {
            tx.syncMode(CacheWriteSynchronizationMode.FULL_SYNC);
        }
        if (log == null) {
            msgLog = cctx.txFinishMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridNearTxFinishFuture.class);
        }
    }

    @Override
    public boolean commit() {
        return this.commit;
    }

    GridCacheSharedContext<K, V> context() {
        return this.cctx;
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MinFuture f;
            if (!this.isMini(fut) || !(f = (MinFuture)fut).onNodeLeft(nodeId, true)) continue;
            this.mappings.remove(nodeId);
            found = true;
        }
        return found;
    }

    @Override
    public GridNearTxLocal tx() {
        return this.tx;
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
        this.trackable = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResult(UUID nodeId, GridNearTxFinishResponse res) {
        if (!this.isDone()) {
            FinishMiniFuture finishFut = null;
            this.compoundsReadLock();
            try {
                int size = this.futuresCountNoLock();
                for (int i = 0; i < size; ++i) {
                    FinishMiniFuture f;
                    IgniteInternalFuture fut = this.future(i);
                    if (fut.getClass() != FinishMiniFuture.class || (f = (FinishMiniFuture)fut).futureId() != res.miniId()) continue;
                    assert (f.primary().id().equals(nodeId));
                    finishFut = f;
                    break;
                }
            }
            finally {
                this.compoundsReadUnlock();
            }
            if (finishFut != null) {
                finishFut.onNearFinishResponse(res);
            } else if (msgLog.isDebugEnabled()) {
                msgLog.debug("Near finish fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("Near finish fut, response for finished future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    public void onResult(UUID nodeId, GridDhtTxFinishResponse res) {
        if (!this.isDone()) {
            boolean found = false;
            for (IgniteInternalFuture fut : this.futures()) {
                MinFuture f;
                if (fut.getClass() == CheckBackupMiniFuture.class) {
                    f = (CheckBackupMiniFuture)fut;
                    if (f.futureId() != res.miniId()) continue;
                    found = true;
                    assert (((CheckBackupMiniFuture)f).node().id().equals(nodeId));
                    if (res.returnValue() != null) {
                        this.tx.implicitSingleResult(res.returnValue());
                    }
                    ((CheckBackupMiniFuture)f).onDhtFinishResponse(res);
                    continue;
                }
                if (fut.getClass() != CheckRemoteTxMiniFuture.class || (f = (CheckRemoteTxMiniFuture)fut).futureId() != res.miniId()) continue;
                ((CheckRemoteTxMiniFuture)f).onDhtFinishResponse(nodeId, false);
            }
            if (!found && msgLog.isDebugEnabled()) {
                msgLog.debug("Near finish fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("Near finish fut, response for finished future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    void forceFinish() {
        super.onDone(this.tx, (Throwable)null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean onDone(IgniteInternalTx tx0, Throwable err) {
        Throwable throwable;
        MTC.TraceSurroundings ignored;
        block43: {
            boolean bl;
            block45: {
                block41: {
                    boolean bl2;
                    block42: {
                        block39: {
                            boolean bl3;
                            block40: {
                                ignored = MTC.support(this.span);
                                throwable = null;
                                if (!this.isDone()) break block39;
                                bl3 = false;
                                if (ignored == null) return bl3;
                                if (throwable == null) break block40;
                                try {
                                    ignored.close();
                                    return bl3;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                    return bl3;
                                }
                            }
                            ignored.close();
                            return bl3;
                        }
                        GridNearTxFinishFuture gridNearTxFinishFuture = this;
                        // MONITORENTER : gridNearTxFinishFuture
                        if (!this.isDone()) break block41;
                        bl2 = false;
                        // MONITOREXIT : gridNearTxFinishFuture
                        if (ignored == null) return bl2;
                        if (throwable == null) break block42;
                        try {
                            ignored.close();
                            return bl2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                            return bl2;
                        }
                    }
                    ignored.close();
                    return bl2;
                }
                try {
                    block44: {
                        boolean nodeStop = false;
                        if (err != null) {
                            this.tx.setRollbackOnly();
                            boolean bl4 = nodeStop = err instanceof NodeStoppingException || this.cctx.kernalContext().failure().nodeStopping();
                        }
                        if (this.commit) {
                            if (this.tx.commitError() != null) {
                                err = this.tx.commitError();
                            } else if (err != null) {
                                this.tx.commitError(err);
                            }
                        }
                        if (!this.initialized() && err == null) break block43;
                        if (this.tx.needCheckBackup()) {
                            assert (this.tx.onePhaseCommit());
                            if (err != null) {
                                err = new TransactionRollbackException("Failed to commit transaction.", err);
                            }
                            try {
                                this.tx.localFinish(err == null, true);
                            }
                            catch (IgniteCheckedException e) {
                                if (err != null) {
                                    err.addSuppressed(e);
                                }
                                err = e;
                            }
                        }
                        if (this.tx.onePhaseCommit()) {
                            boolean commit;
                            boolean bl5 = commit = this.commit && err == null;
                            if (!nodeStop) {
                                this.finishOnePhase(commit);
                            }
                            try {
                                this.tx.tmFinish(commit, nodeStop, true);
                            }
                            catch (IgniteCheckedException e) {
                                U.error(log, "Failed to finish tx: " + this.tx, e);
                                if (err != null) break block44;
                                err = e;
                            }
                        }
                    }
                    if (!super.onDone(tx0, err)) break block43;
                    this.cctx.mvcc().removeFuture(this.futId);
                    bl = true;
                    // MONITOREXIT : gridNearTxFinishFuture
                    if (ignored == null) return bl;
                    if (throwable == null) break block45;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                try {
                    ignored.close();
                    return bl;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    return bl;
                }
            }
            ignored.close();
            return bl;
        }
        try {
            // MONITOREXIT : gridNearTxFinishFuture
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable6) {
            throw throwable6;
        }
        finally {
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    private boolean isMini(IgniteInternalFuture<?> fut) {
        return fut.getClass() == FinishMiniFuture.class || fut.getClass() == CheckBackupMiniFuture.class || fut.getClass() == CheckRemoteTxMiniFuture.class;
    }

    @Override
    public void finish(boolean commit, boolean clearThreadMap, boolean onTimeout) {
        this.span = this.cctx.kernalContext().tracing().create(SpanType.TX_NEAR_FINISH, MTC.span());
        try (MTC.TraceSurroundings ignored = MTC.supportContinual(this.span);){
            if (!this.cctx.mvcc().addFuture(this, this.futureId())) {
                return;
            }
            if (this.tx.onNeedCheckBackup()) {
                assert (this.tx.onePhaseCommit());
                this.checkBackup();
                this.markInitialized();
                return;
            }
            if (!commit && !clearThreadMap) {
                this.rollbackAsyncSafe(onTimeout);
            } else {
                this.doFinish(commit, clearThreadMap);
            }
        }
    }

    private void rollbackAsyncSafe(final boolean onTimeout) {
        IgniteInternalFuture<?> curFut = this.tx.tryRollbackAsync();
        if (curFut == null) {
            this.doFinish(false, false);
            return;
        }
        if (curFut instanceof GridCacheVersionedFuture && !onTimeout) {
            try {
                curFut.cancel();
            }
            catch (IgniteCheckedException e) {
                log.error("Failed to cancel lock for the transaction: " + CU.txString(this.tx), e);
            }
        }
        curFut.listen(new IgniteInClosure<IgniteInternalFuture<?>>(){

            @Override
            public void apply(IgniteInternalFuture<?> fut) {
                try {
                    fut.get();
                    GridNearTxFinishFuture.this.rollbackAsyncSafe(onTimeout);
                }
                catch (IgniteCheckedException e) {
                    GridNearTxFinishFuture.this.doFinish(false, false);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFinish(boolean commit, boolean clearThreadMap) {
        try {
            if (this.tx.localFinish(commit, clearThreadMap) || !commit && this.tx.state() == TransactionState.UNKNOWN) {
                if (this.tx.state() == TransactionState.UNKNOWN) {
                    this.cctx.tm().rollbackTx(this.tx, clearThreadMap, false);
                }
                if (this.tx.onePhaseCommit() && this.needFinishOnePhase(commit) || !this.tx.onePhaseCommit() && this.mappings != null) {
                    if (this.mappings.single()) {
                        GridDistributedTxMapping mapping = this.mappings.singleMapping();
                        if (mapping != null) {
                            assert (!this.hasFutures() || this.isDone()) : this.futures();
                            this.finish(1, mapping, commit, !clearThreadMap);
                        }
                    } else {
                        assert (!this.hasFutures() || this.isDone()) : this.futures();
                        this.finish(this.mappings.mappings(), commit, !clearThreadMap);
                    }
                }
                this.markInitialized();
            } else {
                this.onDone(new IgniteCheckedException("Failed to " + (commit ? "commit" : "rollback") + " transaction: " + CU.txString(this.tx)));
            }
        }
        catch (Error | RuntimeException e) {
            this.onDone(e);
            throw e;
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
        }
        finally {
            if (commit && this.tx.onePhaseCommit() && !this.tx.writeMap().isEmpty()) {
                this.ackBackup();
            }
        }
    }

    @Override
    public void onNodeStop(IgniteCheckedException e) {
        super.onDone(this.tx, e);
    }

    private void ackBackup() {
        if (this.mappings.empty()) {
            return;
        }
        if (!this.tx.needReturnValue() || !this.tx.implicit()) {
            return;
        }
        GridDistributedTxMapping mapping = this.mappings.singleMapping();
        if (mapping != null) {
            UUID nodeId = mapping.primary().id();
            Collection<UUID> backups = this.tx.transactionNodes().get(nodeId);
            if (!F.isEmpty(backups)) {
                assert (backups.size() == 1) : backups;
                UUID backupId = F.first(backups);
                ClusterNode backup = this.cctx.discovery().node(backupId);
                if (backup != null) {
                    if (backup.isLocal()) {
                        this.cctx.tm().removeTxReturn(this.tx.xidVersion());
                    } else {
                        this.cctx.tm().sendDeferredAckResponse(backupId, this.tx.xidVersion());
                    }
                }
            }
        }
    }

    private void checkBackup() {
        assert (!this.hasFutures()) : this.futures();
        GridDistributedTxMapping mapping = this.mappings.singleMapping();
        if (mapping != null) {
            UUID nodeId = mapping.primary().id();
            Collection<UUID> backups = this.tx.transactionNodes().get(nodeId);
            if (!F.isEmpty(backups)) {
                assert (backups.size() == 1);
                UUID backupId = F.first(backups);
                ClusterNode backup = this.cctx.discovery().node(backupId);
                if (backup == null) {
                    this.readyNearMappingFromBackup(mapping);
                    ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Backup node left grid: " + backupId);
                    cause.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
                    this.onDone(new IgniteTxRollbackCheckedException("Failed to commit transaction (backup has left grid): " + this.tx.xidVersion(), cause));
                } else {
                    final CheckBackupMiniFuture mini = new CheckBackupMiniFuture(1, backup, mapping);
                    this.add(mini);
                    if (backup.isLocal()) {
                        boolean committed = !this.cctx.tm().addRolledbackTx(this.tx);
                        this.readyNearMappingFromBackup(mapping);
                        if (committed) {
                            try {
                                if (this.tx.needReturnValue() && this.tx.implicit()) {
                                    GridCacheReturnCompletableWrapper wrapper = this.cctx.tm().getCommittedTxReturn(this.tx.xidVersion());
                                    assert (wrapper != null) : this.tx.xidVersion();
                                    GridCacheReturn retVal = wrapper.fut().get();
                                    assert (retVal != null);
                                    this.tx.implicitSingleResult(retVal);
                                }
                                if (this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC) {
                                    GridCacheVersion nearXidVer = this.tx.nearXidVersion();
                                    assert (nearXidVer != null) : this.tx;
                                    IgniteInternalFuture<?> fut = this.cctx.tm().remoteTxFinishFuture(nearXidVer);
                                    fut.listen(new CI1<IgniteInternalFuture<?>>(){

                                        @Override
                                        public void apply(IgniteInternalFuture<?> fut) {
                                            mini.onDone(GridNearTxFinishFuture.this.tx);
                                        }
                                    });
                                    return;
                                }
                                mini.onDone(this.tx);
                            }
                            catch (IgniteCheckedException e) {
                                if (msgLog.isDebugEnabled()) {
                                    msgLog.debug("Near finish fut, failed to finish [txId=" + this.tx.nearXidVersion() + ", node=" + backup.id() + ", err=" + e + ']');
                                }
                                mini.onDone(e);
                            }
                        } else {
                            ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Primary node left grid: " + nodeId);
                            cause.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
                            mini.onDone(new IgniteTxRollbackCheckedException("Failed to commit transaction (transaction has been rolled back on backup node): " + this.tx.xidVersion(), cause));
                        }
                    } else {
                        GridDhtTxFinishRequest finishReq = this.checkCommittedRequest(mini.futureId(), false);
                        try {
                            this.cctx.io().send(backup, (GridCacheMessage)finishReq, this.tx.ioPolicy());
                            if (msgLog.isDebugEnabled()) {
                                msgLog.debug("Near finish fut, sent check committed request [txId=" + this.tx.nearXidVersion() + ", node=" + backup.id() + ']');
                            }
                        }
                        catch (ClusterTopologyCheckedException ignored) {
                            mini.onNodeLeft(backupId, false);
                        }
                        catch (IgniteCheckedException e) {
                            if (msgLog.isDebugEnabled()) {
                                msgLog.debug("Near finish fut, failed to send check committed request [txId=" + this.tx.nearXidVersion() + ", node=" + backup.id() + ", err=" + e + ']');
                            }
                            mini.onDone(e);
                        }
                    }
                }
            } else {
                this.readyNearMappingFromBackup(mapping);
            }
        }
    }

    private boolean needFinishOnePhase(boolean commit) {
        assert (this.tx.onePhaseCommit());
        if (this.tx.mappings().empty()) {
            return false;
        }
        if (!commit) {
            return true;
        }
        GridDistributedTxMapping mapping = this.tx.mappings().singleMapping();
        assert (mapping != null);
        return mapping.hasNearCacheEntries();
    }

    private void finishOnePhase(boolean commit) {
        IgniteInternalFuture<IgniteInternalTx> fut;
        assert (Thread.holdsLock(this));
        if (this.finishOnePhaseCalled) {
            return;
        }
        this.finishOnePhaseCalled = true;
        GridDistributedTxMapping locMapping = this.mappings.localMapping();
        if (locMapping != null && (fut = this.cctx.tm().txHandler().finishColocatedLocal(commit, this.tx)) != null) {
            this.add(fut);
        }
    }

    private void readyNearMappingFromBackup(GridDistributedTxMapping mapping) {
        if (mapping.hasNearCacheEntries()) {
            GridCacheVersion xidVer = this.tx.xidVersion();
            mapping.dhtVersion(xidVer, xidVer);
            this.tx.readyNearLocks(mapping, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
    }

    private void finish(Iterable<GridDistributedTxMapping> mappings, boolean commit, boolean useCompletedVer) {
        int miniId = 0;
        for (GridDistributedTxMapping m : mappings) {
            this.finish(++miniId, m, commit, useCompletedVer);
        }
    }

    private void finish(int miniId, GridDistributedTxMapping m, boolean commit, boolean useCompletedVer) {
        ClusterNode n = m.primary();
        assert (!m.empty() || m.queryUpdate()) : m + " " + (Object)((Object)this.tx.state());
        CacheWriteSynchronizationMode syncMode = this.tx.syncMode();
        if (m.explicitLock() || m.queryUpdate()) {
            syncMode = CacheWriteSynchronizationMode.FULL_SYNC;
        }
        GridNearTxFinishRequest req = new GridNearTxFinishRequest(this.futId, this.tx.xidVersion(), this.tx.threadId(), commit, this.tx.isInvalidate(), this.tx.system(), this.tx.ioPolicy(), syncMode, m.explicitLock(), this.tx.storeEnabled(), this.tx.topologyVersion(), null, null, null, this.tx.size(), this.tx.taskNameHash(), this.tx.mvccSnapshot(), this.tx.activeCachesDeploymentEnabled());
        if (n.isLocal()) {
            req.miniId(miniId);
            IgniteInternalFuture<IgniteInternalTx> fut = this.cctx.tm().txHandler().finish(n.id(), this.tx, req);
            if (fut != null && syncMode == CacheWriteSynchronizationMode.FULL_SYNC) {
                this.add(fut);
            }
        } else {
            FinishMiniFuture fut = new FinishMiniFuture(miniId, m);
            req.miniId(fut.futureId());
            this.add(fut);
            try {
                boolean wait;
                this.cctx.tm().sendTransactionMessage(n, (GridCacheMessage)req, (IgniteInternalTx)this.tx, this.tx.ioPolicy());
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near finish fut, sent request [txId=" + this.tx.nearXidVersion() + ", node=" + n.id() + ']');
                }
                boolean bl = wait = syncMode != CacheWriteSynchronizationMode.FULL_ASYNC;
                if (!wait) {
                    fut.onDone();
                }
            }
            catch (ClusterTopologyCheckedException ignored) {
                this.mappings.remove(m.primary().id());
                fut.onNodeLeft(n.id(), false);
            }
            catch (IgniteCheckedException e) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near finish fut, failed to send request [txId=" + this.tx.nearXidVersion() + ", node=" + n.id() + ", err=" + e + ']');
                }
                fut.onDone(e);
            }
        }
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                if (f.getClass() == FinishMiniFuture.class) {
                    FinishMiniFuture fut = (FinishMiniFuture)f;
                    ClusterNode node = fut.primary();
                    if (node != null) {
                        return "FinishFuture[node=" + node.id() + ", loc=" + node.isLocal() + ", done=" + fut.isDone() + ']';
                    }
                    return "FinishFuture[node=null, done=" + fut.isDone() + ']';
                }
                if (f.getClass() == CheckBackupMiniFuture.class) {
                    CheckBackupMiniFuture fut = (CheckBackupMiniFuture)f;
                    ClusterNode node = fut.node();
                    if (node != null) {
                        return "CheckBackupFuture[node=" + node.id() + ", loc=" + node.isLocal() + ", done=" + f.isDone() + "]";
                    }
                    return "CheckBackupFuture[node=null, done=" + f.isDone() + "]";
                }
                if (f.getClass() == CheckRemoteTxMiniFuture.class) {
                    CheckRemoteTxMiniFuture fut = (CheckRemoteTxMiniFuture)f;
                    return "CheckRemoteTxMiniFuture[nodes=" + fut.nodes() + ", done=" + f.isDone() + "]";
                }
                if (f instanceof MvccFuture) {
                    MvccFuture fut = (MvccFuture)f;
                    return "WaitPreviousTxsFut[mvccCrd=" + fut.coordinatorNodeId() + ", done=" + f.isDone() + "]";
                }
                return "[loc=true, done=" + f.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridNearTxFinishFuture.class, this, "innerFuts", futs, "super", (Object)super.toString());
    }

    private GridDhtTxFinishRequest checkCommittedRequest(int miniId, boolean waitRemoteTxs) {
        GridDhtTxFinishRequest finishReq = new GridDhtTxFinishRequest(this.cctx.localNodeId(), this.futureId(), miniId, this.tx.topologyVersion(), this.tx.xidVersion(), this.tx.commitVersion(), this.tx.threadId(), this.tx.isolation(), true, false, this.tx.system(), this.tx.ioPolicy(), false, this.tx.syncMode(), null, null, null, null, 0, 0, this.tx.activeCachesDeploymentEnabled(), !waitRemoteTxs && this.tx.needReturnValue() && this.tx.implicit(), waitRemoteTxs, null, null);
        finishReq.checkCommitted(true);
        return finishReq;
    }

    private class CheckRemoteTxMiniFuture
    extends MinFuture {
        private Set<UUID> nodes;

        CheckRemoteTxMiniFuture(int futId, Set<UUID> nodes) {
            super(futId);
            this.nodes = nodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<UUID> nodes() {
            CheckRemoteTxMiniFuture checkRemoteTxMiniFuture = this;
            synchronized (checkRemoteTxMiniFuture) {
                return new HashSet<UUID>(this.nodes);
            }
        }

        @Override
        boolean onNodeLeft(UUID nodeId, boolean discoThread) {
            return this.onResponse(nodeId);
        }

        void onDhtFinishResponse(UUID nodeId, boolean discoThread) {
            this.onResponse(nodeId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onResponse(UUID nodeId) {
            boolean done;
            boolean ret;
            CheckRemoteTxMiniFuture checkRemoteTxMiniFuture = this;
            synchronized (checkRemoteTxMiniFuture) {
                ret = this.nodes.remove(nodeId);
                done = this.nodes.isEmpty();
            }
            if (done) {
                this.onDone(GridNearTxFinishFuture.this.tx);
            }
            return ret;
        }

        @Override
        public String toString() {
            return S.toString(CheckRemoteTxMiniFuture.class, this);
        }
    }

    private class CheckBackupMiniFuture
    extends MinFuture {
        @GridToStringInclude
        private GridDistributedTxMapping m;
        private ClusterNode backup;

        CheckBackupMiniFuture(int futId, ClusterNode backup, GridDistributedTxMapping m) {
            super(futId);
            this.backup = backup;
            this.m = m;
        }

        public ClusterNode node() {
            return this.backup;
        }

        @Override
        boolean onNodeLeft(UUID nodeId, boolean discoThread) {
            if (nodeId.equals(this.backup.id())) {
                GridNearTxFinishFuture.this.readyNearMappingFromBackup(this.m);
                this.onDone(new ClusterTopologyCheckedException("Remote node left grid: " + nodeId));
                return true;
            }
            return false;
        }

        void onDhtFinishResponse(GridDhtTxFinishResponse res) {
            GridNearTxFinishFuture.this.readyNearMappingFromBackup(this.m);
            Throwable err = res.checkCommittedError();
            if (err != null) {
                ClusterTopologyCheckedException cause;
                if (err instanceof IgniteCheckedException && (cause = ((IgniteCheckedException)err).getCause(ClusterTopologyCheckedException.class)) != null) {
                    cause.retryReadyFuture(GridNearTxFinishFuture.this.cctx.nextAffinityReadyFuture(GridNearTxFinishFuture.this.tx.topologyVersion()));
                }
                this.onDone(err);
            } else {
                this.onDone(GridNearTxFinishFuture.this.tx);
            }
        }
    }

    private class FinishMiniFuture
    extends MinFuture {
        @GridToStringInclude
        private GridDistributedTxMapping m;

        FinishMiniFuture(int futId, GridDistributedTxMapping m) {
            super(futId);
            this.m = m;
        }

        ClusterNode primary() {
            return this.m.primary();
        }

        public GridDistributedTxMapping mapping() {
            return this.m;
        }

        @Override
        boolean onNodeLeft(UUID nodeId, boolean discoThread) {
            if ((GridNearTxFinishFuture.this.tx.state() == TransactionState.COMMITTING || GridNearTxFinishFuture.this.tx.state() == TransactionState.COMMITTED) && Stream.concat(Stream.of(this.m.primary().id()), ((Collection)GridNearTxFinishFuture.this.tx.transactionNodes().getOrDefault(this.m.primary().id(), Collections.emptySet())).stream()).noneMatch(uuid -> GridNearTxFinishFuture.this.cctx.discovery().alive((UUID)uuid))) {
                this.onDone(new CacheInvalidStateException(GridNearTxFinishFuture.ALL_PARTITION_OWNERS_LEFT_GRID_MSG + this.m.entries().stream().map(e -> " [cacheName=" + e.cached().context().name() + ", partition=" + e.key().partition() + (S.includeSensitive() ? ", key=" + e.key() : "") + "]").findFirst().orElse("")));
                return true;
            }
            if (nodeId.equals(this.m.primary().id())) {
                Collection<UUID> backups;
                Map<UUID, Collection<UUID>> txNodes;
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near finish fut, mini future node left [txId=" + GridNearTxFinishFuture.this.tx.nearXidVersion() + ", node=" + this.m.primary().id() + ']');
                }
                if (GridNearTxFinishFuture.this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC && (txNodes = GridNearTxFinishFuture.this.tx.transactionNodes()) != null && !F.isEmpty(backups = txNodes.get(nodeId))) {
                    final CheckRemoteTxMiniFuture mini = (CheckRemoteTxMiniFuture)GridNearTxFinishFuture.this.compoundsLockedExclusively(() -> {
                        int futId = Integer.MIN_VALUE + GridNearTxFinishFuture.this.futuresCountNoLock();
                        CheckRemoteTxMiniFuture miniFut = new CheckRemoteTxMiniFuture(futId, new HashSet<UUID>(backups));
                        GridNearTxFinishFuture.this.add(miniFut);
                        return miniFut;
                    });
                    GridDhtTxFinishRequest req = GridNearTxFinishFuture.this.checkCommittedRequest(mini.futureId(), true);
                    for (UUID backupId : backups) {
                        ClusterNode backup = GridNearTxFinishFuture.this.cctx.discovery().node(backupId);
                        if (backup != null) {
                            if (backup.isLocal()) {
                                IgniteInternalFuture<?> fut = GridNearTxFinishFuture.this.cctx.tm().remoteTxFinishFuture(GridNearTxFinishFuture.this.tx.nearXidVersion());
                                fut.listen(new CI1<IgniteInternalFuture<?>>(){

                                    @Override
                                    public void apply(IgniteInternalFuture<?> fut) {
                                        mini.onDhtFinishResponse(GridNearTxFinishFuture.this.cctx.localNodeId(), true);
                                    }
                                });
                                continue;
                            }
                            try {
                                GridNearTxFinishFuture.this.cctx.io().send(backup, (GridCacheMessage)req, GridNearTxFinishFuture.this.tx.ioPolicy());
                            }
                            catch (ClusterTopologyCheckedException ignored) {
                                mini.onNodeLeft(backupId, discoThread);
                            }
                            catch (IgniteCheckedException e2) {
                                mini.onDone(e2);
                            }
                            continue;
                        }
                        mini.onDhtFinishResponse(backupId, true);
                    }
                }
                this.onDone(GridNearTxFinishFuture.this.tx);
                return true;
            }
            return false;
        }

        void onNearFinishResponse(GridNearTxFinishResponse res) {
            if (res.error() != null) {
                if (res.error() instanceof IgniteTxRollbackCheckedException) {
                    if (log.isDebugEnabled()) {
                        log.debug("Transaction was rolled back: " + GridNearTxFinishFuture.this.tx);
                    }
                    this.onDone(GridNearTxFinishFuture.this.tx);
                } else {
                    this.onDone(res.error());
                }
            } else {
                this.onDone(GridNearTxFinishFuture.this.tx);
            }
        }

        @Override
        public String toString() {
            return S.toString(FinishMiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", (Object)this.isCancelled(), "err", (Object)this.error());
        }
    }

    private abstract class MinFuture
    extends GridFutureAdapter<IgniteInternalTx> {
        private final int futId;

        MinFuture(int futId) {
            this.futId = futId;
        }

        abstract boolean onNodeLeft(UUID var1, boolean var2);

        final int futureId() {
            return this.futId;
        }
    }
}

