/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cdc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.util.typedef.T2;

public class CdcConsumerState {
    public static final String WAL_STATE_FILE_NAME = "cdc-wal-state.bin";
    public static final String TYPES_STATE_FILE_NAME = "cdc-types-state.bin";
    public static final String MAPPINGS_STATE_FILE_NAME = "cdc-mappings-state.bin";
    public static final String CACHES_STATE_FILE_NAME = "cdc-caches-state.bin";
    private final IgniteLogger log;
    private final Path walPtr;
    private final Path tmpWalPtr;
    private final Path types;
    private final Path tmpTypes;
    private final Path mappings;
    private final Path tmpMappings;
    private final Path caches;
    private final Path tmpCaches;

    public CdcConsumerState(IgniteLogger log, Path stateDir) {
        this.log = log.getLogger(CdcConsumerState.class);
        this.walPtr = stateDir.resolve(WAL_STATE_FILE_NAME);
        this.tmpWalPtr = stateDir.resolve("cdc-wal-state.bin.tmp");
        this.types = stateDir.resolve(TYPES_STATE_FILE_NAME);
        this.tmpTypes = stateDir.resolve("cdc-types-state.bin.tmp");
        this.mappings = stateDir.resolve(MAPPINGS_STATE_FILE_NAME);
        this.tmpMappings = stateDir.resolve("cdc-mappings-state.bin.tmp");
        this.caches = stateDir.resolve(CACHES_STATE_FILE_NAME);
        this.tmpCaches = stateDir.resolve("cdc-caches-state.bin.tmp");
    }

    public void saveWal(T2<WALPointer, Integer> state) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(((WALPointer)state.get1()).index());
        buf.putInt(((WALPointer)state.get1()).fileOffset());
        buf.putInt((Integer)state.get2());
        buf.flip();
        try (FileChannel ch = FileChannel.open(this.tmpWalPtr, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            ch.write(buf);
            ch.force(true);
        }
        Files.move(this.tmpWalPtr, this.walPtr, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    public void saveTypes(Map<Integer, Long> typesState) throws IOException {
        this.save(typesState, this.tmpTypes, this.types);
    }

    public void saveMappings(Set<T2<Integer, Byte>> mappingsState) throws IOException {
        this.save(mappingsState, this.tmpMappings, this.mappings);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T2<WALPointer, Integer> loadWalState() {
        T2<WALPointer, Integer> state;
        if (!Files.exists(this.walPtr, new LinkOption[0])) {
            return null;
        }
        try (FileChannel ch = FileChannel.open(this.walPtr, StandardOpenOption.READ);){
            ByteBuffer buf = ByteBuffer.allocate(16);
            int read = ch.read(buf);
            if (read != 16) {
                T2<WALPointer, Integer> t2 = null;
                return t2;
            }
            buf.flip();
            long idx = buf.getLong();
            int offset = buf.getInt();
            int entryIdx = buf.getInt();
            state = new T2<WALPointer, Integer>(new WALPointer(idx, offset, 0), entryIdx);
        }
        catch (IOException e) {
            throw new IgniteException("Failed to read state [file=" + this.walPtr + ']', e);
        }
        if (!this.log.isInfoEnabled()) return state;
        this.log.info("Initial WAL state loaded [ptr=" + state.get1() + ", idx=" + state.get2() + ']');
        return state;
    }

    public Map<Integer, Long> loadCaches() {
        Map state = this.load(this.caches, HashMap::new);
        this.log.info("Initial caches state loaded [cachesCnt=" + state.size() + ']');
        if (this.log.isDebugEnabled()) {
            for (Map.Entry entry : state.entrySet()) {
                this.log.debug("Cache [cacheId=" + entry.getKey() + ", lastModified=" + entry.getValue() + ']');
            }
        }
        return state;
    }

    public void saveCaches(Map<Integer, Long> cachesState) throws IOException {
        this.save(cachesState, this.tmpCaches, this.caches);
    }

    public Set<T2<Integer, Byte>> loadMappingsState() {
        Set state = this.load(this.mappings, HashSet::new);
        assert (state != null);
        this.log.info("Initial mappings state loaded [mappingsCnt=" + state.size() + ']');
        if (this.log.isDebugEnabled()) {
            for (T2 m : state) {
                this.log.debug("Mapping [typeId=" + m.get1() + ", platform=" + m.get2() + ']');
            }
        }
        return state;
    }

    public Map<Integer, Long> loadTypesState() {
        Map state = this.load(this.types, HashMap::new);
        assert (state != null);
        this.log.info("Initial types state loaded [typesCnt=" + state.size() + ']');
        if (this.log.isDebugEnabled()) {
            for (Map.Entry e : state.entrySet()) {
                this.log.debug("Type [typeId=" + e.getKey() + ", lastModified=" + e.getValue() + ']');
            }
        }
        return state;
    }

    private <T> void save(T state, Path tmp, Path file) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(tmp, new OpenOption[0]));){
            oos.writeObject(state);
        }
        Files.move(tmp, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <D> D load(Path state, Supplier<D> dflt) {
        if (!Files.exists(state, new LinkOption[0])) {
            return dflt.get();
        }
        try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(state, new OpenOption[0]));){
            Object object = ois.readObject();
            return (D)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

