/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.parquet.writer.ColumnChunk;
import io.trino.parquet.writer.ColumnWriter;
import io.trino.parquet.writer.repdef.DefLevelWriterProvider;
import io.trino.parquet.writer.repdef.DefLevelWriterProviders;
import io.trino.parquet.writer.repdef.RepLevelWriterProvider;
import io.trino.parquet.writer.repdef.RepLevelWriterProviders;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class ArrayColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ArrayColumnWriter.class);
    private final ColumnWriter elementWriter;
    private final int maxDefinitionLevel;
    private final int maxRepetitionLevel;

    public ArrayColumnWriter(ColumnWriter elementWriter, int maxDefinitionLevel, int maxRepetitionLevel) {
        this.elementWriter = Objects.requireNonNull(elementWriter, "elementWriter is null");
        this.maxDefinitionLevel = maxDefinitionLevel;
        this.maxRepetitionLevel = maxRepetitionLevel;
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)columnChunk.getBlock());
        this.elementWriter.writeBlock(new ColumnChunk(columnarArray.getElementsBlock(), (List<DefLevelWriterProvider>)ImmutableList.builder().addAll(columnChunk.getDefLevelWriterProviders()).add((Object)DefLevelWriterProviders.of(columnarArray, this.maxDefinitionLevel)).build(), (List<RepLevelWriterProvider>)ImmutableList.builder().addAll(columnChunk.getRepLevelWriterProviders()).add((Object)RepLevelWriterProviders.of(columnarArray, this.maxRepetitionLevel)).build()));
    }

    @Override
    public void close() {
        this.elementWriter.close();
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        return ImmutableList.copyOf(this.elementWriter.getBuffer());
    }

    @Override
    public long getBufferedBytes() {
        return this.elementWriter.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.elementWriter.getRetainedBytes();
    }
}

