/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.DeltaBinaryPackedDecoders;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.BinaryBuffer;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.util.Objects;

public class DeltaLengthByteArrayDecoders {
    private DeltaLengthByteArrayDecoders() {
    }

    private static int[] readInputLengths(SimpleSliceInputStream input) {
        DeltaBinaryPackedDecoders.DeltaBinaryPackedIntDecoder decoder = new DeltaBinaryPackedDecoders.DeltaBinaryPackedIntDecoder();
        decoder.init(input);
        int valueCount = decoder.getValueCount();
        int[] lengths = new int[valueCount];
        decoder.read(lengths, 0, valueCount);
        return lengths;
    }

    private static abstract class AbstractDeltaLengthDecoder
    implements ValueDecoder<BinaryBuffer> {
        private int[] inputLengths;
        private int inputLengthsOffset;
        private SimpleSliceInputStream input;

        private AbstractDeltaLengthDecoder() {
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
            this.inputLengths = DeltaLengthByteArrayDecoders.readInputLengths(input);
        }

        @Override
        public void skip(int n) {
            int totalInputLength = this.getInputLength(n);
            this.input.skip(totalInputLength);
            this.inputLengthsOffset += n;
        }

        protected abstract int truncatedLength(Slice var1, int var2, int var3);

        protected int getInputLength(int length) {
            int totalInputLength = 0;
            for (int i = 0; i < length; ++i) {
                totalInputLength += this.inputLengths[this.inputLengthsOffset + i];
            }
            return totalInputLength;
        }

        protected InputLengths getInputAndMaxLength(int length) {
            int totalInputLength = 0;
            int maxLength = 0;
            for (int i = 0; i < length; ++i) {
                int inputLength = this.inputLengths[this.inputLengthsOffset + i];
                totalInputLength += inputLength;
                maxLength = Math.max(maxLength, inputLength);
            }
            return new InputLengths(totalInputLength, maxLength);
        }

        protected void readUnbounded(BinaryBuffer values, int offset, int length, int totalInputLength) {
            values.addChunk(this.input.readSlice(totalInputLength));
            int[] outputOffsets = values.getOffsets();
            int outputLength = 0;
            int baseOutputOffset = outputOffsets[offset];
            for (int i = 0; i < length; ++i) {
                outputOffsets[offset + i + 1] = baseOutputOffset + (outputLength += this.inputLengths[this.inputLengthsOffset + i]);
            }
            this.inputLengthsOffset += length;
        }

        protected void readBounded(BinaryBuffer values, int offset, int length, int totalInputLength) {
            int[] outputOffsets = values.getOffsets();
            Slice inputSlice = this.input.readSlice(totalInputLength);
            int currentInputOffset = 0;
            int totalOutputLength = 0;
            int baseOutputOffset = outputOffsets[offset];
            for (int i = 0; i < length; ++i) {
                int currentLength = this.inputLengths[this.inputLengthsOffset + i];
                int currentOutputLength = this.truncatedLength(inputSlice, currentInputOffset, currentLength);
                currentInputOffset += currentLength;
                outputOffsets[offset + i + 1] = baseOutputOffset + (totalOutputLength += currentOutputLength);
            }
            if (totalOutputLength == totalInputLength) {
                values.addChunk(inputSlice);
            } else {
                values.addChunk(this.createOutputBuffer(outputOffsets, offset, length, inputSlice, totalOutputLength));
            }
            this.inputLengthsOffset += length;
        }

        private Slice createOutputBuffer(int[] outputOffsets, int offset, int length, Slice inputSlice, int totalOutputLength) {
            byte[] output = new byte[totalOutputLength];
            int outputOffset = 0;
            int outputLength = 0;
            int currentInputOffset = 0;
            int inputLength = 0;
            for (int i = 0; i < length; ++i) {
                if ((outputLength += outputOffsets[offset + i + 1] - outputOffsets[offset + i]) == (inputLength += this.inputLengths[this.inputLengthsOffset + i])) continue;
                inputSlice.getBytes(currentInputOffset, output, outputOffset, outputLength);
                currentInputOffset += inputLength;
                inputLength = 0;
                outputOffset += outputLength;
                outputLength = 0;
            }
            if (outputLength != 0) {
                inputSlice.getBytes(currentInputOffset, output, outputOffset, outputLength);
            }
            return Slices.wrappedBuffer((byte[])output);
        }

        protected record InputLengths(int totalInputLength, int maxInputLength) {
        }
    }

    public static final class BinaryDeltaLengthDecoder
    extends AbstractDeltaLengthDecoder {
        @Override
        protected int truncatedLength(Slice slice, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void read(BinaryBuffer values, int offset, int length) {
            int totalInputLength = this.getInputLength(length);
            this.readUnbounded(values, offset, length, totalInputLength);
        }
    }

    public static final class CharDeltaLengthDecoder
    extends AbstractDeltaLengthDecoder {
        private final int maxLength;

        public CharDeltaLengthDecoder(CharType charType) {
            this.maxLength = charType.getLength();
        }

        @Override
        public void read(BinaryBuffer values, int offset, int length) {
            int totalInputLength = this.getInputLength(length);
            this.readBounded(values, offset, length, totalInputLength);
        }

        @Override
        protected int truncatedLength(Slice slice, int offset, int length) {
            return Chars.byteCountWithoutTrailingSpace((Slice)slice, (int)offset, (int)length, (int)this.maxLength);
        }
    }

    public static final class BoundedVarcharDeltaLengthDecoder
    extends AbstractDeltaLengthDecoder {
        private final int boundedLength;

        public BoundedVarcharDeltaLengthDecoder(VarcharType varcharType) {
            Preconditions.checkArgument((!varcharType.isUnbounded() ? 1 : 0) != 0, (String)"Trino type %s is not a bounded varchar", (Object)varcharType);
            this.boundedLength = varcharType.getBoundedLength();
        }

        @Override
        public void read(BinaryBuffer values, int offset, int length) {
            boolean truncate;
            AbstractDeltaLengthDecoder.InputLengths lengths = this.getInputAndMaxLength(length);
            int maxLength = lengths.maxInputLength();
            int totalInputLength = lengths.totalInputLength();
            boolean bl = truncate = maxLength > this.boundedLength;
            if (truncate) {
                this.readBounded(values, offset, length, totalInputLength);
            } else {
                this.readUnbounded(values, offset, length, totalInputLength);
            }
        }

        @Override
        protected int truncatedLength(Slice slice, int offset, int length) {
            return Varchars.byteCount((Slice)slice, (int)offset, (int)length, (int)this.boundedLength);
        }
    }
}

