/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.dictionary;

import com.google.common.base.MoreObjects;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.dictionary.Dictionary;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.PlainValueDecoders;

public class LongDictionary
implements Dictionary {
    private final long[] content;

    public LongDictionary(DictionaryPage dictionaryPage) {
        this.content = new long[dictionaryPage.getDictionarySize()];
        PlainValueDecoders.LongPlainValueDecoder longReader = new PlainValueDecoders.LongPlainValueDecoder();
        longReader.init(new SimpleSliceInputStream(dictionaryPage.getSlice()));
        longReader.read(this.content, 0, dictionaryPage.getDictionarySize());
    }

    @Override
    public long decodeToLong(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }
}

