/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.dictionary;

import com.google.common.base.MoreObjects;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.dictionary.Dictionary;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.PlainValueDecoders;

public class IntegerDictionary
implements Dictionary {
    private final int[] content;

    public IntegerDictionary(DictionaryPage dictionaryPage) {
        this.content = new int[dictionaryPage.getDictionarySize()];
        PlainValueDecoders.IntPlainValueDecoder intReader = new PlainValueDecoders.IntPlainValueDecoder();
        intReader.init(new SimpleSliceInputStream(dictionaryPage.getSlice()));
        intReader.read(this.content, 0, dictionaryPage.getDictionarySize());
    }

    @Override
    public int decodeToInt(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }
}

