/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;

public class BasicStatsWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isExplicitAnalyze;
    private BaseSemanticAnalyzer.TableSpec tableSpecs;
    private LoadTableDesc loadTableDesc;
    private LoadFileDesc loadFileDesc;
    private String aggKey;
    private boolean statsReliable;
    private boolean clearAggregatorStats = false;
    private boolean noStatsAggregator = false;
    private boolean isNoScanAnalyzeCommand = false;
    private transient Task sourceTask;
    private boolean isFollowedByColStats = false;
    private String statsTmpDir;

    public BasicStatsWork() {
    }

    public BasicStatsWork(BaseSemanticAnalyzer.TableSpec tableSpecs) {
        this.tableSpecs = tableSpecs;
    }

    public BasicStatsWork(LoadTableDesc loadTableDesc) {
        this.loadTableDesc = loadTableDesc;
    }

    public BasicStatsWork(LoadFileDesc loadFileDesc) {
        this.loadFileDesc = loadFileDesc;
    }

    public BaseSemanticAnalyzer.TableSpec getTableSpecs() {
        return this.tableSpecs;
    }

    public LoadTableDesc getLoadTableDesc() {
        return this.loadTableDesc;
    }

    public LoadFileDesc getLoadFileDesc() {
        return this.loadFileDesc;
    }

    public void setAggKey(String aggK) {
        this.aggKey = aggK;
    }

    @Explain(displayName="Stats Aggregation Key Prefix", explainLevels={Explain.Level.EXTENDED})
    public String getAggKey() {
        return this.aggKey;
    }

    public String getStatsTmpDir() {
        return this.statsTmpDir;
    }

    public void setStatsTmpDir(String statsTmpDir) {
        this.statsTmpDir = statsTmpDir;
    }

    public boolean getNoStatsAggregator() {
        return this.noStatsAggregator;
    }

    public void setNoStatsAggregator(boolean noStatsAggregator) {
        this.noStatsAggregator = noStatsAggregator;
    }

    public boolean isStatsReliable() {
        return this.statsReliable;
    }

    public void setStatsReliable(boolean statsReliable) {
        this.statsReliable = statsReliable;
    }

    public boolean isClearAggregatorStats() {
        return this.clearAggregatorStats;
    }

    public void setClearAggregatorStats(boolean clearAggregatorStats) {
        this.clearAggregatorStats = clearAggregatorStats;
    }

    public boolean isNoScanAnalyzeCommand() {
        return this.isNoScanAnalyzeCommand;
    }

    public void setNoScanAnalyzeCommand(boolean isNoScanAnalyzeCommand) {
        this.isNoScanAnalyzeCommand = isNoScanAnalyzeCommand;
    }

    public Task getSourceTask() {
        return this.sourceTask;
    }

    public void setSourceTask(Task sourceTask) {
        this.sourceTask = sourceTask;
    }

    public boolean isFollowedByColStats1() {
        return this.isFollowedByColStats;
    }

    public void setFollowedByColStats1(boolean isFollowedByColStats) {
        this.isFollowedByColStats = isFollowedByColStats;
    }

    public boolean isExplicitAnalyze() {
        return this.isExplicitAnalyze;
    }

    public boolean isTargetRewritten() {
        if (this.isExplicitAnalyze()) {
            return true;
        }
        LoadTableDesc ltd = this.getLoadTableDesc();
        if (ltd != null && (ltd.getLoadFileType() == LoadTableDesc.LoadFileType.REPLACE_ALL || ltd.isInsertOverwrite())) {
            return true;
        }
        if (this.getLoadFileDesc() != null && this.getLoadFileDesc().getCtasCreateTableDesc() != null) {
            return true;
        }
        return this.getLoadFileDesc() != null && this.getLoadFileDesc().getCreateViewDesc() != null;
    }

    public String getTableName() {
        BasicStatsWork work = this;
        if (work.getLoadTableDesc() != null) {
            return work.getLoadTableDesc().getTable().getTableName();
        }
        if (work.getTableSpecs() != null) {
            return work.getTableSpecs().tableName;
        }
        if (this.getLoadFileDesc().getCtasCreateTableDesc() != null) {
            return this.getLoadFileDesc().getCtasCreateTableDesc().getTableName();
        }
        return this.getLoadFileDesc().getCreateViewDesc().getViewName();
    }

    public void setIsExplicitAnalyze(boolean b) {
        this.isExplicitAnalyze = b;
    }
}

