/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlOperator;

public final class JDBCRexCallValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCRexCallValidator.class);

    private JDBCRexCallValidator() {
    }

    public static boolean isValidJdbcOperation(RexNode cond, SqlDialect dialect) {
        return new JdbcRexCallValidatorVisitor(dialect).go(cond);
    }

    private static final class JdbcRexCallValidatorVisitor
    extends RexVisitorImpl<Void> {
        private final SqlDialect dialect;
        boolean res = true;

        private JdbcRexCallValidatorVisitor(SqlDialect dialect) {
            super(true);
            this.dialect = dialect;
        }

        private boolean validRexCall(RexCall call) {
            if (call instanceof RexOver) {
                LOG.debug("RexOver operator push down is not supported for now with the following operator:" + call);
                return false;
            }
            SqlOperator operator = call.getOperator();
            List operands = call.getOperands();
            RelDataType resType = call.getType();
            ArrayList<RelDataType> paramsListType = new ArrayList<RelDataType>();
            for (RexNode currNode : operands) {
                paramsListType.add(currNode.getType());
            }
            return this.dialect.supportsFunction(operator, resType, paramsListType);
        }

        public Void visitCall(RexCall call) {
            if (this.res) {
                this.res = this.validRexCall(call);
                if (this.res) {
                    return (Void)super.visitCall(call);
                }
            }
            return null;
        }

        private boolean go(RexNode cond) {
            cond.accept((RexVisitor)this);
            return this.res;
        }
    }
}

