/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.timestamp;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;

public final class NanoTimeUtils {
    private static final int JULIAN_EPOCH_OFFSET_DAYS = 2440588;
    private static final long SECONDS_PER_DAY = 86400L;

    private NanoTimeUtils() {
    }

    public static NanoTime getNanoTime(Timestamp timestamp, boolean ignored) {
        long epochSeconds = timestamp.toEpochSecond();
        int epochDay = Math.toIntExact(Math.floorDiv(epochSeconds, 86400L));
        int julianDay = 2440588 + epochDay;
        long timeOfDaySeconds = Math.floorMod(epochSeconds, 86400L);
        long timeOfDayNanos = TimeUnit.SECONDS.toNanos(timeOfDaySeconds) + (long)timestamp.getNanos();
        return new NanoTime(julianDay, timeOfDayNanos);
    }
}

