/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;

public class VectorMapJoinLeftSemiMultiKeyOperator
extends VectorMapJoinLeftSemiGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorMapJoinLeftSemiMultiKeyOperator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(CLASS_NAME);
    private transient VectorMapJoinBytesHashSet hashSet;
    private transient VectorSerializeRow keyVectorSerializeWrite;
    private transient ByteStream.Output currentKeyOutput;
    private transient ByteStream.Output saveKeyOutput;

    @Override
    protected String getLoggingPrefix() {
        return super.getLoggingPrefix(CLASS_NAME);
    }

    protected VectorMapJoinLeftSemiMultiKeyOperator() {
    }

    public VectorMapJoinLeftSemiMultiKeyOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinLeftSemiMultiKeyOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            boolean allKeyInputColumnsRepeating;
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.keyVectorSerializeWrite = new VectorSerializeRow<BinarySortableSerializeWrite>(new BinarySortableSerializeWrite(this.bigTableKeyColumnMap.length));
                this.keyVectorSerializeWrite.init(this.bigTableKeyTypeInfos, this.bigTableKeyColumnMap);
                this.currentKeyOutput = new ByteStream.Output();
                this.saveKeyOutput = new ByteStream.Output();
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashSet = (VectorMapJoinBytesHashSet)this.vectorMapJoinHashTable;
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " empty");
                }
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            if (this.bigTableKeyColumnMap.length == 0) {
                allKeyInputColumnsRepeating = false;
            } else {
                allKeyInputColumnsRepeating = true;
                for (int i = 0; i < this.bigTableKeyColumnMap.length; ++i) {
                    if (batch.cols[this.bigTableKeyColumnMap[i]].isRepeating) continue;
                    allKeyInputColumnsRepeating = false;
                    break;
                }
            }
            if (allKeyInputColumnsRepeating) {
                JoinUtil.JoinResult joinResult;
                this.keyVectorSerializeWrite.setOutput(this.currentKeyOutput);
                this.keyVectorSerializeWrite.serializeWrite(batch, 0);
                if (this.keyVectorSerializeWrite.getHasAnyNulls()) {
                    joinResult = JoinUtil.JoinResult.NOMATCH;
                } else {
                    byte[] keyBytes = this.currentKeyOutput.getData();
                    int keyLength = this.currentKeyOutput.getLength();
                    joinResult = this.hashSet.contains(keyBytes, 0, keyLength, this.hashSetResults[0]);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name());
                }
                this.finishLeftSemiRepeated(batch, joinResult, this.hashSetResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated");
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashSetResultCount = 0;
                int allMatchCount = 0;
                int spillCount = 0;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block22: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    this.keyVectorSerializeWrite.setOutput(this.currentKeyOutput);
                    this.keyVectorSerializeWrite.serializeWrite(batch, batchIndex);
                    boolean isAnyNull = this.keyVectorSerializeWrite.getHasAnyNulls();
                    if (isAnyNull || !haveSaveKey || !this.saveKeyOutput.arraysEquals(this.currentKeyOutput)) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    break;
                                }
                                case SPILL: {
                                    ++hashSetResultCount;
                                    break;
                                }
                            }
                        }
                        if (isAnyNull) {
                            saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                            haveSaveKey = false;
                        } else {
                            haveSaveKey = true;
                            ByteStream.Output temp = this.saveKeyOutput;
                            this.saveKeyOutput = this.currentKeyOutput;
                            this.currentKeyOutput = temp;
                            byte[] keyBytes = this.saveKeyOutput.getData();
                            int keyLength = this.saveKeyOutput.getLength();
                            saveJoinResult = this.hashSet.contains(keyBytes, 0, keyLength, this.hashSetResults[hashSetResultCount]);
                        }
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashSetResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block22;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashSetResultCount;
                            ++spillCount;
                            continue block22;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            break;
                        }
                        case SPILL: {
                            ++hashSetResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " allMatchs " + VectorMapJoinLeftSemiMultiKeyOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " spills " + VectorMapJoinLeftSemiMultiKeyOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinLeftSemiMultiKeyOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashSetResults, 0, hashSetResultCount)));
                }
                this.finishLeftSemi(batch, allMatchCount, spillCount, this.hashSetResults);
            }
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

