/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import io.trino.hive.$internal.org.apache.commons.lang.ArrayUtils;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexBaseScalar;

public class VectorUDFMapIndexStringScalar
extends VectorUDFMapIndexBaseScalar {
    private byte[] key;

    public VectorUDFMapIndexStringScalar() {
    }

    public VectorUDFMapIndexStringScalar(int mapColumnNum, byte[] key, int outputColumnNum) {
        super(mapColumnNum, outputColumnNum);
        this.key = key;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.getMapColumnNum()) + ", key: " + new String(this.key);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.MAP, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }

    @Override
    protected Object getKeyByIndex(ColumnVector cv, int index) {
        BytesColumnVector bytesCV = (BytesColumnVector)cv;
        return ArrayUtils.subarray(bytesCV.vector[index], bytesCV.start[index], bytesCV.start[index] + bytesCV.length[index]);
    }

    @Override
    public Object getCurrentKey(int index) {
        return this.key;
    }

    @Override
    protected boolean compareKeyInternal(Object columnKey, Object otherKey) {
        return Arrays.equals((byte[])columnKey, (byte[])otherKey);
    }
}

