/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncDoubleToDouble;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class PosModDoubleToDouble
extends MathFuncDoubleToDouble {
    private static final long serialVersionUID = 1L;
    private final double divisor;
    private boolean isOutputTypeFloat;

    public PosModDoubleToDouble(int inputCol, double scalarVal, int outputColumnNum) {
        super(inputCol, outputColumnNum);
        this.divisor = scalarVal;
    }

    public PosModDoubleToDouble() {
        this.divisor = 0.0;
    }

    @Override
    public void setOutputTypeInfo(TypeInfo outputTypeInfo) {
        this.outputTypeInfo = outputTypeInfo;
        this.isOutputTypeFloat = outputTypeInfo != null && "float".equals(outputTypeInfo.getTypeName());
    }

    @Override
    protected double func(double v) {
        if (this.isOutputTypeFloat) {
            float castedV = (float)v;
            float castedDivisor = (float)this.divisor;
            return (castedV % castedDivisor + castedDivisor) % castedDivisor;
        }
        return (v % this.divisor + this.divisor) % this.divisor;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", divisor " + this.divisor;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

