/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load;

import io.trino.hive.$internal.org.apache.commons.lang3.StringUtils;
import io.trino.hive.$internal.org.json.JSONObject;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.messaging.AddForeignKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddNotNullConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPrimaryKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddUniqueConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.ConstraintEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadFunction;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.TaskTracker;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddForeignKeyHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddNotNullConstraintHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddPrimaryKeyHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddUniqueConstraintHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class LoadConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(LoadFunction.class);
    private Context context;
    private final ConstraintEvent event;
    private final String dbNameToLoadIn;
    private final TaskTracker tracker;
    private final MessageDeserializer deserializer = MessageFactory.getInstance().getDeserializer();

    public LoadConstraint(Context context, ConstraintEvent event, String dbNameToLoadIn, TaskTracker existingTracker) {
        this.context = context;
        this.event = event;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.tracker = new TaskTracker(existingTracker);
    }

    public TaskTracker tasks() throws IOException, SemanticException {
        URI fromURI = EximUtil.getValidatedURI(this.context.hiveConf, BaseSemanticAnalyzer.stripQuotes(this.event.rootDir().toUri().toString()));
        Path fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
        try {
            FileSystem fs = FileSystem.get((URI)fromPath.toUri(), (Configuration)this.context.hiveConf);
            JSONObject json = new JSONObject(EximUtil.readAsString(fs, fromPath));
            String pksString = json.getString("pks");
            String fksString = json.getString("fks");
            String uksString = json.getString("uks");
            String nnsString = json.getString("nns");
            ArrayList<Task<? extends Serializable>> tasks = new ArrayList<Task<? extends Serializable>>();
            if (pksString != null && !pksString.isEmpty() && !this.isPrimaryKeysAlreadyLoaded(pksString)) {
                AddPrimaryKeyHandler pkHandler = new AddPrimaryKeyHandler();
                DumpMetaData pkDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_PRIMARYKEY, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                pkDumpMetaData.setPayload(pksString);
                tasks.addAll(pkHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, null, fromPath.toString(), null, pkDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG)));
            }
            if (uksString != null && !uksString.isEmpty() && !this.isUniqueConstraintsAlreadyLoaded(uksString)) {
                AddUniqueConstraintHandler ukHandler = new AddUniqueConstraintHandler();
                DumpMetaData ukDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_UNIQUECONSTRAINT, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                ukDumpMetaData.setPayload(uksString);
                tasks.addAll(ukHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, null, fromPath.toString(), null, ukDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG)));
            }
            if (nnsString != null && !nnsString.isEmpty() && !this.isNotNullConstraintsAlreadyLoaded(nnsString)) {
                AddNotNullConstraintHandler nnHandler = new AddNotNullConstraintHandler();
                DumpMetaData nnDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_NOTNULLCONSTRAINT, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                nnDumpMetaData.setPayload(nnsString);
                tasks.addAll(nnHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, null, fromPath.toString(), null, nnDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG)));
            }
            if (fksString != null && !fksString.isEmpty() && !this.isForeignKeysAlreadyLoaded(fksString)) {
                AddForeignKeyHandler fkHandler = new AddForeignKeyHandler();
                DumpMetaData fkDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_FOREIGNKEY, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                fkDumpMetaData.setPayload(fksString);
                tasks.addAll(fkHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, null, fromPath.toString(), null, fkDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG)));
            }
            tasks.forEach(this.tracker::addTask);
            return this.tracker;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
        }
    }

    private boolean isPrimaryKeysAlreadyLoaded(String pksMsgString) throws Exception {
        List<SQLPrimaryKey> pks;
        AddPrimaryKeyMessage msg = this.deserializer.getAddPrimaryKeyMessage(pksMsgString);
        List<SQLPrimaryKey> pksInMsg = msg.getPrimaryKeys();
        if (pksInMsg.isEmpty()) {
            return true;
        }
        String dbName = StringUtils.isBlank(this.dbNameToLoadIn) ? pksInMsg.get(0).getTable_db() : this.dbNameToLoadIn;
        try {
            pks = this.context.hiveDb.getPrimaryKeyList(dbName, pksInMsg.get(0).getTable_name());
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return pks != null && !pks.isEmpty();
    }

    private boolean isForeignKeysAlreadyLoaded(String fksMsgString) throws Exception {
        List<SQLForeignKey> fks;
        AddForeignKeyMessage msg = this.deserializer.getAddForeignKeyMessage(fksMsgString);
        List<SQLForeignKey> fksInMsg = msg.getForeignKeys();
        if (fksInMsg.isEmpty()) {
            return true;
        }
        String dbName = StringUtils.isBlank(this.dbNameToLoadIn) ? fksInMsg.get(0).getFktable_db() : this.dbNameToLoadIn;
        try {
            fks = this.context.hiveDb.getForeignKeyList(dbName, fksInMsg.get(0).getFktable_name());
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return fks != null && !fks.isEmpty();
    }

    private boolean isUniqueConstraintsAlreadyLoaded(String uksMsgString) throws Exception {
        List<SQLUniqueConstraint> uks;
        AddUniqueConstraintMessage msg = this.deserializer.getAddUniqueConstraintMessage(uksMsgString);
        List<SQLUniqueConstraint> uksInMsg = msg.getUniqueConstraints();
        if (uksInMsg.isEmpty()) {
            return true;
        }
        String dbName = StringUtils.isBlank(this.dbNameToLoadIn) ? uksInMsg.get(0).getTable_db() : this.dbNameToLoadIn;
        try {
            uks = this.context.hiveDb.getUniqueConstraintList(dbName, uksInMsg.get(0).getTable_name());
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return uks != null && !uks.isEmpty();
    }

    private boolean isNotNullConstraintsAlreadyLoaded(String nnsMsgString) throws Exception {
        List<SQLNotNullConstraint> nns;
        AddNotNullConstraintMessage msg = this.deserializer.getAddNotNullConstraintMessage(nnsMsgString);
        List<SQLNotNullConstraint> nnsInMsg = msg.getNotNullConstraints();
        if (nnsInMsg.isEmpty()) {
            return true;
        }
        String dbName = StringUtils.isBlank(this.dbNameToLoadIn) ? nnsInMsg.get(0).getTable_db() : this.dbNameToLoadIn;
        try {
            nns = this.context.hiveDb.getNotNullConstraintList(dbName, nnsInMsg.get(0).getTable_name());
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return nns != null && !nns.isEmpty();
    }
}

