/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metrics;

import com.github.joshelser.dropwizard.metrics.hadoop.HadoopMetrics2Reporter;
import io.trino.hive.;
import io.trino.hive.$internal.com.codahale.metrics.ConsoleReporter;
import io.trino.hive.$internal.com.codahale.metrics.Counter;
import io.trino.hive.$internal.com.codahale.metrics.Gauge;
import io.trino.hive.$internal.com.codahale.metrics.JmxReporter;
import io.trino.hive.$internal.com.codahale.metrics.MetricRegistry;
import io.trino.hive.$internal.com.codahale.metrics.Reporter;
import io.trino.hive.$internal.com.codahale.metrics.ScheduledReporter;
import io.trino.hive.$internal.com.codahale.metrics.Timer;
import io.trino.hive.$internal.com.codahale.metrics.jvm.BufferPoolMetricSet;
import io.trino.hive.$internal.com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import io.trino.hive.$internal.com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import io.trino.hive.$internal.com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import io.trino.hive.$internal.com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.JsonReporter;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;

public class Metrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(Metrics.class);
    private static Metrics self;
    private static final AtomicInteger singletonAtomicInteger;
    private final MetricRegistry registry = new MetricRegistry();
    private List<Reporter> reporters;
    private List<ScheduledReporter> scheduledReporters;
    private Map<String, AtomicInteger> gaugeAtomics;
    private boolean hadoopMetricsStarted;

    public static synchronized Metrics initialize(Configuration conf) {
        if (self == null) {
            self = new Metrics(conf);
        }
        return self;
    }

    public static MetricRegistry getRegistry() {
        if (self == null) {
            return null;
        }
        return Metrics.self.registry;
    }

    public static void shutdown() {
        if (self != null) {
            for (ScheduledReporter reporter : Metrics.self.scheduledReporters) {
                reporter.stop();
                reporter.close();
            }
            if (Metrics.self.hadoopMetricsStarted) {
                DefaultMetricsSystem.shutdown();
            }
            self = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counter getOrCreateCounter(String name) {
        if (self == null) {
            return null;
        }
        SortedMap<String, Counter> counters = Metrics.self.registry.getCounters();
        Counter counter = (Counter)counters.get(name);
        if (counter != null) {
            return counter;
        }
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            counters = Metrics.self.registry.getCounters();
            counter = (Counter)counters.get(name);
            if (counter != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return counter;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Metrics.self.registry.counter(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timer getOrCreateTimer(String name) {
        if (self == null) {
            return null;
        }
        SortedMap<String, Timer> timers = Metrics.self.registry.getTimers();
        Timer timer = (Timer)timers.get(name);
        if (timer != null) {
            return timer;
        }
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            timers = Metrics.self.registry.getTimers();
            timer = (Timer)timers.get(name);
            if (timer != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return timer;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Metrics.self.registry.timer(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtomicInteger getOrCreateGauge(String name) {
        if (self == null) {
            return singletonAtomicInteger;
        }
        AtomicInteger ai = Metrics.self.gaugeAtomics.get(name);
        if (ai != null) {
            return ai;
        }
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            ai = Metrics.self.gaugeAtomics.get(name);
            if (ai != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ai;
            }
            final AtomicInteger forGauge = ai = new AtomicInteger();
            Metrics.self.gaugeAtomics.put(name, ai);
            Metrics.self.registry.register(name, new Gauge<Integer>(){

                @Override
                public Integer getValue() {
                    return forGauge.get();
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ai;
        }
    }

    @.VisibleForTesting
    static List<Reporter> getReporters() {
        return Metrics.self.reporters;
    }

    private Metrics(Configuration conf) {
        this.registry.registerAll(new GarbageCollectorMetricSet());
        this.registry.registerAll(new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.registry.registerAll(new MemoryUsageGaugeSet());
        this.registry.registerAll(new ThreadStatesGaugeSet());
        this.registry.registerAll(new ClassLoadingGaugeSet());
        String reportersToStart = conf.get(MetastoreConf.ConfVars.METRICS_REPORTERS.getVarname());
        if (reportersToStart == null && (reportersToStart = conf.get(MetastoreConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES.getHiveName())) == null && (reportersToStart = conf.get(MetastoreConf.ConfVars.HIVE_METRICS_REPORTER.getHiveName())) == null) {
            reportersToStart = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METRICS_REPORTERS);
        }
        this.reporters = new ArrayList<Reporter>();
        this.scheduledReporters = new ArrayList<ScheduledReporter>();
        if (reportersToStart != null && reportersToStart.length() > 0) {
            String[] reporterNames;
            for (String reporterName : reporterNames = reportersToStart.toLowerCase().split(",")) {
                Reporter reporter;
                if (reporterName.equals("console") || reporterName.endsWith("consolemetricsreporter")) {
                    reporter = ConsoleReporter.forRegistry(this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    ((ScheduledReporter)reporter).start(15L, TimeUnit.SECONDS);
                    this.reporters.add(reporter);
                    this.scheduledReporters.add((ScheduledReporter)reporter);
                    continue;
                }
                if (reporterName.equals("jmx") || reporterName.endsWith("jmxmetricsreporter")) {
                    reporter = JmxReporter.forRegistry(this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    ((JmxReporter)reporter).start();
                    this.reporters.add(reporter);
                    continue;
                }
                if (reporterName.startsWith("json") || reporterName.endsWith("jsonfilemetricsreporter")) {
                    reporter = JsonReporter.forRegistry(this.registry, conf).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    ((JsonReporter)reporter).start(MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.METRICS_JSON_FILE_INTERVAL, TimeUnit.SECONDS), TimeUnit.SECONDS);
                    this.reporters.add(reporter);
                    this.scheduledReporters.add((ScheduledReporter)reporter);
                    continue;
                }
                if (reporterName.startsWith("hadoop") || reporterName.endsWith("metrics2reporter")) {
                    reporter = HadoopMetrics2Reporter.forRegistry((MetricRegistry)this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(DefaultMetricsSystem.initialize((String)"metastore"), "metastore", "Runtime metadata catalog", "general-metadata");
                    reporter.start(1L, TimeUnit.MINUTES);
                    this.reporters.add(reporter);
                    this.scheduledReporters.add((ScheduledReporter)reporter);
                    this.hadoopMetricsStarted = true;
                    continue;
                }
                throw new RuntimeException("Unknown metric type " + reporterName);
            }
        } else {
            LOGGER.warn("No metrics reporters configured.");
        }
        this.gaugeAtomics = new HashMap<String, AtomicInteger>();
    }

    static {
        singletonAtomicInteger = new AtomicInteger();
    }
}

