/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import io.trino.hadoop.$internal.org.apache.commons.lang3.ArrayUtils;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import java.util.Arrays;

public class EnumCounters<E extends Enum<E>> {
    private final Class<E> enumClass;
    private final long[] counters;

    public EnumCounters(Class<E> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        Preconditions.checkNotNull(enumConstants);
        this.enumClass = enumClass;
        this.counters = new long[enumConstants.length];
    }

    public EnumCounters(Class<E> enumClass, long defaultVal) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        Preconditions.checkNotNull(enumConstants);
        this.enumClass = enumClass;
        this.counters = new long[enumConstants.length];
        this.reset(defaultVal);
    }

    public final long get(E e) {
        return this.counters[((Enum)e).ordinal()];
    }

    public long[] asArray() {
        return ArrayUtils.clone(this.counters);
    }

    public void negation() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = -this.counters[i];
        }
    }

    public void set(E e, long value) {
        this.counters[((Enum)e).ordinal()] = value;
    }

    public void set(EnumCounters<E> that) {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = that.counters[i];
        }
    }

    public void reset() {
        this.reset(0L);
    }

    public void add(E e, long value) {
        int n = ((Enum)e).ordinal();
        this.counters[n] = this.counters[n] + value;
    }

    public void add(EnumCounters<E> that) {
        for (int i = 0; i < this.counters.length; ++i) {
            int n = i;
            this.counters[n] = this.counters[n] + that.counters[i];
        }
    }

    public void subtract(E e, long value) {
        int n = ((Enum)e).ordinal();
        this.counters[n] = this.counters[n] - value;
    }

    public void subtract(EnumCounters<E> that) {
        for (int i = 0; i < this.counters.length; ++i) {
            int n = i;
            this.counters[n] = this.counters[n] - that.counters[i];
        }
    }

    public long sum() {
        long sum = 0L;
        for (int i = 0; i < this.counters.length; ++i) {
            sum += this.counters[i];
        }
        return sum;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof EnumCounters)) {
            return false;
        }
        EnumCounters that = (EnumCounters)obj;
        return this.enumClass == that.enumClass && Arrays.equals(this.counters, that.counters);
    }

    public EnumCounters<E> deepCopyEnumCounter() {
        EnumCounters<E> newCounter = new EnumCounters<E>(this.enumClass);
        newCounter.set(this);
        return newCounter;
    }

    public int hashCode() {
        return Arrays.hashCode(this.counters);
    }

    public String toString() {
        Enum[] enumConstants = (Enum[])this.enumClass.getEnumConstants();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.counters.length; ++i) {
            String name = enumConstants[i].name();
            b.append(name).append("=").append(this.counters[i]).append(", ");
        }
        return b.substring(0, b.length() - 2);
    }

    public void reset(long val) {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = val;
        }
    }

    public boolean allLessOrEqual(long val) {
        for (long c : this.counters) {
            if (c <= val) continue;
            return false;
        }
        return true;
    }

    public boolean anyGreaterOrEqual(long val) {
        for (long c : this.counters) {
            if (c < val) continue;
            return true;
        }
        return false;
    }
}

