/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ClientGSIContext
implements AlignmentContext {
    private final LongAccumulator lastSeenStateId = new LongAccumulator(Math::max, Long.MIN_VALUE);

    @Override
    public long getLastSeenStateId() {
        return this.lastSeenStateId.get();
    }

    @Override
    public boolean isCoordinatedCall(String protocolName, String method) {
        throw new UnsupportedOperationException("Client should not be checking uncoordinated call");
    }

    @Override
    public void updateResponseState(RpcHeaderProtos.RpcResponseHeaderProto.Builder header) {
    }

    @Override
    public void receiveResponseState(RpcHeaderProtos.RpcResponseHeaderProto header) {
        this.lastSeenStateId.accumulate(header.getStateId());
    }

    @Override
    public void updateRequestState(RpcHeaderProtos.RpcRequestHeaderProto.Builder header) {
        header.setStateId(this.lastSeenStateId.longValue());
    }

    @Override
    public long receiveRequestState(RpcHeaderProtos.RpcRequestHeaderProto header, long threshold) throws IOException {
        return 0L;
    }
}

