/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import io.trino.hadoop.;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class DelegationTokenRenewer
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(DelegationTokenRenewer.class);
    private static final long RENEW_CYCLE = 86400000L;
    @InterfaceAudience.Private
    @.VisibleForTesting
    public static long renewCycle = 86400000L;
    private volatile DelayQueue<RenewAction<?>> queue = new DelayQueue();
    private static DelegationTokenRenewer INSTANCE = null;

    @.VisibleForTesting
    protected int getRenewQueueLength() {
        return this.queue.size();
    }

    private DelegationTokenRenewer(Class<? extends FileSystem> clazz) {
        super(clazz.getSimpleName() + "-" + DelegationTokenRenewer.class.getSimpleName());
        this.setDaemon(true);
    }

    public static synchronized DelegationTokenRenewer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DelegationTokenRenewer(FileSystem.class);
        }
        return INSTANCE;
    }

    @.VisibleForTesting
    static synchronized void reset() {
        if (INSTANCE != null) {
            DelegationTokenRenewer.INSTANCE.queue.clear();
            INSTANCE.interrupt();
            try {
                INSTANCE.join();
            }
            catch (InterruptedException e) {
                LOG.warn("Failed to reset renewer");
            }
            finally {
                INSTANCE = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends FileSystem> RenewAction<T> addRenewAction(T fs) {
        DelegationTokenRenewer delegationTokenRenewer = this;
        synchronized (delegationTokenRenewer) {
            if (!this.isAlive()) {
                this.start();
            }
        }
        RenewAction action = new RenewAction(fs, null);
        if (action.token != null) {
            this.queue.add(action);
        } else {
            FileSystem.LOG.error("does not have a token for renewal");
        }
        return action;
    }

    public <T extends FileSystem> void removeRenewAction(T fs) throws IOException {
        RenewAction action = new RenewAction(fs, null);
        if (this.queue.remove(action)) {
            try {
                action.cancel();
            }
            catch (InterruptedException ie) {
                LOG.error("Interrupted while canceling token for " + fs.getUri() + "filesystem");
                LOG.debug("Exception in removeRenewAction: {}", ie);
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            RenewAction action = null;
            try {
                action = (RenewAction)this.queue.take();
                if (!action.renew()) continue;
                this.queue.add(action);
                continue;
            }
            catch (InterruptedException ie) {
                return;
            }
            catch (Exception ie) {
                FileSystem cfr_ignored_0 = (FileSystem)action.weakFs.get();
                FileSystem.LOG.warn("Failed to renew token, action=" + action, ie);
                continue;
            }
            break;
        }
    }

    public static class RenewAction<T extends FileSystem>
    implements Delayed {
        private long renewalTime;
        private final WeakReference<T> weakFs;
        private Token<?> token;
        boolean isValid = true;

        private RenewAction(T fs) {
            this.weakFs = new WeakReference<T>(fs);
            this.token = ((Renewable)fs).getRenewToken();
            this.updateRenewalTime(renewCycle);
        }

        public boolean isValid() {
            return this.isValid;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long millisLeft = this.renewalTime - Time.now();
            return unit.convert(millisLeft, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            RenewAction that = (RenewAction)delayed;
            return this.renewalTime < that.renewalTime ? -1 : (this.renewalTime == that.renewalTime ? 0 : 1);
        }

        public int hashCode() {
            return this.token.hashCode();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || !(that instanceof RenewAction)) {
                return false;
            }
            return this.token.equals(((RenewAction)that).token);
        }

        private void updateRenewalTime(long delay) {
            this.renewalTime = Time.now() + delay - delay / 10L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean renew() throws IOException, InterruptedException {
            boolean b;
            FileSystem fs = (FileSystem)this.weakFs.get();
            boolean bl = b = fs != null;
            if (b) {
                FileSystem fileSystem = fs;
                synchronized (fileSystem) {
                    try {
                        long expires = this.token.renew(fs.getConf());
                        this.updateRenewalTime(expires - Time.now());
                    }
                    catch (IOException ie) {
                        try {
                            Token<?>[] tokens = fs.addDelegationTokens(null, null);
                            if (tokens.length == 0) {
                                throw new IOException("addDelegationTokens returned no tokens");
                            }
                            this.token = tokens[0];
                            this.updateRenewalTime(renewCycle);
                            ((Renewable)((Object)fs)).setDelegationToken(this.token);
                        }
                        catch (IOException ie2) {
                            this.isValid = false;
                            throw new IOException("Can't renew or get new delegation token ", ie);
                        }
                    }
                }
            }
            return b;
        }

        private void cancel() throws IOException, InterruptedException {
            FileSystem fs = (FileSystem)this.weakFs.get();
            if (fs != null) {
                this.token.cancel(fs.getConf());
            }
        }

        public String toString() {
            Renewable fs = (Renewable)this.weakFs.get();
            return fs == null ? "evaporated token renew" : "The token will be renewed in " + this.getDelay(TimeUnit.SECONDS) + " secs, renewToken=" + this.token;
        }

        /* synthetic */ RenewAction(FileSystem x0, 1 x1) {
            this(x0);
        }
    }

    public static interface Renewable {
        public Token<?> getRenewToken();

        public <T extends TokenIdentifier> void setDelegationToken(Token<T> var1);
    }
}

