/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

public class AtopSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(AtopSplit.class);
    private final HostAddress host;
    private final long epochSeconds;
    private final String timeZoneId;

    @JsonCreator
    public AtopSplit(@JsonProperty(value="host") HostAddress host, @JsonProperty(value="epochSeconds") long epochSeconds, @JsonProperty(value="timeZoneId") String timeZoneId) {
        this.host = Objects.requireNonNull(host, "host is null");
        this.epochSeconds = epochSeconds;
        this.timeZoneId = Objects.requireNonNull(timeZoneId, "timeZoneId  is null");
    }

    @JsonProperty
    public HostAddress getHost() {
        return this.host;
    }

    @JsonProperty
    public long getEpochSeconds() {
        return this.epochSeconds;
    }

    @JsonProperty
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public ZonedDateTime getDate() {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(this.epochSeconds), ZoneId.of(this.timeZoneId));
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of((Object)HostAddress.fromString((String)this.host.getHostText()));
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.host.getRetainedSizeInBytes() + SizeOf.estimatedSizeOf((String)this.timeZoneId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("host", (Object)this.host).add("epochSeconds", this.epochSeconds).add("timeZoneId", (Object)this.timeZoneId).toString();
    }
}

