/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.atop.Atop;
import io.trino.plugin.atop.AtopFactory;
import io.trino.plugin.atop.AtopTable;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Semaphore;

public class AtopPageSource
implements ConnectorPageSource {
    private final Semaphore readerPermits;
    private final AtopFactory atopFactory;
    private final ConnectorSession session;
    private final Slice hostIp;
    private final AtopTable table;
    private final ZonedDateTime date;
    private final List<AtopTable.AtopColumn> columns;
    private final List<Type> types;
    private final PageBuilder pageBuilder;
    @Nullable
    private Atop atop;
    private boolean finished;

    public AtopPageSource(Semaphore readerPermits, AtopFactory atopFactory, ConnectorSession session, Slice hostIp, AtopTable table, ZonedDateTime date, List<AtopTable.AtopColumn> columns, List<Type> types) {
        this.readerPermits = Objects.requireNonNull(readerPermits, "readerPermits is null");
        this.atopFactory = Objects.requireNonNull(atopFactory, "atopFactory is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.hostIp = Objects.requireNonNull(hostIp, "hostIp is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.date = Objects.requireNonNull(date, "date is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        Preconditions.checkArgument((columns.size() == types.size() ? 1 : 0) != 0, (String)"columns (%s) does not match types (%s)", (int)columns.size(), (int)types.size());
        this.pageBuilder = new PageBuilder(types);
    }

    public void close() {
        this.finished = true;
        if (this.atop != null) {
            try {
                this.atop.close();
            }
            finally {
                this.atop = null;
                this.readerPermits.release();
            }
        }
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Page getNextPage() {
        if (this.atop == null) {
            try {
                this.readerPermits.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            try {
                this.atop = this.atopFactory.create(this.table, this.date);
            }
            catch (RuntimeException e) {
                this.atop = null;
                this.readerPermits.release();
                throw e;
            }
        }
        while (!this.pageBuilder.isFull()) {
            if (!this.atop.hasNext()) {
                this.close();
                break;
            }
            String row = (String)this.atop.next();
            if (row.equals("SEP")) continue;
            if (this.table == AtopTable.REBOOTS) {
                if (!row.equals("RESET")) continue;
                if (!this.atop.hasNext()) {
                    this.close();
                    break;
                }
                row = (String)this.atop.next();
            } else if (row.equals("RESET")) {
                if (!this.atop.hasNext()) continue;
                this.atop.next();
                continue;
            }
            List fields = Splitter.on((String)" ").splitToList((CharSequence)row);
            this.pageBuilder.declarePosition();
            for (int i = 0; i < this.columns.size(); ++i) {
                if (this.columns.get(i) == AtopTable.AtopColumn.HOST_IP) {
                    this.types.get(i).writeSlice(this.pageBuilder.getBlockBuilder(i), this.hostIp);
                    continue;
                }
                this.columns.get(i).getParser().parse(fields, this.types.get(i), this.pageBuilder.getBlockBuilder(i), this.session);
            }
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    public long getMemoryUsage() {
        return 0L;
    }
}

