/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.plugin.atop.AtopColumnHandle;
import io.trino.plugin.atop.AtopTable;
import io.trino.plugin.atop.AtopTableHandle;
import io.trino.plugin.atop.Environment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnNotFoundException;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AtopMetadata
implements ConnectorMetadata {
    private static final AtopColumnHandle START_TIME_HANDLE = new AtopColumnHandle(AtopTable.AtopColumn.START_TIME.getName());
    private static final AtopColumnHandle END_TIME_HANDLE = new AtopColumnHandle(AtopTable.AtopColumn.END_TIME.getName());
    private final TypeManager typeManager;
    private final String environment;

    @Inject
    public AtopMetadata(TypeManager typeManager, Environment environment) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.environment = environment.toString();
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)"default", (Object)this.environment);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        String schemaName = tableName.getSchemaName();
        if (!this.listSchemaNames(session).contains(schemaName)) {
            return null;
        }
        try {
            AtopTable table = AtopTable.valueOf(tableName.getTableName().toUpperCase(Locale.ENGLISH));
            return new AtopTableHandle(schemaName, table);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        AtopTableHandle atopTableHandle = (AtopTableHandle)tableHandle;
        ImmutableList.Builder columns = ImmutableList.builder();
        for (AtopTable.AtopColumn column : atopTableHandle.getTable().getColumns()) {
            columns.add((Object)new ColumnMetadata(column.getName(), this.typeManager.getType(column.getType())));
        }
        SchemaTableName schemaTableName = new SchemaTableName(atopTableHandle.getSchema(), atopTableHandle.getTable().getName());
        return new ConnectorTableMetadata(schemaTableName, (List)columns.build());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isEmpty()) {
            return Stream.of(AtopTable.values()).map(table -> new SchemaTableName(this.environment, table.getName())).collect(Collectors.toList());
        }
        if (!this.listSchemaNames(session).contains(schemaName.get())) {
            return ImmutableList.of();
        }
        return Stream.of(AtopTable.values()).map(table -> new SchemaTableName((String)schemaName.get(), table.getName())).collect(Collectors.toList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        AtopTableHandle atopTableHandle = (AtopTableHandle)tableHandle;
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (AtopTable.AtopColumn column : atopTableHandle.getTable().getColumns()) {
            columnHandles.put((Object)column.getName(), (Object)new AtopColumnHandle(column.getName()));
        }
        return columnHandles.buildOrThrow();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix.getSchema())) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, this.getTableHandle(session, tableName));
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.buildOrThrow();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        String columnName = ((AtopColumnHandle)columnHandle).getName();
        for (ColumnMetadata column : this.getTableMetadata(session, tableHandle).getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        AtopTableHandle atopTableHandle = (AtopTableHandle)tableHandle;
        SchemaTableName tableName = new SchemaTableName(atopTableHandle.getSchema(), atopTableHandle.getTable().getName());
        throw new ColumnNotFoundException(tableName, columnName);
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        AtopTableHandle handle = (AtopTableHandle)table;
        Map domains = (Map)constraint.getSummary().getDomains().orElseThrow(() -> new IllegalArgumentException("constraint summary is NONE"));
        Domain oldEndTimeDomain = handle.getEndTimeConstraint();
        Domain oldStartTimeDomain = handle.getStartTimeConstraint();
        Domain newEndTimeDomain = oldEndTimeDomain;
        Domain newStartTimeDomain = oldStartTimeDomain;
        if (domains.containsKey(START_TIME_HANDLE)) {
            newStartTimeDomain = ((Domain)domains.get(START_TIME_HANDLE)).intersect(oldStartTimeDomain);
        }
        if (domains.containsKey(END_TIME_HANDLE)) {
            newEndTimeDomain = ((Domain)domains.get(END_TIME_HANDLE)).intersect(oldEndTimeDomain);
        }
        if (oldEndTimeDomain.equals((Object)newEndTimeDomain) && oldStartTimeDomain.equals((Object)newStartTimeDomain)) {
            return Optional.empty();
        }
        handle = new AtopTableHandle(handle.getSchema(), handle.getTable(), newStartTimeDomain, newEndTimeDomain);
        return Optional.of(new ConstraintApplicationResult((Object)handle, constraint.getSummary(), false));
    }
}

