/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.google.common.collect.ImmutableMap;
import com.linkedin.coral.common.transformers.SqlCallTransformer;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;

public class ReturnTypeAdjustmentTransformer
extends SqlCallTransformer {
    private static final Map<String, SqlTypeName> OPERATORS_TO_ADJUST = ImmutableMap.builder().put((Object)"date_diff", (Object)SqlTypeName.INTEGER).put((Object)"cardinality", (Object)SqlTypeName.INTEGER).put((Object)"ceil", (Object)SqlTypeName.BIGINT).put((Object)"ceiling", (Object)SqlTypeName.BIGINT).put((Object)"floor", (Object)SqlTypeName.BIGINT).put((Object)"date_add", (Object)SqlTypeName.VARCHAR).build();
    private final Map<String, Boolean> configs;

    public ReturnTypeAdjustmentTransformer(Map<String, Boolean> configs) {
        this.configs = configs;
    }

    @Override
    protected boolean condition(SqlCall sqlCall) {
        String lowercaseOperatorName = sqlCall.getOperator().getName().toLowerCase(Locale.ROOT);
        if ("date_add".equals(lowercaseOperatorName) && !this.configs.getOrDefault("CAST_DATE_ADD_TO_STRING", false).booleanValue()) {
            return false;
        }
        return OPERATORS_TO_ADJUST.containsKey(lowercaseOperatorName);
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        String lowercaseOperatorName = sqlCall.getOperator().getName().toLowerCase(Locale.ROOT);
        SqlTypeName targetType = OPERATORS_TO_ADJUST.get(lowercaseOperatorName);
        if (targetType != null) {
            return this.createCast(sqlCall, targetType);
        }
        return sqlCall;
    }

    private SqlCall createCast(SqlNode node, SqlTypeName typeName) {
        SqlDataTypeSpec targetTypeNode = new SqlDataTypeSpec(new SqlBasicTypeNameSpec(typeName, SqlParserPos.ZERO), SqlParserPos.ZERO);
        return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, node, targetTypeNode);
    }
}

