/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.common.functions.FunctionReturnTypes;
import com.linkedin.coral.common.transformers.SqlCallTransformer;
import java.util.ArrayList;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;

public class CollectListOrSetFunctionTransformer
extends SqlCallTransformer {
    private static final String COLLECT_LIST = "collect_list";
    private static final String COLLECT_SET = "collect_set";
    private static final String ARRAY_AGG = "array_agg";
    private static final String ARRAY_DISTINCT = "array_distinct";

    @Override
    protected boolean condition(SqlCall sqlCall) {
        String operatorName = sqlCall.getOperator().getName();
        return operatorName.equalsIgnoreCase(COLLECT_LIST) || operatorName.equalsIgnoreCase(COLLECT_SET);
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        String operatorName = sqlCall.getOperator().getName();
        SqlOperator arrayAgg = CollectListOrSetFunctionTransformer.createSqlOperator(ARRAY_AGG, FunctionReturnTypes.ARRAY_OF_ARG0_TYPE);
        SqlOperator arrayDistinct = CollectListOrSetFunctionTransformer.createSqlOperator(ARRAY_DISTINCT, FunctionReturnTypes.ARRAY_OF_ARG0_TYPE);
        ArrayList<SqlNode> operands = new ArrayList<SqlNode>(sqlCall.getOperandList());
        if (operatorName.equalsIgnoreCase(COLLECT_LIST)) {
            return arrayAgg.createCall(SqlParserPos.ZERO, operands);
        }
        return arrayDistinct.createCall(SqlParserPos.ZERO, arrayAgg.createCall(SqlParserPos.ZERO, operands));
    }
}

