/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common.transformers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.linkedin.coral.calcite.$internal.com.google.common.base.Preconditions;
import com.linkedin.coral.common.calcite.CalciteUtil;
import com.linkedin.coral.common.functions.FunctionReturnTypes;
import com.linkedin.coral.common.transformers.SourceOperatorMatchSqlCallTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;

public class JsonTransformSqlCallTransformer
extends SourceOperatorMatchSqlCallTransformer {
    private static final Map<String, SqlOperator> OP_MAP = new HashMap<String, SqlOperator>();
    public static final String OPERATOR = "op";
    public static final String OPERANDS = "operands";
    public static final String INPUT = "input";
    public static final String VALUE = "value";
    public static final String REGEX = "regex";
    public static final String NAME = "name";
    private final SqlOperator targetOperator;
    public List<JsonObject> operandTransformers;
    public JsonObject resultTransformer;
    public List<JsonObject> operatorTransformers;

    public JsonTransformSqlCallTransformer(String fromOperatorName, int numOperands, SqlOperator targetOperator) {
        super(fromOperatorName, numOperands);
        this.targetOperator = targetOperator;
    }

    public JsonTransformSqlCallTransformer(SqlOperator coralOp, int numOperands, String targetOpName, String operandTransformers, String resultTransformer, String operatorTransformers) {
        this(coralOp.getName(), numOperands, JsonTransformSqlCallTransformer.createSqlOperator(targetOpName, coralOp.getReturnTypeInference()));
        if (operandTransformers != null) {
            this.operandTransformers = JsonTransformSqlCallTransformer.parseJsonObjectsFromString(operandTransformers);
        }
        if (resultTransformer != null) {
            this.resultTransformer = new JsonParser().parse(resultTransformer).getAsJsonObject();
        }
        if (operatorTransformers != null) {
            this.operatorTransformers = JsonTransformSqlCallTransformer.parseJsonObjectsFromString(operatorTransformers);
        }
    }

    @Override
    protected boolean condition(SqlCall sqlCall) {
        return this.sourceOpName.equalsIgnoreCase(sqlCall.getOperator().getName()) && sqlCall.getOperandList().size() == this.numOperands;
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        List<SqlNode> sourceOperands = sqlCall.getOperandList();
        SqlOperator newTargetOperator = this.transformTargetOperator(this.targetOperator, sourceOperands);
        if (newTargetOperator == null || newTargetOperator.getName().isEmpty()) {
            String operands = sourceOperands.stream().map(SqlNode::toString).collect(Collectors.joining(","));
            throw new IllegalArgumentException(String.format("An equivalent operator in the target IR was not found for the function call: %s(%s)", this.sourceOpName, operands));
        }
        List<SqlNode> newOperands = this.transformOperands(sourceOperands);
        SqlCall newCall = CalciteUtil.createCall(newTargetOperator, newOperands, SqlParserPos.ZERO);
        return (SqlCall)this.transformResult(newCall, sourceOperands);
    }

    private List<SqlNode> transformOperands(List<SqlNode> sourceOperands) {
        if (this.operandTransformers == null) {
            return sourceOperands;
        }
        ArrayList<SqlNode> sources = new ArrayList<SqlNode>();
        sources.add(null);
        sources.addAll(sourceOperands);
        ArrayList<SqlNode> results = new ArrayList<SqlNode>();
        for (JsonObject operandTransformer : this.operandTransformers) {
            results.add(this.transformExpression(operandTransformer, sources));
        }
        return results;
    }

    private SqlNode transformResult(SqlNode result, List<SqlNode> sourceOperands) {
        if (this.resultTransformer == null) {
            return result;
        }
        ArrayList<SqlNode> sources = new ArrayList<SqlNode>();
        sources.add(result);
        sources.addAll(sourceOperands);
        return this.transformExpression(this.resultTransformer, sources);
    }

    private SqlNode transformExpression(JsonObject transformer, List<SqlNode> sourceOperands) {
        if (transformer.get(OPERATOR) != null) {
            ArrayList<SqlNode> inputOperands = new ArrayList<SqlNode>();
            for (JsonElement inputOperand : transformer.getAsJsonArray(OPERANDS)) {
                if (!inputOperand.isJsonObject()) continue;
                inputOperands.add(this.transformExpression(inputOperand.getAsJsonObject(), sourceOperands));
            }
            String operatorName = transformer.get(OPERATOR).getAsString();
            SqlOperator op = OP_MAP.get(operatorName);
            if (op == null) {
                throw new UnsupportedOperationException("Operator " + operatorName + " is not supported in transformation");
            }
            return CalciteUtil.createCall(op, inputOperands, SqlParserPos.ZERO);
        }
        if (transformer.get(INPUT) != null) {
            int index = transformer.get(INPUT).getAsInt();
            if (index < 0 || index >= sourceOperands.size() || sourceOperands.get(index) == null) {
                throw new IllegalArgumentException("Invalid input value: " + index + ". Number of source operands: " + sourceOperands.size());
            }
            return sourceOperands.get(index);
        }
        JsonElement value = transformer.get(VALUE);
        if (value == null) {
            throw new IllegalArgumentException("JSON node for transformation should be either op, input, or value");
        }
        if (!value.isJsonPrimitive()) {
            throw new IllegalArgumentException("Value should be of primitive type: " + value);
        }
        JsonPrimitive primitive = value.getAsJsonPrimitive();
        if (primitive.isString()) {
            return CalciteUtil.createStringLiteral(primitive.getAsString(), SqlParserPos.ZERO);
        }
        if (primitive.isBoolean()) {
            return CalciteUtil.createLiteralBoolean(primitive.getAsBoolean(), SqlParserPos.ZERO);
        }
        if (primitive.isNumber()) {
            return CalciteUtil.createLiteralNumber(value.getAsBigDecimal().longValue(), SqlParserPos.ZERO);
        }
        throw new UnsupportedOperationException("Invalid JSON literal value: " + primitive);
    }

    private SqlOperator transformTargetOperator(SqlOperator operator, List<SqlNode> sourceOperands) {
        if (this.operatorTransformers == null) {
            return operator;
        }
        for (JsonObject operatorTransformer : this.operatorTransformers) {
            if (!(operatorTransformer.has(REGEX) && operatorTransformer.has(INPUT) && operatorTransformer.has(NAME))) {
                throw new IllegalArgumentException("JSON node for target operator transformer must have a matcher, input and name");
            }
            int index = operatorTransformer.get(INPUT).getAsInt() - 1;
            if (index < 0 || index >= sourceOperands.size()) {
                throw new IllegalArgumentException(String.format("Index is not within the acceptable range [%d, %d]", 1, sourceOperands.size()));
            }
            String functionName = operatorTransformer.get(NAME).getAsString();
            if (functionName.isEmpty()) {
                throw new IllegalArgumentException("JSON node for transformation must have a non-empty name");
            }
            String matcher = operatorTransformer.get(REGEX).getAsString();
            if (!Pattern.matches(matcher, sourceOperands.get(index).toString())) continue;
            return JsonTransformSqlCallTransformer.createSqlOperator(functionName, operator.getReturnTypeInference());
        }
        return operator;
    }

    private static List<JsonObject> parseJsonObjectsFromString(String s2) {
        ArrayList<JsonObject> objects = new ArrayList<JsonObject>();
        JsonArray transformerArray = new JsonParser().parse(s2).getAsJsonArray();
        for (JsonElement object : transformerArray) {
            objects.add(object.getAsJsonObject());
        }
        return objects;
    }

    static {
        OP_MAP.put("+", SqlStdOperatorTable.PLUS);
        OP_MAP.put("-", SqlStdOperatorTable.MINUS);
        OP_MAP.put("*", SqlStdOperatorTable.MULTIPLY);
        OP_MAP.put("/", SqlStdOperatorTable.DIVIDE);
        OP_MAP.put("^", SqlStdOperatorTable.POWER);
        OP_MAP.put("%", SqlStdOperatorTable.MOD);
        OP_MAP.put("date", new SqlUserDefinedFunction(new SqlIdentifier("date", SqlParserPos.ZERO), ReturnTypes.DATE, null, (SqlOperandTypeChecker)OperandTypes.STRING, null, null));
        OP_MAP.put("timestamp", new SqlUserDefinedFunction(new SqlIdentifier("timestamp", SqlParserPos.ZERO), FunctionReturnTypes.TIMESTAMP, null, (SqlOperandTypeChecker)OperandTypes.STRING, null, null){

            @Override
            public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
                Preconditions.checkState(call.operandCount() == 1);
                SqlWriter.Frame frame = writer.startFunCall("CAST");
                ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
                writer.sep("AS");
                writer.literal("TIMESTAMP");
                writer.endFunCall(frame);
            }
        });
        OP_MAP.put("hive_pattern_to_trino", new SqlUserDefinedFunction(new SqlIdentifier("hive_pattern_to_trino", SqlParserPos.ZERO), FunctionReturnTypes.STRING, null, (SqlOperandTypeChecker)OperandTypes.STRING, null, null));
    }
}

