/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.Memory;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DirectUpdateDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.HeapUpdateDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.Util;

public class DoublesSketchBuilder {
    private int bK = 128;
    private Memory bMem = null;

    public DoublesSketchBuilder setK(int k) {
        Util.checkK(k);
        this.bK = k;
        return this;
    }

    public DoublesSketchBuilder initMemory(Memory mem) {
        this.bMem = mem;
        return this;
    }

    public int getK() {
        return this.bK;
    }

    public Memory getMemory() {
        return this.bMem;
    }

    public UpdateDoublesSketch build() {
        return this.bMem == null ? HeapUpdateDoublesSketch.newInstance(this.bK) : DirectUpdateDoublesSketch.newInstance(this.bK, this.bMem);
    }

    public UpdateDoublesSketch build(int k) {
        return this.bMem == null ? HeapUpdateDoublesSketch.newInstance(k) : DirectUpdateDoublesSketch.newInstance(k, this.bMem);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("QuantileSketchBuilder configuration:").append(Util.LS);
        sb.append("K     : ").append('\t').append(this.bK).append(Util.LS);
        String memStr = this.bMem == null ? "null" : "valid";
        sb.append("Memory: ").append('\t').append(memStr);
        return sb.toString();
    }
}

