/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.io;

import com.linkedin.coral.;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configurable;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Writable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@.InterfaceAudience.Public
@.InterfaceStability.Stable
public abstract class GenericWritable
implements Writable,
Configurable {
    private static final byte NOT_SET = -1;
    private byte type = (byte)-1;
    private Writable instance;
    private Configuration conf = null;

    public void set(Writable obj) {
        this.instance = obj;
        Class<?> instanceClazz = this.instance.getClass();
        Class<? extends Writable>[] clazzes = this.getTypes();
        for (int i = 0; i < clazzes.length; ++i) {
            Class<? extends Writable> clazz = clazzes[i];
            if (!clazz.equals(instanceClazz)) continue;
            this.type = (byte)i;
            return;
        }
        throw new RuntimeException("The type of instance is: " + this.instance.getClass() + ", which is NOT registered.");
    }

    public Writable get() {
        return this.instance;
    }

    public String toString() {
        return "GW[" + (this.instance != null ? "class=" + this.instance.getClass().getName() + ",value=" + this.instance.toString() : "(null)") + "]";
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.type = in.readByte();
        Class<? extends Writable> clazz = this.getTypes()[this.type & 0xFF];
        try {
            this.instance = (Writable).ReflectionUtils.newInstance(clazz, (Configuration)this.conf);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Cannot initialize the class: " + clazz);
        }
        this.instance.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (this.type == -1 || this.instance == null) {
            throw new IOException("The GenericWritable has NOT been set correctly. type=" + this.type + ", instance=" + this.instance);
        }
        out.writeByte(this.type);
        this.instance.write(out);
    }

    protected abstract Class<? extends Writable>[] getTypes();

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }
}

