/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.batching;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.InternalApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.batching.FlowController;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@InternalApi(value="For google-cloud-java client use only")
public class FlowControlEventStats {
    private volatile FlowControlEvent lastFlowControlEvent;

    void recordFlowControlEvent(FlowControlEvent event) {
        if (this.lastFlowControlEvent == null || event.compareTo(this.lastFlowControlEvent) > 0) {
            this.lastFlowControlEvent = event;
        }
    }

    public FlowControlEvent getLastFlowControlEvent() {
        return this.lastFlowControlEvent;
    }

    public static class FlowControlEvent
    implements Comparable<FlowControlEvent> {
        private long timestampMs;
        private Long throttledTimeMs;
        private FlowController.FlowControlException exception;

        static FlowControlEvent createReserveDelayed(long throttledTimeInMs) {
            return FlowControlEvent.createReserveDelayed(System.currentTimeMillis(), throttledTimeInMs);
        }

        static FlowControlEvent createReserveDenied(FlowController.FlowControlException exception) {
            return FlowControlEvent.createReserveDenied(System.currentTimeMillis(), exception);
        }

        @VisibleForTesting
        static FlowControlEvent createReserveDelayed(long timestampMs, long throttledTimeInMs) {
            Preconditions.checkArgument(timestampMs > 0L, "timestamp must be greater than 0");
            Preconditions.checkArgument(throttledTimeInMs > 0L, "throttled time must be greater than 0");
            return new FlowControlEvent(timestampMs, throttledTimeInMs, null);
        }

        @VisibleForTesting
        static FlowControlEvent createReserveDenied(long timestampMs, FlowController.FlowControlException exception) {
            Preconditions.checkArgument(timestampMs > 0L, "timestamp must be greater than 0");
            Preconditions.checkNotNull(exception, "FlowControlException can't be null when reserve is denied");
            return new FlowControlEvent(timestampMs, null, exception);
        }

        private FlowControlEvent(long timestampMs, @Nullable Long throttledTimeMs, @Nullable FlowController.FlowControlException exception) {
            this.timestampMs = timestampMs;
            this.throttledTimeMs = throttledTimeMs;
            this.exception = exception;
        }

        public long getTimestampMs() {
            return this.timestampMs;
        }

        @Nullable
        public FlowController.FlowControlException getException() {
            return this.exception;
        }

        @Nullable
        public Long getThrottledTime(TimeUnit timeUnit) {
            return this.throttledTimeMs == null ? null : Long.valueOf(timeUnit.convert(this.throttledTimeMs, TimeUnit.MILLISECONDS));
        }

        @Override
        public int compareTo(FlowControlEvent otherEvent) {
            return Long.compare(this.getTimestampMs(), otherEvent.getTimestampMs());
        }
    }
}

