/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.regex;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineDeserializer;
import io.trino.hive.formats.line.LineDeserializerFactory;
import io.trino.hive.formats.line.regex.RegexDeserializer;
import java.util.List;
import java.util.Map;

public class RegexDeserializerFactory
implements LineDeserializerFactory {
    static final String REGEX_KEY = "input.regex";
    static final String REGEX_CASE_SENSITIVE_KEY = "input.regex.case.insensitive";

    @Override
    public List<String> getHiveSerDeClassNames() {
        return ImmutableList.of((Object)"org.apache.hadoop.hive.serde2.RegexSerDe");
    }

    @Override
    public LineDeserializer create(List<Column> columns, Map<String, String> serdeProperties) {
        String regex = serdeProperties.get(REGEX_KEY);
        Preconditions.checkArgument((regex != null ? 1 : 0) != 0, (String)"Schema does not have required '%s' property", (Object)REGEX_KEY);
        boolean caseSensitive = Boolean.parseBoolean(serdeProperties.get(REGEX_CASE_SENSITIVE_KEY));
        return new RegexDeserializer(columns, regex, caseSensitive);
    }
}

