/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.binary;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.ReadWriteUtils;
import io.trino.hive.formats.encodings.ColumnData;
import io.trino.hive.formats.encodings.EncodeOutput;
import io.trino.hive.formats.encodings.binary.BinaryColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;

public class LongEncoding
implements BinaryColumnEncoding {
    private final Type type;

    public LongEncoding(Type type) {
        this.type = type;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) {
                ReadWriteUtils.writeVLong(output, this.type.getLong(block, position));
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        ReadWriteUtils.writeVLong(output, this.type.getLong(block, position));
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0) {
                builder.appendNull();
                continue;
            }
            this.type.writeLong(builder, ReadWriteUtils.readVInt(slice, offset, length));
        }
        return builder.build();
    }

    @Override
    public int getValueOffset(Slice slice, int offset) {
        return 0;
    }

    @Override
    public int getValueLength(Slice slice, int offset) {
        return ReadWriteUtils.decodeVIntSize(slice, offset);
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        this.type.writeLong(builder, ReadWriteUtils.readVInt(slice, offset, length));
    }
}

