/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal;

import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.internal.UnknownEnumValueException;
import io.airlift.drift.codec.metadata.ThriftEnumMetadata;
import io.airlift.drift.codec.metadata.ThriftType;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;
import java.util.Objects;

@Immutable
public class EnumThriftCodec<T extends Enum<T>>
implements ThriftCodec<T> {
    private final ThriftType type;
    private final ThriftEnumMetadata<T> enumMetadata;

    public EnumThriftCodec(ThriftType type) {
        this.type = type;
        this.enumMetadata = type.getEnumMetadata();
    }

    @Override
    public ThriftType getType() {
        return this.type;
    }

    @Override
    public T read(TProtocolReader protocol) throws Exception {
        int enumValue = protocol.readI32();
        Enum enumConstant = (Enum)this.enumMetadata.getByEnumValue().get(enumValue);
        if (enumConstant != null) {
            return (T)enumConstant;
        }
        return (T)((Enum)this.enumMetadata.getUnknownEnumConstant().orElseThrow(() -> new UnknownEnumValueException(String.format("Enum %s does not have a constant for value: %s", this.enumMetadata.getEnumClass().getName(), enumValue))));
    }

    @Override
    public void write(T enumConstant, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(enumConstant, "enumConstant is null");
        protocol.writeI32(this.enumMetadata.getByEnumConstant().get(enumConstant).intValue());
    }
}

