/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.inject.Inject;
import io.airlift.drift.codec.DelegateCodec;
import io.airlift.drift.codec.InternalThriftCodec;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.internal.EnumThriftCodec;
import io.airlift.drift.codec.internal.ThriftCodecFactory;
import io.airlift.drift.codec.internal.builtin.BooleanArrayThriftCodec;
import io.airlift.drift.codec.internal.builtin.BooleanThriftCodec;
import io.airlift.drift.codec.internal.builtin.ByteBufferThriftCodec;
import io.airlift.drift.codec.internal.builtin.ByteThriftCodec;
import io.airlift.drift.codec.internal.builtin.DoubleArrayThriftCodec;
import io.airlift.drift.codec.internal.builtin.DoubleThriftCodec;
import io.airlift.drift.codec.internal.builtin.IntArrayThriftCodec;
import io.airlift.drift.codec.internal.builtin.IntegerThriftCodec;
import io.airlift.drift.codec.internal.builtin.ListThriftCodec;
import io.airlift.drift.codec.internal.builtin.LongArrayThriftCodec;
import io.airlift.drift.codec.internal.builtin.LongThriftCodec;
import io.airlift.drift.codec.internal.builtin.MapThriftCodec;
import io.airlift.drift.codec.internal.builtin.OptionalDoubleThriftCodec;
import io.airlift.drift.codec.internal.builtin.OptionalIntThriftCodec;
import io.airlift.drift.codec.internal.builtin.OptionalLongThriftCodec;
import io.airlift.drift.codec.internal.builtin.OptionalThriftCodec;
import io.airlift.drift.codec.internal.builtin.SetThriftCodec;
import io.airlift.drift.codec.internal.builtin.ShortArrayThriftCodec;
import io.airlift.drift.codec.internal.builtin.ShortThriftCodec;
import io.airlift.drift.codec.internal.builtin.StringThriftCodec;
import io.airlift.drift.codec.internal.builtin.VoidThriftCodec;
import io.airlift.drift.codec.internal.coercion.CoercionThriftCodec;
import io.airlift.drift.codec.internal.compiler.CompilerThriftCodecFactory;
import io.airlift.drift.codec.metadata.ReflectionHelper;
import io.airlift.drift.codec.metadata.ThriftCatalog;
import io.airlift.drift.codec.metadata.ThriftType;
import io.airlift.drift.codec.metadata.ThriftTypeReference;
import io.airlift.drift.codec.metadata.TypeCoercion;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;

@ThreadSafe
public final class ThriftCodecManager {
    private final ThriftCatalog catalog;
    private final LoadingCache<ThriftType, ThriftCodec<?>> typeCodecs;
    private final ThreadLocal<Deque<ThriftType>> stack = ThreadLocal.withInitial(ArrayDeque::new);
    private final ThreadLocal<Deque<ThriftType>> deferredTypesWorkList = ThreadLocal.withInitial(ArrayDeque::new);

    public ThriftCodecManager(ThriftCatalog catalog) {
        this((ThriftCodecFactory)new CompilerThriftCodecFactory(ThriftCodecManager.class.getClassLoader()), catalog, (Set<ThriftCodec<?>>)ImmutableSet.of());
    }

    public ThriftCodecManager(ThriftCodec<?> ... codecs) {
        this((ThriftCodecFactory)new CompilerThriftCodecFactory(ThriftCodecManager.class.getClassLoader()), (Set<ThriftCodec<?>>)ImmutableSet.copyOf((Object[])codecs));
    }

    public ThriftCodecManager(ClassLoader parent, ThriftCodec<?> ... codecs) {
        this((ThriftCodecFactory)new CompilerThriftCodecFactory(parent), (Set<ThriftCodec<?>>)ImmutableSet.copyOf((Object[])codecs));
    }

    public ThriftCodecManager(ThriftCodecFactory factory, ThriftCodec<?> ... codecs) {
        this(factory, new ThriftCatalog(), (Set<ThriftCodec<?>>)ImmutableSet.copyOf((Object[])codecs));
    }

    public ThriftCodecManager(ThriftCodecFactory factory, Set<ThriftCodec<?>> codecs) {
        this(factory, new ThriftCatalog(), codecs);
    }

    @Inject
    public ThriftCodecManager(final ThriftCodecFactory factory, final ThriftCatalog catalog, @InternalThriftCodec Set<ThriftCodec<?>> codecs) {
        Objects.requireNonNull(factory, "factory is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.typeCodecs = CacheBuilder.newBuilder().build(new CacheLoader<ThriftType, ThriftCodec<?>>(){

            public ThriftCodec<?> load(ThriftType type) {
                try {
                    ThriftCodecManager.this.stack.get().push(type);
                    if (ReflectionHelper.isOptional(type.getJavaType())) {
                        OptionalThriftCodec optionalThriftCodec = new OptionalThriftCodec(type, ThriftCodecManager.this.getElementCodec(type.getValueTypeReference()));
                        return optionalThriftCodec;
                    }
                    switch (type.getProtocolType()) {
                        case STRUCT: {
                            ThriftCodec<?> thriftCodec = factory.generateThriftTypeCodec(ThriftCodecManager.this, type.getStructMetadata());
                            return thriftCodec;
                        }
                        case MAP: {
                            MapThriftCodec mapThriftCodec = new MapThriftCodec(type, ThriftCodecManager.this.getElementCodec(type.getKeyTypeReference()), ThriftCodecManager.this.getElementCodec(type.getValueTypeReference()));
                            return mapThriftCodec;
                        }
                        case SET: {
                            SetThriftCodec setThriftCodec = new SetThriftCodec(type, ThriftCodecManager.this.getElementCodec(type.getValueTypeReference()));
                            return setThriftCodec;
                        }
                        case LIST: {
                            ListThriftCodec listThriftCodec = new ListThriftCodec(type, ThriftCodecManager.this.getElementCodec(type.getValueTypeReference()));
                            return listThriftCodec;
                        }
                        case ENUM: {
                            EnumThriftCodec enumThriftCodec = new EnumThriftCodec(type);
                            return enumThriftCodec;
                        }
                    }
                    if (type.isCoerced()) {
                        ThriftCodec<?> codec = ThriftCodecManager.this.getCodec(type.getUncoercedType());
                        TypeCoercion coercion = catalog.getDefaultCoercion(type.getJavaType());
                        CoercionThriftCodec coercionThriftCodec = new CoercionThriftCodec(codec, coercion);
                        return coercionThriftCodec;
                    }
                    throw new IllegalArgumentException("Unsupported Thrift type " + String.valueOf(type));
                }
                finally {
                    ThriftType top = ThriftCodecManager.this.stack.get().pop();
                    Preconditions.checkState((boolean)type.equals(top), (String)"ThriftCatalog circularity detection stack is corrupt: expected %s, but got %s", (Object)type, (Object)top);
                }
            }
        });
        this.addBuiltinCodec(new BooleanThriftCodec());
        this.addBuiltinCodec(new ByteThriftCodec());
        this.addBuiltinCodec(new ShortThriftCodec());
        this.addBuiltinCodec(new IntegerThriftCodec());
        this.addBuiltinCodec(new LongThriftCodec());
        this.addBuiltinCodec(new DoubleThriftCodec());
        this.addBuiltinCodec(new ByteBufferThriftCodec());
        this.addBuiltinCodec(new StringThriftCodec());
        this.addBuiltinCodec(new VoidThriftCodec());
        this.addBuiltinCodec(new BooleanArrayThriftCodec());
        this.addBuiltinCodec(new ShortArrayThriftCodec());
        this.addBuiltinCodec(new IntArrayThriftCodec());
        this.addBuiltinCodec(new LongArrayThriftCodec());
        this.addBuiltinCodec(new DoubleArrayThriftCodec());
        this.addBuiltinCodec(new OptionalDoubleThriftCodec());
        this.addBuiltinCodec(new OptionalIntThriftCodec());
        this.addBuiltinCodec(new OptionalLongThriftCodec());
        for (ThriftCodec<?> codec : codecs) {
            this.addCodec(codec);
        }
    }

    public ThriftCodec<?> getElementCodec(ThriftTypeReference thriftTypeReference) {
        return this.getCodec(thriftTypeReference.get());
    }

    public ThriftCodec<?> getCodec(Type javaType) {
        ThriftType thriftType = this.catalog.getThriftType(javaType);
        Preconditions.checkArgument((thriftType != null ? 1 : 0) != 0, (String)"Unsupported java type %s", (Object)javaType);
        return this.getCodec(thriftType);
    }

    public <T> ThriftCodec<T> getCodec(Class<T> javaType) {
        ThriftType thriftType = this.catalog.getThriftType(javaType);
        Preconditions.checkArgument((thriftType != null ? 1 : 0) != 0, (String)"Unsupported java type %s", (Object)javaType.getName());
        return this.getCodec(thriftType);
    }

    public <T> ThriftCodec<T> getCodec(TypeToken<T> type) {
        return this.getCodec(type.getType());
    }

    public ThriftCodec<?> getCodec(ThriftType type) {
        if (this.stack.get().contains(type)) {
            return new DelegateCodec(this, type.getJavaType());
        }
        try {
            ThriftCodec thriftCodec = (ThriftCodec)this.typeCodecs.get((Object)type);
            while (!this.deferredTypesWorkList.get().isEmpty()) {
                this.getCodec(this.deferredTypesWorkList.get().pop());
            }
            return thriftCodec;
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    public ThriftCodec<?> getCachedCodecIfPresent(Type javaType) {
        ThriftType thriftType = this.catalog.getThriftType(javaType);
        Preconditions.checkArgument((thriftType != null ? 1 : 0) != 0, (String)"Unsupported java type %s", (Object)javaType);
        return this.getCachedCodecIfPresent(thriftType);
    }

    public <T> ThriftCodec<T> getCachedCodecIfPresent(Class<T> javaType) {
        ThriftType thriftType = this.catalog.getThriftType(javaType);
        Preconditions.checkArgument((thriftType != null ? 1 : 0) != 0, (String)"Unsupported java type %s", (Object)javaType.getName());
        return this.getCachedCodecIfPresent(thriftType);
    }

    public <T> ThriftCodec<T> getCachedCodecIfPresent(TypeToken<T> type) {
        return this.getCachedCodecIfPresent(type.getType());
    }

    public ThriftCodec<?> getCachedCodecIfPresent(ThriftType type) {
        return (ThriftCodec)this.typeCodecs.getIfPresent((Object)type);
    }

    public void addCodec(ThriftCodec<?> codec) {
        this.catalog.addThriftType(codec.getType());
        this.typeCodecs.put((Object)codec.getType(), codec);
    }

    private void addBuiltinCodec(ThriftCodec<?> codec) {
        this.typeCodecs.put((Object)codec.getType(), codec);
    }

    public ThriftCatalog getCatalog() {
        return this.catalog;
    }

    public <T> T read(Class<T> type, TProtocolReader protocol) throws Exception {
        return this.getCodec(type).read(protocol);
    }

    public Object read(ThriftType type, TProtocolReader protocol) throws Exception {
        ThriftCodec<?> codec = this.getCodec(type);
        return codec.read(protocol);
    }

    public <T> void write(Class<T> type, T value, TProtocolWriter protocol) throws Exception {
        this.getCodec(type).write(value, protocol);
    }

    public void write(ThriftType type, Object value, TProtocolWriter protocol) throws Exception {
        ThriftCodec<?> codec = this.getCodec(type);
        codec.write(value, protocol);
    }
}

