/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.$internal.asm.util;

import io.airlift.drift.codec.$internal.asm.ModuleVisitor;
import io.airlift.drift.codec.$internal.asm.util.CheckClassAdapter;
import io.airlift.drift.codec.$internal.asm.util.CheckMethodAdapter;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckModuleAdapter
extends ModuleVisitor {
    private final boolean isOpen;
    private final HashSet<String> requiredModules = new HashSet();
    private final HashSet<String> exportedPackages = new HashSet();
    private final HashSet<String> openedPackages = new HashSet();
    private final HashSet<String> usedServices = new HashSet();
    private final HashSet<String> providedServices = new HashSet();
    int classVersion;
    private boolean visitEndCalled;

    public CheckModuleAdapter(ModuleVisitor moduleVisitor, boolean isOpen) {
        this(393216, moduleVisitor, isOpen);
        if (this.getClass() != CheckModuleAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckModuleAdapter(int api, ModuleVisitor moduleVisitor, boolean isOpen) {
        super(api, moduleVisitor);
        this.isOpen = isOpen;
    }

    @Override
    public void visitMainClass(String mainClass) {
        CheckMethodAdapter.checkInternalName(53, mainClass, "module main class");
        super.visitMainClass(mainClass);
    }

    @Override
    public void visitPackage(String packaze) {
        CheckMethodAdapter.checkInternalName(53, packaze, "module package");
        super.visitPackage(packaze);
    }

    @Override
    public void visitRequire(String module, int access, String version) {
        this.checkVisitEndNotCalled();
        CheckClassAdapter.checkFullyQualifiedName(53, module, "required module");
        CheckModuleAdapter.checkNameNotAlreadyDeclared(module, this.requiredModules, "Modules requires");
        CheckClassAdapter.checkAccess(access, 36960);
        if (this.classVersion >= 54 && module.equals("java.base") && (access & 0x60) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + access + " java.base can not be declared ACC_TRANSITIVE or ACC_STATIC_PHASE");
        }
        super.visitRequire(module, access, version);
    }

    @Override
    public void visitExport(String packaze, int access, String ... modules) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkInternalName(53, packaze, "package name");
        CheckModuleAdapter.checkNameNotAlreadyDeclared(packaze, this.exportedPackages, "Module exports");
        CheckClassAdapter.checkAccess(access, 36864);
        if (modules != null) {
            for (String module : modules) {
                CheckClassAdapter.checkFullyQualifiedName(53, module, "module export to");
            }
        }
        super.visitExport(packaze, access, modules);
    }

    @Override
    public void visitOpen(String packaze, int access, String ... modules) {
        this.checkVisitEndNotCalled();
        if (this.isOpen) {
            throw new UnsupportedOperationException("An open module can not use open directive");
        }
        CheckMethodAdapter.checkInternalName(53, packaze, "package name");
        CheckModuleAdapter.checkNameNotAlreadyDeclared(packaze, this.openedPackages, "Module opens");
        CheckClassAdapter.checkAccess(access, 36864);
        if (modules != null) {
            for (String module : modules) {
                CheckClassAdapter.checkFullyQualifiedName(53, module, "module open to");
            }
        }
        super.visitOpen(packaze, access, modules);
    }

    @Override
    public void visitUse(String service) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkInternalName(53, service, "service");
        CheckModuleAdapter.checkNameNotAlreadyDeclared(service, this.usedServices, "Module uses");
        super.visitUse(service);
    }

    @Override
    public void visitProvide(String service, String ... providers) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkInternalName(53, service, "service");
        CheckModuleAdapter.checkNameNotAlreadyDeclared(service, this.providedServices, "Module provides");
        if (providers == null || providers.length == 0) {
            throw new IllegalArgumentException("Providers cannot be null or empty");
        }
        for (String provider : providers) {
            CheckMethodAdapter.checkInternalName(53, provider, "provider");
        }
        super.visitProvide(service, providers);
    }

    @Override
    public void visitEnd() {
        this.checkVisitEndNotCalled();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private static void checkNameNotAlreadyDeclared(String name, HashSet<String> declaredNames, String message) {
        if (!declaredNames.add(name)) {
            throw new IllegalArgumentException(message + " " + name + " already declared");
        }
    }

    private void checkVisitEndNotCalled() {
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

