/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.trino2rel.parsetree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.linkedin.coral.;
import com.linkedin.coral.$internal.io.trino.sql.tree.AddColumn;
import com.linkedin.coral.$internal.io.trino.sql.tree.AliasedRelation;
import com.linkedin.coral.$internal.io.trino.sql.tree.AllColumns;
import com.linkedin.coral.$internal.io.trino.sql.tree.Analyze;
import com.linkedin.coral.$internal.io.trino.sql.tree.ArithmeticBinaryExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.ArithmeticUnaryExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.ArrayConstructor;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.AtTimeZone;
import com.linkedin.coral.$internal.io.trino.sql.tree.BetweenPredicate;
import com.linkedin.coral.$internal.io.trino.sql.tree.BinaryLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.BindExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.BooleanLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.Call;
import com.linkedin.coral.$internal.io.trino.sql.tree.CallArgument;
import com.linkedin.coral.$internal.io.trino.sql.tree.Cast;
import com.linkedin.coral.$internal.io.trino.sql.tree.CharLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.CoalesceExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.ColumnDefinition;
import com.linkedin.coral.$internal.io.trino.sql.tree.Comment;
import com.linkedin.coral.$internal.io.trino.sql.tree.Commit;
import com.linkedin.coral.$internal.io.trino.sql.tree.ComparisonExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.CreateMaterializedView;
import com.linkedin.coral.$internal.io.trino.sql.tree.CreateRole;
import com.linkedin.coral.$internal.io.trino.sql.tree.CreateSchema;
import com.linkedin.coral.$internal.io.trino.sql.tree.CreateTable;
import com.linkedin.coral.$internal.io.trino.sql.tree.CreateTableAsSelect;
import com.linkedin.coral.$internal.io.trino.sql.tree.CreateView;
import com.linkedin.coral.$internal.io.trino.sql.tree.Cube;
import com.linkedin.coral.$internal.io.trino.sql.tree.CurrentPath;
import com.linkedin.coral.$internal.io.trino.sql.tree.CurrentTime;
import com.linkedin.coral.$internal.io.trino.sql.tree.CurrentUser;
import com.linkedin.coral.$internal.io.trino.sql.tree.DateTimeDataType;
import com.linkedin.coral.$internal.io.trino.sql.tree.Deallocate;
import com.linkedin.coral.$internal.io.trino.sql.tree.DecimalLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.Delete;
import com.linkedin.coral.$internal.io.trino.sql.tree.DereferenceExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.DescribeInput;
import com.linkedin.coral.$internal.io.trino.sql.tree.DescribeOutput;
import com.linkedin.coral.$internal.io.trino.sql.tree.DoubleLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.DropColumn;
import com.linkedin.coral.$internal.io.trino.sql.tree.DropMaterializedView;
import com.linkedin.coral.$internal.io.trino.sql.tree.DropRole;
import com.linkedin.coral.$internal.io.trino.sql.tree.DropSchema;
import com.linkedin.coral.$internal.io.trino.sql.tree.DropTable;
import com.linkedin.coral.$internal.io.trino.sql.tree.DropView;
import com.linkedin.coral.$internal.io.trino.sql.tree.Except;
import com.linkedin.coral.$internal.io.trino.sql.tree.Execute;
import com.linkedin.coral.$internal.io.trino.sql.tree.ExistsPredicate;
import com.linkedin.coral.$internal.io.trino.sql.tree.Explain;
import com.linkedin.coral.$internal.io.trino.sql.tree.ExplainOption;
import com.linkedin.coral.$internal.io.trino.sql.tree.Expression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Extract;
import com.linkedin.coral.$internal.io.trino.sql.tree.FetchFirst;
import com.linkedin.coral.$internal.io.trino.sql.tree.FieldReference;
import com.linkedin.coral.$internal.io.trino.sql.tree.Format;
import com.linkedin.coral.$internal.io.trino.sql.tree.FrameBound;
import com.linkedin.coral.$internal.io.trino.sql.tree.FunctionCall;
import com.linkedin.coral.$internal.io.trino.sql.tree.GenericDataType;
import com.linkedin.coral.$internal.io.trino.sql.tree.GenericLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.Grant;
import com.linkedin.coral.$internal.io.trino.sql.tree.GrantRoles;
import com.linkedin.coral.$internal.io.trino.sql.tree.GroupBy;
import com.linkedin.coral.$internal.io.trino.sql.tree.GroupingOperation;
import com.linkedin.coral.$internal.io.trino.sql.tree.GroupingSets;
import com.linkedin.coral.$internal.io.trino.sql.tree.Identifier;
import com.linkedin.coral.$internal.io.trino.sql.tree.IfExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.InListExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.InPredicate;
import com.linkedin.coral.$internal.io.trino.sql.tree.Insert;
import com.linkedin.coral.$internal.io.trino.sql.tree.Intersect;
import com.linkedin.coral.$internal.io.trino.sql.tree.IntervalDayTimeDataType;
import com.linkedin.coral.$internal.io.trino.sql.tree.IntervalLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.IsNotNullPredicate;
import com.linkedin.coral.$internal.io.trino.sql.tree.IsNullPredicate;
import com.linkedin.coral.$internal.io.trino.sql.tree.Isolation;
import com.linkedin.coral.$internal.io.trino.sql.tree.Join;
import com.linkedin.coral.$internal.io.trino.sql.tree.JoinCriteria;
import com.linkedin.coral.$internal.io.trino.sql.tree.JoinOn;
import com.linkedin.coral.$internal.io.trino.sql.tree.JoinUsing;
import com.linkedin.coral.$internal.io.trino.sql.tree.LambdaArgumentDeclaration;
import com.linkedin.coral.$internal.io.trino.sql.tree.LambdaExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Lateral;
import com.linkedin.coral.$internal.io.trino.sql.tree.LikeClause;
import com.linkedin.coral.$internal.io.trino.sql.tree.LikePredicate;
import com.linkedin.coral.$internal.io.trino.sql.tree.Limit;
import com.linkedin.coral.$internal.io.trino.sql.tree.LogicalBinaryExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.LongLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.Merge;
import com.linkedin.coral.$internal.io.trino.sql.tree.MergeDelete;
import com.linkedin.coral.$internal.io.trino.sql.tree.MergeInsert;
import com.linkedin.coral.$internal.io.trino.sql.tree.MergeUpdate;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NotExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.NullIfExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.NullLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.NumericParameter;
import com.linkedin.coral.$internal.io.trino.sql.tree.Offset;
import com.linkedin.coral.$internal.io.trino.sql.tree.OrderBy;
import com.linkedin.coral.$internal.io.trino.sql.tree.Parameter;
import com.linkedin.coral.$internal.io.trino.sql.tree.PathElement;
import com.linkedin.coral.$internal.io.trino.sql.tree.PathSpecification;
import com.linkedin.coral.$internal.io.trino.sql.tree.Prepare;
import com.linkedin.coral.$internal.io.trino.sql.tree.Property;
import com.linkedin.coral.$internal.io.trino.sql.tree.QualifiedName;
import com.linkedin.coral.$internal.io.trino.sql.tree.QuantifiedComparisonExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Query;
import com.linkedin.coral.$internal.io.trino.sql.tree.QuerySpecification;
import com.linkedin.coral.$internal.io.trino.sql.tree.RefreshMaterializedView;
import com.linkedin.coral.$internal.io.trino.sql.tree.RenameColumn;
import com.linkedin.coral.$internal.io.trino.sql.tree.RenameSchema;
import com.linkedin.coral.$internal.io.trino.sql.tree.RenameTable;
import com.linkedin.coral.$internal.io.trino.sql.tree.RenameView;
import com.linkedin.coral.$internal.io.trino.sql.tree.ResetSession;
import com.linkedin.coral.$internal.io.trino.sql.tree.Revoke;
import com.linkedin.coral.$internal.io.trino.sql.tree.RevokeRoles;
import com.linkedin.coral.$internal.io.trino.sql.tree.Rollback;
import com.linkedin.coral.$internal.io.trino.sql.tree.Rollup;
import com.linkedin.coral.$internal.io.trino.sql.tree.Row;
import com.linkedin.coral.$internal.io.trino.sql.tree.RowDataType;
import com.linkedin.coral.$internal.io.trino.sql.tree.SampledRelation;
import com.linkedin.coral.$internal.io.trino.sql.tree.SearchedCaseExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Select;
import com.linkedin.coral.$internal.io.trino.sql.tree.SetPath;
import com.linkedin.coral.$internal.io.trino.sql.tree.SetRole;
import com.linkedin.coral.$internal.io.trino.sql.tree.SetSchemaAuthorization;
import com.linkedin.coral.$internal.io.trino.sql.tree.SetSession;
import com.linkedin.coral.$internal.io.trino.sql.tree.SetTableAuthorization;
import com.linkedin.coral.$internal.io.trino.sql.tree.SetViewAuthorization;
import com.linkedin.coral.$internal.io.trino.sql.tree.ShowCatalogs;
import com.linkedin.coral.$internal.io.trino.sql.tree.ShowColumns;
import com.linkedin.coral.$internal.io.trino.sql.tree.ShowCreate;
import com.linkedin.coral.$internal.io.trino.sql.tree.ShowFunctions;
import com.linkedin.coral.$internal.io.trino.sql.tree.ShowGrants;
import com.linkedin.coral.$internal.io.trino.sql.tree.ShowRoleGrants;
import com.linkedin.coral.$internal.io.trino.sql.tree.ShowRoles;
import com.linkedin.coral.$internal.io.trino.sql.tree.ShowSchemas;
import com.linkedin.coral.$internal.io.trino.sql.tree.ShowSession;
import com.linkedin.coral.$internal.io.trino.sql.tree.ShowStats;
import com.linkedin.coral.$internal.io.trino.sql.tree.ShowTables;
import com.linkedin.coral.$internal.io.trino.sql.tree.SimpleCaseExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.SimpleGroupBy;
import com.linkedin.coral.$internal.io.trino.sql.tree.SingleColumn;
import com.linkedin.coral.$internal.io.trino.sql.tree.SortItem;
import com.linkedin.coral.$internal.io.trino.sql.tree.StartTransaction;
import com.linkedin.coral.$internal.io.trino.sql.tree.StringLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.SubqueryExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.SubscriptExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.SymbolReference;
import com.linkedin.coral.$internal.io.trino.sql.tree.Table;
import com.linkedin.coral.$internal.io.trino.sql.tree.TableSubquery;
import com.linkedin.coral.$internal.io.trino.sql.tree.TimeLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.TimestampLiteral;
import com.linkedin.coral.$internal.io.trino.sql.tree.TransactionAccessMode;
import com.linkedin.coral.$internal.io.trino.sql.tree.TransactionMode;
import com.linkedin.coral.$internal.io.trino.sql.tree.TryExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.TypeParameter;
import com.linkedin.coral.$internal.io.trino.sql.tree.Union;
import com.linkedin.coral.$internal.io.trino.sql.tree.Unnest;
import com.linkedin.coral.$internal.io.trino.sql.tree.Update;
import com.linkedin.coral.$internal.io.trino.sql.tree.UpdateAssignment;
import com.linkedin.coral.$internal.io.trino.sql.tree.Use;
import com.linkedin.coral.$internal.io.trino.sql.tree.Values;
import com.linkedin.coral.$internal.io.trino.sql.tree.WhenClause;
import com.linkedin.coral.$internal.io.trino.sql.tree.Window;
import com.linkedin.coral.$internal.io.trino.sql.tree.WindowDefinition;
import com.linkedin.coral.$internal.io.trino.sql.tree.WindowFrame;
import com.linkedin.coral.$internal.io.trino.sql.tree.WindowReference;
import com.linkedin.coral.$internal.io.trino.sql.tree.WindowSpecification;
import com.linkedin.coral.$internal.io.trino.sql.tree.With;
import com.linkedin.coral.$internal.io.trino.sql.tree.WithQuery;
import com.linkedin.coral.calcite.$internal.org.apache.commons.lang3.ObjectUtils;
import com.linkedin.coral.common.HiveTypeSystem;
import com.linkedin.coral.common.calcite.CalciteUtil;
import com.linkedin.coral.trino.trino2rel.parsetree.ParserVisitorContext;
import com.linkedin.coral.trino.trino2rel.parsetree.UnhandledASTNodeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlArrayTypeSpec;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMapTypeSpec;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;

public class ParseTreeBuilder
extends AstVisitor<SqlNode, ParserVisitorContext> {
    private static final String UNSUPPORTED_EXCEPTION_MSG = "%s at line %d column %d is not supported in the visit.";
    private static final String DDL_NOT_SUPPORT_MSG = "DDL %s at line %d column %d is not supported.";
    private static final String LAMBDA_NOT_SUPPORT_MSG = "Lambda expression %s at line %d column %d is not supported.";
    private static final ImmutableMap<Join.Type, JoinType> JOIN_TYPE_MAP = ImmutableMap.of((Object)((Object)Join.Type.LEFT), (Object)((Object)JoinType.LEFT), (Object)((Object)Join.Type.RIGHT), (Object)((Object)JoinType.RIGHT), (Object)((Object)Join.Type.FULL), (Object)((Object)JoinType.FULL), (Object)((Object)Join.Type.INNER), (Object)((Object)JoinType.INNER), (Object)((Object)Join.Type.CROSS), (Object)((Object)JoinType.CROSS));
    private static final ImmutableMap<String, TimeUnit> TIME_UNIT_MAP = ImmutableMap.builder().put((Object)Extract.Field.YEAR.name(), (Object)TimeUnit.YEAR).put((Object)Extract.Field.QUARTER.name(), (Object)TimeUnit.QUARTER).put((Object)Extract.Field.MONTH.name(), (Object)TimeUnit.MONTH).put((Object)Extract.Field.WEEK.name(), (Object)TimeUnit.WEEK).put((Object)Extract.Field.DAY.name(), (Object)TimeUnit.DAY).put((Object)Extract.Field.DAY_OF_MONTH.name(), (Object)TimeUnit.DAY).put((Object)Extract.Field.DAY_OF_WEEK.name(), (Object)TimeUnit.DOW).put((Object)Extract.Field.DOW.name(), (Object)TimeUnit.DOW).put((Object)Extract.Field.DAY_OF_YEAR.name(), (Object)TimeUnit.DOY).put((Object)Extract.Field.DOY.name(), (Object)TimeUnit.DOY).put((Object)Extract.Field.HOUR.name(), (Object)TimeUnit.HOUR).put((Object)Extract.Field.MINUTE.name(), (Object)TimeUnit.MINUTE).put((Object)Extract.Field.SECOND.name(), (Object)TimeUnit.SECOND).build();
    private static final ImmutableMap<String, SqlOperator> OPERATOR_MAP = ImmutableMap.builder().put((Object)ArithmeticBinaryExpression.Operator.ADD.getValue(), (Object)SqlStdOperatorTable.PLUS).put((Object)ArithmeticBinaryExpression.Operator.DIVIDE.getValue(), (Object)SqlStdOperatorTable.DIVIDE).put((Object)ArithmeticBinaryExpression.Operator.SUBTRACT.getValue(), (Object)SqlStdOperatorTable.MINUS).put((Object)ArithmeticBinaryExpression.Operator.MULTIPLY.getValue(), (Object)SqlStdOperatorTable.MULTIPLY).put((Object)ArithmeticBinaryExpression.Operator.MODULUS.getValue(), (Object)SqlStdOperatorTable.PERCENT_REMAINDER).put((Object)ComparisonExpression.Operator.EQUAL.getValue(), (Object)SqlStdOperatorTable.EQUALS).put((Object)ComparisonExpression.Operator.LESS_THAN.getValue(), (Object)SqlStdOperatorTable.LESS_THAN).put((Object)ComparisonExpression.Operator.LESS_THAN_OR_EQUAL.getValue(), (Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL).put((Object)ComparisonExpression.Operator.GREATER_THAN.getValue(), (Object)SqlStdOperatorTable.GREATER_THAN).put((Object)ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL.getValue(), (Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL).put((Object)ComparisonExpression.Operator.NOT_EQUAL.getValue(), (Object)SqlStdOperatorTable.NOT_EQUALS).put((Object)ComparisonExpression.Operator.IS_DISTINCT_FROM.getValue(), (Object)SqlStdOperatorTable.IS_DISTINCT_FROM).build();
    private static final ImmutableMap<ComparisonExpression.Operator, SqlOperator> ALL_COMPARISON_OPERATOR = ImmutableMap.builder().put((Object)ComparisonExpression.Operator.EQUAL, (Object)SqlStdOperatorTable.ALL_EQ).put((Object)ComparisonExpression.Operator.NOT_EQUAL, (Object)SqlStdOperatorTable.ALL_NE).put((Object)ComparisonExpression.Operator.LESS_THAN, (Object)SqlStdOperatorTable.ALL_LT).put((Object)ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.ALL_LE).put((Object)ComparisonExpression.Operator.GREATER_THAN, (Object)SqlStdOperatorTable.ALL_GT).put((Object)ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.ALL_GE).build();
    private static final ImmutableMap<ComparisonExpression.Operator, SqlOperator> SOME_COMPARISON_OPERATOR = ImmutableMap.builder().put((Object)ComparisonExpression.Operator.EQUAL, (Object)SqlStdOperatorTable.SOME_EQ).put((Object)ComparisonExpression.Operator.NOT_EQUAL, (Object)SqlStdOperatorTable.SOME_NE).put((Object)ComparisonExpression.Operator.LESS_THAN, (Object)SqlStdOperatorTable.SOME_LT).put((Object)ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.SOME_LE).put((Object)ComparisonExpression.Operator.GREATER_THAN, (Object)SqlStdOperatorTable.SOME_GT).put((Object)ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.SOME_GE).build();
    private static final ImmutableSet<SqlKind> NULL_CARED_OPERATOR = ImmutableSet.of((Object)((Object)SqlKind.FIRST_VALUE), (Object)((Object)SqlKind.LAST_VALUE), (Object)((Object)SqlKind.LEAD), (Object)((Object)SqlKind.LAG));
    private final SqlTypeFactoryImpl sqlTypeFactory = new SqlTypeFactoryImpl(new HiveTypeSystem());

    private SqlParserPos getPos(Node node) {
        if (node.getLocation().isPresent()) {
            return new SqlParserPos(node.getLocation().get().getLineNumber(), node.getLocation().get().getColumnNumber());
        }
        return SqlParserPos.ZERO;
    }

    private SqlNode processOptional(Optional<? extends Node> node, ParserVisitorContext context) {
        return node.map(value -> (SqlNode)this.process((Node)value, context)).orElse(null);
    }

    private List<SqlNode> getChildren(Node node, ParserVisitorContext context) {
        return this.toListOfSqlNode(node.getChildren(), context);
    }

    private SqlNodeList getChildSqlNodeList(Node node, ParserVisitorContext context) {
        return new SqlNodeList(this.getChildren(node, context), this.getPos(node));
    }

    private List<SqlNode> toListOfSqlNode(List<? extends Node> nodes, ParserVisitorContext context) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        return nodes.stream().map(n -> (SqlNode)this.process((Node)n, context)).collect(Collectors.toList());
    }

    private SqlNodeList toSqlNodeList(List<? extends Node> nodes, ParserVisitorContext context, SqlParserPos pos) {
        return CalciteUtil.createSqlNodeList(this.toListOfSqlNode(nodes, context), pos);
    }

    private SqlNode parseExpression(String expression) {
        try {
            return CalciteUtil.parseStatement(expression);
        }
        catch (SqlParseException e) {
            throw new RuntimeException(String.format("Failed to parse the expression %s.", expression), e);
        }
    }

    private SqlIdentifier convertQualifiedName(QualifiedName name, SqlParserPos pos) {
        return CalciteUtil.createSqlIdentifier(pos, new ArrayList(name.getOriginalParts().stream().map(Identifier::getValue).collect(Collectors.toList())).toArray(new String[0]));
    }

    private SqlCall getUnresolvedFunction(String functionName, List<SqlNode> operands) {
        SqlIdentifier functionIdentifier = CalciteUtil.createSqlIdentifier(SqlParserPos.ZERO, functionName);
        return CalciteUtil.createCall(new SqlUnresolvedFunction(functionIdentifier, null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION), operands);
    }

    private SqlCall getCall(SqlOperator operator, Node node, ParserVisitorContext context) {
        if (operator == null) {
            throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
        }
        return operator.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
    }

    @Override
    protected SqlNode visitCurrentTime(CurrentTime node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos(node);
        switch (node.getFunction()) {
            case TIME: {
                return CalciteUtil.createCall((SqlOperator)SqlStdOperatorTable.CURRENT_TIME, Collections.emptyList(), pos);
            }
            case DATE: {
                return CalciteUtil.createCall((SqlOperator)SqlStdOperatorTable.CURRENT_DATE, Collections.emptyList(), pos);
            }
            case LOCALTIME: {
                return CalciteUtil.createCall((SqlOperator)SqlStdOperatorTable.LOCALTIME, Collections.emptyList(), pos);
            }
            case TIMESTAMP: {
                return CalciteUtil.createCall((SqlOperator)SqlStdOperatorTable.CURRENT_TIMESTAMP, Collections.emptyList(), pos);
            }
            case LOCALTIMESTAMP: {
                return CalciteUtil.createCall((SqlOperator)SqlStdOperatorTable.LOCALTIMESTAMP, Collections.emptyList(), pos);
            }
        }
        return this.getUnresolvedFunction(node.getFunction().getName(), Collections.emptyList());
    }

    @Override
    protected SqlNode visitExtract(Extract node, ParserVisitorContext context) {
        TimeUnit unit = (TimeUnit)((Object)TIME_UNIT_MAP.get((Object)node.getField().name()));
        if (unit == null) {
            throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
        }
        return CalciteUtil.createCall(SqlStdOperatorTable.EXTRACT, Arrays.asList(new SqlIntervalQualifier(unit, null, SqlParserPos.ZERO), (SqlNode)this.process(node.getExpression(), context)));
    }

    @Override
    protected SqlNode visitArithmeticBinary(ArithmeticBinaryExpression node, ParserVisitorContext context) {
        return this.getCall((SqlOperator)OPERATOR_MAP.get((Object)node.getOperator().getValue()), node, context);
    }

    @Override
    protected SqlNode visitBetweenPredicate(BetweenPredicate node, ParserVisitorContext context) {
        return SqlStdOperatorTable.BETWEEN.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
    }

    @Override
    protected SqlNode visitCoalesceExpression(CoalesceExpression node, ParserVisitorContext context) {
        return SqlStdOperatorTable.COALESCE.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
    }

    @Override
    protected SqlNode visitComparisonExpression(ComparisonExpression node, ParserVisitorContext context) {
        return this.getCall((SqlOperator)OPERATOR_MAP.get((Object)node.getOperator().getValue()), node, context);
    }

    @Override
    protected SqlNode visitDoubleLiteral(DoubleLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralNumber(node.getValue(), this.getPos(node));
    }

    @Override
    protected SqlNode visitDecimalLiteral(DecimalLiteral node, ParserVisitorContext context) {
        return SqlNumericLiteral.createExactNumeric(node.getValue(), this.getPos(node));
    }

    private SqlNode getFinalQuery(SqlParserPos pos, SqlNode query, SqlNodeList orderByList, SqlNode fetch, SqlNode offset) {
        if (!orderByList.getList().isEmpty() || fetch != null || offset != null) {
            return new SqlOrderBy(pos, query, orderByList, offset, fetch);
        }
        return query;
    }

    @Override
    protected SqlNode visitQuery(Query node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos(node);
        SqlNode query = node.getQueryBody().accept(this, context);
        SqlNodeList orderByList = ObjectUtils.defaultIfNull((SqlNodeList)this.processOptional(node.getOrderBy(), context), CalciteUtil.createSqlNodeList(Collections.emptyList(), SqlParserPos.ZERO));
        SqlNode fetch = this.processOptional(node.getLimit(), context);
        SqlNode offset = this.processOptional(node.getOffset(), context);
        if (node.getWith().isPresent()) {
            SqlNodeList withItems = this.visitWith(node.getWith().get(), context);
            return this.getFinalQuery(pos, new SqlWith(pos, withItems, query), orderByList, fetch, offset);
        }
        return this.getFinalQuery(pos, query, orderByList, fetch, offset);
    }

    @Override
    protected SqlNode visitGenericLiteral(GenericLiteral node, ParserVisitorContext context) {
        return this.parseExpression(node.toString());
    }

    private String formatTime(String time) {
        if (time.split(":").length == 2) {
            return time + ":00";
        }
        if (time.split(":").length == 1) {
            return time + ":00:00";
        }
        return time;
    }

    @Override
    protected SqlNode visitTimeLiteral(TimeLiteral node, ParserVisitorContext context) {
        return SqlLiteral.createTime(new TimeString(this.formatTime(node.getValue())), 1, this.getPos(node));
    }

    @Override
    protected SqlNodeList visitWith(With node, ParserVisitorContext context) {
        if (node.isRecursive()) {
            throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
        }
        return this.getChildSqlNodeList(node, context);
    }

    @Override
    protected SqlNode visitWithQuery(WithQuery node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos(node);
        SqlIdentifier alias = this.visitIdentifier(node.getName(), context);
        SqlNode query = this.visitQuery(node.getQuery(), context);
        SqlNodeList columns = null;
        if (node.getColumnNames().isPresent()) {
            columns = this.toSqlNodeList(node.getColumnNames().get(), context, pos);
        }
        return new SqlWithItem(pos, alias, columns, query);
    }

    @Override
    protected SqlNodeList visitSelect(Select node, ParserVisitorContext context) {
        return this.getChildSqlNodeList(node, context);
    }

    @Override
    protected SqlNodeList visitOrderBy(OrderBy node, ParserVisitorContext context) {
        return this.getChildSqlNodeList(node, context);
    }

    @Override
    protected SqlNode visitOffset(Offset node, ParserVisitorContext context) {
        return (SqlNode)this.process(node.getRowCount(), context);
    }

    @Override
    protected SqlNode visitQuerySpecification(QuerySpecification node, ParserVisitorContext context) {
        SqlNodeList selectList = this.visitSelect(node.getSelect(), context);
        SqlNodeList keywords = node.getSelect().isDistinct() ? new SqlNodeList((Collection<? extends SqlNode>)ImmutableList.of((Object)SqlSelectKeyword.DISTINCT.symbol(SqlParserPos.ZERO)), SqlParserPos.ZERO) : null;
        SqlNode from = this.processOptional(node.getFrom(), context);
        SqlNode where = this.processOptional(node.getWhere(), context);
        SqlNodeList groupBy = (SqlNodeList)this.processOptional(node.getGroupBy(), context);
        SqlNode having = this.processOptional(node.getHaving(), context);
        SqlNodeList orderBy = ObjectUtils.defaultIfNull((SqlNodeList)this.processOptional(node.getOrderBy(), context), CalciteUtil.createSqlNodeList(Collections.emptyList(), SqlParserPos.ZERO));
        SqlNode limit = this.processOptional(node.getLimit(), context);
        SqlNode offset = this.processOptional(node.getOffset(), context);
        SqlSelect select = new SqlSelect(this.getPos(node), keywords, selectList, from, where, groupBy, having, null, null, null, null);
        if (!orderBy.getList().isEmpty() || offset != null || limit != null) {
            return new SqlOrderBy(this.getPos(node), select, orderBy, offset, limit);
        }
        return select;
    }

    @Override
    protected SqlNode visitUnion(Union node, ParserVisitorContext context) {
        if (node.isDistinct()) {
            return SqlStdOperatorTable.UNION.createCall(this.getChildSqlNodeList(node, context));
        }
        return SqlStdOperatorTable.UNION_ALL.createCall(this.getChildSqlNodeList(node, context));
    }

    @Override
    protected SqlNode visitIntersect(Intersect node, ParserVisitorContext context) {
        return SqlStdOperatorTable.INTERSECT.createCall(this.getChildSqlNodeList(node, context));
    }

    @Override
    protected SqlNode visitExcept(Except node, ParserVisitorContext context) {
        return SqlStdOperatorTable.EXCEPT.createCall(this.getChildSqlNodeList(node, context));
    }

    @Override
    protected SqlNode visitTimestampLiteral(TimestampLiteral node, ParserVisitorContext context) {
        return SqlLiteral.createTimestamp(new TimestampString(this.formatTime(node.getValue())), 1, this.getPos(node));
    }

    @Override
    protected SqlNode visitWhenClause(WhenClause node, ParserVisitorContext context) {
        context.whenClauses.add((SqlNode)this.process(node.getOperand(), context));
        context.thenClauses.add((SqlNode)this.process(node.getResult(), context));
        return null;
    }

    @Override
    protected SqlNode visitIntervalLiteral(IntervalLiteral node, ParserVisitorContext context) {
        TimeUnit startUnit = TimeUnit.valueOf(node.getStartField().toString());
        TimeUnit endUnit = node.getEndField().isPresent() ? TimeUnit.valueOf(node.getEndField().toString()) : null;
        SqlIntervalQualifier qualifier = new SqlIntervalQualifier(startUnit, endUnit, SqlParserPos.ZERO);
        return SqlLiteral.createInterval(node.getSign().multiplier(), node.getValue(), qualifier, this.getPos(node));
    }

    @Override
    protected SqlNode visitInPredicate(InPredicate node, ParserVisitorContext context) {
        return SqlStdOperatorTable.IN.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
    }

    @Override
    protected SqlNode visitFunctionCall(FunctionCall node, ParserVisitorContext context) {
        SqlLiteral functionQualifier;
        SqlUnresolvedFunction unresolvedFunction;
        SqlCall call;
        if (node.getFilter().isPresent()) {
            throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
        }
        SqlParserPos pos = this.getPos(node);
        List<SqlNode> operands = node.getArguments().stream().map(arg -> (SqlNode)this.process((Node)arg, context)).collect(Collectors.toList());
        SqlIdentifier functionName = this.convertQualifiedName(node.getName(), this.getPos(node));
        if (node.getName().toString().equalsIgnoreCase("COUNT") && operands.isEmpty()) {
            operands.add(CalciteUtil.createStarIdentifier(SqlParserPos.ZERO));
        }
        if (NULL_CARED_OPERATOR.contains((Object)(call = CalciteUtil.createCall((SqlOperator)(unresolvedFunction = new SqlUnresolvedFunction(functionName, null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION)), operands, functionQualifier = node.isDistinct() ? SqlLiteral.createSymbol(SqlSelectKeyword.DISTINCT, SqlParserPos.ZERO) : null)).getKind()) && node.getNullTreatment().isPresent()) {
            call = node.getNullTreatment().get().equals((Object)FunctionCall.NullTreatment.IGNORE) ? SqlStdOperatorTable.IGNORE_NULLS.createCall(pos, call) : SqlStdOperatorTable.RESPECT_NULLS.createCall(pos, call);
        }
        if (node.getWindow().isPresent()) {
            return SqlStdOperatorTable.OVER.createCall(pos, call, this.visitWindow(node.getWindow().get(), context));
        }
        return call;
    }

    private SqlNode visitWindow(Window window, ParserVisitorContext context) {
        if (window instanceof WindowSpecification) {
            return this.visitWindowSpecification((WindowSpecification)window, context);
        }
        if (window instanceof WindowReference) {
            return this.visitWindowReference((WindowReference)window, context);
        }
        return null;
    }

    @Override
    protected SqlNode visitLambdaExpression(LambdaExpression node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, LAMBDA_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitSimpleCaseExpression(SimpleCaseExpression node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos(node);
        SqlNode operand = (SqlNode)this.process(node.getOperand(), context);
        ParserVisitorContext caseWhenContext = new ParserVisitorContext();
        node.getWhenClauses().forEach(cw -> {
            SqlNode cfr_ignored_0 = (SqlNode)this.process((Node)cw, caseWhenContext);
        });
        SqlNode defaultValue = node.getDefaultValue().isPresent() ? (SqlNode)this.process(node.getDefaultValue().get(), context) : CalciteUtil.createLiteralNull(SqlParserPos.ZERO);
        return caseWhenContext.createCaseCall(pos, operand, defaultValue);
    }

    @Override
    protected SqlNode visitStringLiteral(StringLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createStringLiteral(node.getValue(), this.getPos(node));
    }

    @Override
    protected SqlNode visitCharLiteral(CharLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createStringLiteral(node.getValue(), this.getPos(node));
    }

    @Override
    protected SqlNode visitBinaryLiteral(BinaryLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createBinaryLiteral(node.getValue().getBytes(), this.getPos(node));
    }

    @Override
    protected SqlNode visitBooleanLiteral(BooleanLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralBoolean(node.getValue(), this.getPos(node));
    }

    @Override
    protected SqlNode visitInListExpression(InListExpression node, ParserVisitorContext context) {
        return this.getChildSqlNodeList(node, context);
    }

    @Override
    protected SqlIdentifier visitIdentifier(Identifier node, ParserVisitorContext context) {
        return CalciteUtil.createSqlIdentifier(this.getPos(node), node.getValue());
    }

    @Override
    protected SqlNode visitDereferenceExpression(DereferenceExpression node, ParserVisitorContext context) {
        SqlNode base = (SqlNode)this.process(node.getBase(), context);
        if (base.getKind().equals((Object)SqlKind.IDENTIFIER)) {
            ArrayList<String> names = new ArrayList<String>(((SqlIdentifier)base).names);
            names.add(node.getField().getValue());
            return CalciteUtil.createSqlIdentifier(this.getPos(node), names.toArray(new String[0]));
        }
        return SqlStdOperatorTable.DOT.createCall(this.getPos(node), base, new SqlIdentifier(node.getField().getValue(), SqlParserPos.ZERO));
    }

    @Override
    protected SqlNode visitNullIfExpression(NullIfExpression node, ParserVisitorContext context) {
        return SqlStdOperatorTable.NULLIF.createCall(this.getPos(node), this.getChildSqlNodeList(node, context));
    }

    @Override
    protected SqlNode visitIfExpression(IfExpression node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos(node);
        SqlNode defaultValue = node.getFalseValue().isPresent() ? (SqlNode)this.process(node.getFalseValue().get(), context) : CalciteUtil.createLiteralNull(SqlParserPos.ZERO);
        SqlNodeList whenList = this.toSqlNodeList(Collections.singletonList(node.getCondition()), context, pos);
        SqlNodeList thenList = this.toSqlNodeList(Collections.singletonList(node.getTrueValue()), context, pos);
        return SqlStdOperatorTable.CASE.createCall(null, pos, null, whenList, thenList, defaultValue);
    }

    @Override
    protected SqlNode visitNullLiteral(NullLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralNull(this.getPos(node));
    }

    @Override
    protected SqlNode visitArithmeticUnary(ArithmeticUnaryExpression node, ParserVisitorContext context) {
        SqlNode operand = (SqlNode)this.process(node.getValue(), context);
        if (node.getSign().equals((Object)ArithmeticUnaryExpression.Sign.MINUS)) {
            if (operand instanceof SqlNumericLiteral) {
                return SqlLiteral.createNegative((SqlNumericLiteral)operand, this.getPos(node));
            }
            return SqlStdOperatorTable.UNARY_MINUS.createCall(this.getPos(node), operand);
        }
        return operand;
    }

    @Override
    protected SqlNode visitNotExpression(NotExpression node, ParserVisitorContext context) {
        SqlNode operand = (SqlNode)this.process(node.getValue(), context);
        SqlParserPos pos = this.getPos(node);
        if (operand.getKind().equals((Object)SqlKind.BETWEEN)) {
            return SqlStdOperatorTable.NOT_BETWEEN.createCall(pos, ((SqlCall)operand).getOperandList());
        }
        if (operand.getKind().equals((Object)SqlKind.IN)) {
            return SqlStdOperatorTable.NOT_IN.createCall(pos, ((SqlCall)operand).getOperandList());
        }
        return SqlStdOperatorTable.NOT.createCall(pos, operand);
    }

    @Override
    protected SqlNode visitSingleColumn(SingleColumn node, ParserVisitorContext context) {
        if (node.getAlias().isPresent()) {
            return SqlStdOperatorTable.AS.createCall(this.getPos(node), (SqlNode)this.process(node.getExpression(), context), (SqlNode)this.process(node.getAlias().get(), context));
        }
        return (SqlNode)this.process(node.getExpression(), context);
    }

    @Override
    protected SqlNode visitAllColumns(AllColumns node, ParserVisitorContext context) {
        if (!node.getAliases().isEmpty()) {
            throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
        }
        if (node.getTarget().isPresent()) {
            SqlNode target = (SqlNode)this.process(node.getTarget().get(), context);
            if (target.getKind().equals((Object)SqlKind.IDENTIFIER)) {
                ArrayList<String> names = new ArrayList<String>(((SqlIdentifier)target).names);
                names.add("");
                return CalciteUtil.createSqlIdentifier(this.getPos(node), names.toArray(new String[0]));
            }
            return SqlStdOperatorTable.DOT.createCall(this.getPos(node), target, CalciteUtil.createStarIdentifier(SqlParserPos.ZERO));
        }
        return CalciteUtil.createStarIdentifier(this.getPos(node));
    }

    @Override
    protected SqlNode visitSearchedCaseExpression(SearchedCaseExpression node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos(node);
        ArrayList<SqlNode> whenClauses = new ArrayList<SqlNode>();
        ArrayList<SqlNode> thenClauses = new ArrayList<SqlNode>();
        node.getWhenClauses().forEach(caseWhen -> {
            whenClauses.add((SqlNode)this.process(caseWhen.getOperand(), context));
            thenClauses.add((SqlNode)this.process(caseWhen.getResult(), context));
        });
        SqlNode defaultValue = node.getDefaultValue().isPresent() ? (SqlNode)this.process(node.getDefaultValue().get(), context) : CalciteUtil.createLiteralNull(SqlParserPos.ZERO);
        return SqlStdOperatorTable.CASE.createCall(null, pos, null, CalciteUtil.createSqlNodeList(whenClauses, pos), CalciteUtil.createSqlNodeList(thenClauses, pos), defaultValue);
    }

    @Override
    protected SqlNode visitLikePredicate(LikePredicate node, ParserVisitorContext context) {
        return SqlStdOperatorTable.LIKE.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
    }

    @Override
    protected SqlNode visitIsNotNullPredicate(IsNotNullPredicate node, ParserVisitorContext context) {
        return SqlStdOperatorTable.IS_NOT_NULL.createCall(this.getPos(node), (SqlNode)this.process(node.getValue(), context));
    }

    @Override
    protected SqlNode visitIsNullPredicate(IsNullPredicate node, ParserVisitorContext context) {
        return SqlStdOperatorTable.IS_NULL.createCall(this.getPos(node), (SqlNode)this.process(node.getValue(), context));
    }

    @Override
    protected SqlNode visitArrayConstructor(ArrayConstructor node, ParserVisitorContext context) {
        return SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
    }

    @Override
    protected SqlNode visitSubscriptExpression(SubscriptExpression node, ParserVisitorContext context) {
        return SqlStdOperatorTable.ITEM.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
    }

    @Override
    protected SqlNode visitLongLiteral(LongLiteral node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralNumber(node.getValue(), this.getPos(node));
    }

    @Override
    protected SqlNode visitParameter(Parameter node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralNumber(node.getPosition(), this.getPos(node));
    }

    @Override
    protected SqlNode visitLogicalBinaryExpression(LogicalBinaryExpression node, ParserVisitorContext context) {
        if (node.getOperator().equals((Object)LogicalBinaryExpression.Operator.AND)) {
            return SqlStdOperatorTable.AND.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
        }
        return SqlStdOperatorTable.OR.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
    }

    @Override
    protected SqlNode visitSubqueryExpression(SubqueryExpression node, ParserVisitorContext context) {
        return (SqlNode)this.process(node.getQuery(), context);
    }

    @Override
    protected SqlNode visitSortItem(SortItem node, ParserVisitorContext context) {
        SqlNode ordering;
        SqlParserPos pos = this.getPos(node);
        SqlNode operand = (SqlNode)this.process(node.getSortKey(), context);
        SqlNode sqlNode = ordering = node.getOrdering().equals((Object)SortItem.Ordering.DESCENDING) ? SqlStdOperatorTable.DESC.createCall(pos, operand) : operand;
        if (node.getNullOrdering().equals((Object)SortItem.NullOrdering.FIRST)) {
            return SqlStdOperatorTable.NULLS_FIRST.createCall(pos, ordering);
        }
        if (node.getNullOrdering().equals((Object)SortItem.NullOrdering.LAST)) {
            return SqlStdOperatorTable.NULLS_LAST.createCall(pos, ordering);
        }
        return ordering;
    }

    @Override
    protected SqlNode visitTable(Table node, ParserVisitorContext context) {
        return this.convertQualifiedName(node.getName(), this.getPos(node));
    }

    @Override
    protected SqlNode visitUnnest(Unnest node, ParserVisitorContext context) {
        if (node.isWithOrdinality()) {
            return SqlStdOperatorTable.UNNEST_WITH_ORDINALITY.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
        }
        return SqlStdOperatorTable.UNNEST.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
    }

    @Override
    protected SqlNode visitLateral(Lateral node, ParserVisitorContext context) {
        return (SqlNode)this.process(node.getQuery(), context);
    }

    @Override
    protected SqlNode visitValues(Values node, ParserVisitorContext context) {
        return SqlStdOperatorTable.VALUES.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
    }

    @Override
    protected SqlNode visitRow(Row node, ParserVisitorContext context) {
        return SqlStdOperatorTable.ROW.createCall(this.getPos(node), this.getChildSqlNodeList(node, context).getList());
    }

    @Override
    protected SqlNode visitTableSubquery(TableSubquery node, ParserVisitorContext context) {
        return (SqlNode)this.process(node.getQuery(), context);
    }

    @Override
    protected SqlNode visitAliasedRelation(AliasedRelation node, ParserVisitorContext context) {
        ArrayList<Object> operands = new ArrayList<Object>();
        operands.add(this.process(node.getRelation(), context));
        operands.add(this.visitIdentifier(node.getAlias(), context));
        operands.addAll(this.toListOfSqlNode(node.getColumnNames(), context));
        return SqlStdOperatorTable.AS.createCall(this.getPos(node), operands);
    }

    @Override
    protected SqlNode visitSampledRelation(SampledRelation node, ParserVisitorContext context) {
        ArrayList<Object> operands = new ArrayList<Object>();
        operands.add(this.process(node.getRelation(), context));
        SqlNode percentageNode = (SqlNode)this.process(node.getSamplePercentage(), context);
        float percentage = 0.0f;
        if (!(percentageNode instanceof SqlNumericLiteral)) {
            throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
        }
        percentage = (float)((double)((SqlNumericLiteral)percentageNode).longValue(true) / 100.0);
        operands.add(SqlLiteral.createSample(SqlSampleSpec.createTableSample(node.getType().equals((Object)SampledRelation.Type.BERNOULLI), percentage), this.getPos(node)));
        return SqlStdOperatorTable.TABLESAMPLE.createCall(this.getPos(node), operands);
    }

    @Override
    protected SqlNode visitJoin(Join node, ParserVisitorContext context) {
        JoinType joinType;
        SqlNode left = (SqlNode)this.process(node.getLeft(), context);
        SqlNode right = (SqlNode)this.process(node.getRight(), context);
        SqlLiteral natural = CalciteUtil.createLiteralBoolean(false, SqlParserPos.ZERO);
        JoinConditionType conditionType = JoinConditionType.NONE;
        SqlNode condition = null;
        if (node.getCriteria().isPresent()) {
            JoinCriteria joinCriteria = node.getCriteria().get();
            natural = CalciteUtil.createLiteralBoolean(joinCriteria instanceof .NaturalJoin, SqlParserPos.ZERO);
            if (joinCriteria instanceof JoinOn) {
                conditionType = JoinConditionType.ON;
                condition = (SqlNode)this.process(((JoinOn)joinCriteria).getExpression(), context);
            } else if (joinCriteria instanceof JoinUsing) {
                conditionType = JoinConditionType.USING;
                condition = this.toSqlNodeList(((JoinUsing)joinCriteria).getColumns(), context, this.getPos(node));
            }
        }
        if ((joinType = (JoinType)((Object)JOIN_TYPE_MAP.get((Object)node.getType()))) == null) {
            throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
        }
        return new SqlJoin(this.getPos(node), left, natural, joinType.symbol(SqlParserPos.ZERO), right, conditionType.symbol(SqlParserPos.ZERO), condition);
    }

    @Override
    protected SqlNode visitExists(ExistsPredicate node, ParserVisitorContext context) {
        return SqlStdOperatorTable.EXISTS.createCall(this.getPos(node), (SqlNode)this.process(node.getSubquery(), context));
    }

    @Override
    protected SqlNode visitCast(Cast node, ParserVisitorContext context) {
        SqlDataTypeSpec spec = (SqlDataTypeSpec)this.process(node.getType(), context);
        return SqlStdOperatorTable.CAST.createCall(this.getPos(node), (SqlNode)this.process(node.getExpression(), context), spec);
    }

    @Override
    protected SqlNode visitFieldReference(FieldReference node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralNumber(node.getFieldIndex(), this.getPos(node));
    }

    @Override
    protected SqlNode visitWindowSpecification(WindowSpecification node, ParserVisitorContext context) {
        SqlParserPos pos = this.getPos(node);
        SqlNodeList partitionList = this.toSqlNodeList(node.getPartitionBy(), context, pos);
        SqlNodeList orderList = ObjectUtils.defaultIfNull((SqlNodeList)this.processOptional(node.getOrderBy(), context), CalciteUtil.createSqlNodeList(Collections.emptyList(), SqlParserPos.ZERO));
        ParserVisitorContext frameContext = new ParserVisitorContext();
        if (node.getFrame().isPresent()) {
            this.process(node.getFrame().get(), frameContext);
        }
        return frameContext.createWindow(pos, partitionList, orderList);
    }

    @Override
    protected SqlNode visitWindowFrame(WindowFrame node, ParserVisitorContext context) {
        context.isRows = node.getType().equals((Object)WindowFrame.Type.ROWS);
        context.lowerBound = this.visitFrameBound(node.getStart(), context);
        context.upperBound = node.getEnd().isPresent() ? this.visitFrameBound(node.getEnd().get(), context) : null;
        return null;
    }

    @Override
    protected SqlNode visitFrameBound(FrameBound node, ParserVisitorContext context) {
        if (node.getValue().isPresent()) {
            return this.getUnresolvedFunction(node.getType().name(), Collections.singletonList(this.process(node.getValue().get(), context)));
        }
        return SqlLiteral.createSymbol(node.getType(), SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitCallArgument(CallArgument node, ParserVisitorContext context) {
        return (SqlNode)this.process(node.getValue(), context);
    }

    @Override
    protected SqlNode visitLikeClause(LikeClause node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitCreateSchema(CreateSchema node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitDropSchema(DropSchema node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitRenameSchema(RenameSchema node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitCreateTable(CreateTable node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitCreateTableAsSelect(CreateTableAsSelect node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitProperty(Property node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitDropTable(DropTable node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitRenameTable(RenameTable node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitRenameColumn(RenameColumn node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitDropColumn(DropColumn node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitAddColumn(AddColumn node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitAnalyze(Analyze node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitCreateView(CreateView node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitDropView(DropView node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitCreateMaterializedView(CreateMaterializedView node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitDropMaterializedView(DropMaterializedView node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitRefreshMaterializedView(RefreshMaterializedView node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitInsert(Insert node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitCall(Call node, ParserVisitorContext context) {
        return SqlStdOperatorTable.PROCEDURE_CALL.createCall(this.getPos(node), this.getUnresolvedFunction(node.getName().toString(), this.toListOfSqlNode(node.getArguments(), context)));
    }

    @Override
    protected SqlNode visitDelete(Delete node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitStartTransaction(StartTransaction node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitCreateRole(CreateRole node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitDropRole(DropRole node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitGrantRoles(GrantRoles node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitRevokeRoles(RevokeRoles node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitSetRole(SetRole node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitGrant(Grant node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitRevoke(Revoke node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitShowGrants(ShowGrants node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitShowRoles(ShowRoles node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitShowRoleGrants(ShowRoleGrants node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitTransactionMode(TransactionMode node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitIsolationLevel(Isolation node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitTransactionAccessMode(TransactionAccessMode node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitCommit(Commit node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitRollback(Rollback node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitAtTimeZone(AtTimeZone node, ParserVisitorContext context) {
        return this.getUnresolvedFunction("AT_TIMEZONE", this.getChildSqlNodeList(node, context).getList());
    }

    @Override
    protected SqlNodeList visitGroupBy(GroupBy node, ParserVisitorContext context) {
        return this.getChildSqlNodeList(node, context);
    }

    @Override
    protected SqlNode visitCube(Cube node, ParserVisitorContext context) {
        return SqlStdOperatorTable.CUBE.createCall(this.getPos(node), this.toListOfSqlNode(node.getExpressions(), context));
    }

    @Override
    protected SqlNode visitGroupingSets(GroupingSets node, ParserVisitorContext context) {
        List<List<Expression>> sets = node.getSets();
        ArrayList<SqlNode> operands = new ArrayList<SqlNode>();
        for (List<Expression> expressions : sets) {
            if (expressions.isEmpty()) {
                operands.add(CalciteUtil.createSqlNodeList(Collections.emptyList()));
                continue;
            }
            if (expressions.size() > 1) {
                operands.add(SqlStdOperatorTable.ROW.createCall(SqlParserPos.ZERO, this.toSqlNodeList(expressions, context, this.getPos(node))));
                continue;
            }
            operands.add((SqlNode)this.process(expressions.get(0), context));
        }
        return SqlStdOperatorTable.GROUPING_SETS.createCall(this.getPos(node), operands);
    }

    @Override
    protected SqlNode visitRollup(Rollup node, ParserVisitorContext context) {
        return SqlStdOperatorTable.ROLLUP.createCall(this.getPos(node), this.toListOfSqlNode(node.getExpressions(), context));
    }

    @Override
    protected SqlNode visitSimpleGroupBy(SimpleGroupBy node, ParserVisitorContext context) {
        Preconditions.checkArgument((node.getExpressions().size() == 1 ? 1 : 0) != 0, (Object)"SimpleGroupBy should have only one element in the expression.");
        return (SqlNode)this.process(node.getExpressions().get(0), context);
    }

    @Override
    protected SqlNode visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, ParserVisitorContext context) {
        SqlNode left = (SqlNode)this.process(node.getValue(), context);
        SqlNode right = (SqlNode)this.process(node.getSubquery(), context);
        SqlParserPos pos = this.getPos(node);
        if (node.getQuantifier().equals((Object)QuantifiedComparisonExpression.Quantifier.ALL)) {
            return ((SqlOperator)ALL_COMPARISON_OPERATOR.get((Object)node.getOperator())).createCall(pos, left, right);
        }
        return ((SqlOperator)SOME_COMPARISON_OPERATOR.get((Object)node.getOperator())).createCall(pos, left, right);
    }

    @Override
    protected SqlNode visitLambdaArgumentDeclaration(LambdaArgumentDeclaration node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, LAMBDA_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitBindExpression(BindExpression node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, LAMBDA_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitGroupingOperation(GroupingOperation node, ParserVisitorContext context) {
        return SqlStdOperatorTable.GROUPING.createCall(this.getPos(node), this.toListOfSqlNode(node.getGroupingColumns(), context));
    }

    @Override
    protected SqlNode visitCurrentUser(CurrentUser node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitPrepare(Prepare node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitDeallocate(Deallocate node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitExecute(Execute node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitDescribeOutput(DescribeOutput node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitDescribeInput(DescribeInput node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitExplain(Explain node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitShowTables(ShowTables node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitShowSchemas(ShowSchemas node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitShowCatalogs(ShowCatalogs node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitShowColumns(ShowColumns node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitShowStats(ShowStats node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitShowCreate(ShowCreate node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitShowFunctions(ShowFunctions node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitUse(Use node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitShowSession(ShowSession node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitSetSession(SetSession node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitResetSession(ResetSession node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitExplainOption(ExplainOption node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitTryExpression(TryExpression node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
    }

    @Override
    protected SqlNode visitColumnDefinition(ColumnDefinition node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitSymbolReference(SymbolReference node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
    }

    @Override
    protected SqlNode visitFetchFirst(FetchFirst node, ParserVisitorContext context) {
        if (node.isWithTies()) {
            throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
        }
        if (!node.getRowCount().isPresent()) {
            return null;
        }
        return (SqlNode)this.process(node.getRowCount().get(), context);
    }

    @Override
    protected SqlNode visitLimit(Limit node, ParserVisitorContext context) {
        return (SqlNode)this.process(node.getRowCount(), context);
    }

    @Override
    protected SqlNode visitAllRows(.AllRows node, ParserVisitorContext context) {
        return null;
    }

    @Override
    protected SqlNode visitWindowReference(WindowReference node, ParserVisitorContext context) {
        return this.visitIdentifier(node.getName(), context);
    }

    @Override
    protected SqlNode visitWindowDefinition(WindowDefinition node, ParserVisitorContext context) {
        SqlWindow window = (SqlWindow)this.visitWindowSpecification(node.getWindow(), context);
        return SqlWindow.create(this.visitIdentifier(node.getName(), context), window.getRefName(), window.getPartitionList(), window.getOrderList(), CalciteUtil.createLiteralBoolean(window.isRows(), SqlParserPos.ZERO), window.getLowerBound(), window.getUpperBound(), CalciteUtil.createLiteralBoolean(window.isAllowPartial(), SqlParserPos.ZERO), window.getParserPosition());
    }

    @Override
    protected SqlNode visitMergeInsert(MergeInsert node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitMergeUpdate(MergeUpdate node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitMergeDelete(MergeDelete node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitSetSchemaAuthorization(SetSchemaAuthorization node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitRenameView(RenameView node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitSetViewAuthorization(SetViewAuthorization node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitComment(Comment node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitSetTableAuthorization(SetTableAuthorization node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitUpdate(Update node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitUpdateAssignment(UpdateAssignment node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitSetPath(SetPath node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitPathSpecification(PathSpecification node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitPathElement(PathElement node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitCurrentPath(CurrentPath node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitFormat(Format node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
    }

    @Override
    protected SqlNode visitMerge(Merge node, ParserVisitorContext context) {
        throw new UnhandledASTNodeException(node, DDL_NOT_SUPPORT_MSG);
    }

    @Override
    protected SqlNode visitRowDataType(RowDataType node, ParserVisitorContext context) {
        ParserVisitorContext rowContext = new ParserVisitorContext();
        node.getFields().forEach(f -> {
            SqlNode cfr_ignored_0 = (SqlNode)this.process((Node)f, rowContext);
        });
        return rowContext.createRowType(this.getPos(node));
    }

    @Override
    protected SqlNode visitGenericDataType(GenericDataType node, ParserVisitorContext context) {
        if (node.getArguments().isEmpty()) {
            return SqlTypeUtil.convertTypeToSpec(this.sqlTypeFactory.createSqlType(SqlTypeName.valueOf(node.getName().getValue().toUpperCase())));
        }
        switch (node.getName().getValue().toUpperCase()) {
            case "DECIMAL": {
                int precision = this.getNumberFromNumericParameter(node.getArguments().get(0));
                int scale = node.getArguments().size() > 1 ? this.getNumberFromNumericParameter(node.getArguments().get(0)) : 0;
                return SqlTypeUtil.convertTypeToSpec(this.sqlTypeFactory.createSqlType(SqlTypeName.DECIMAL, precision, scale));
            }
            case "CHAR": 
            case "VARCHAR": 
            case "BINARY": {
                int len = this.getNumberFromNumericParameter(node.getArguments().get(0));
                return SqlTypeUtil.convertTypeToSpec(this.sqlTypeFactory.createSqlType(SqlTypeName.valueOf(node.getName().getValue().toUpperCase()), len));
            }
            case "ARRAY": {
                return new SqlArrayTypeSpec((SqlDataTypeSpec)this.process(node.getArguments().get(0)), SqlParserPos.ZERO);
            }
            case "MAP": {
                return new SqlMapTypeSpec((SqlDataTypeSpec)this.process(node.getArguments().get(0)), (SqlDataTypeSpec)this.process(node.getArguments().get(1)), SqlParserPos.ZERO);
            }
        }
        throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
    }

    @Override
    protected SqlNode visitRowField(RowDataType.Field node, ParserVisitorContext context) {
        if (!node.getName().isPresent()) {
            throw new UnhandledASTNodeException(node, UNSUPPORTED_EXCEPTION_MSG);
        }
        context.fieldTypes.add((SqlDataTypeSpec)this.process(node.getType(), context));
        context.fieldNames.add((SqlIdentifier)this.process(node.getName().get(), context));
        return null;
    }

    @Override
    protected SqlNode visitIntervalDataType(IntervalDayTimeDataType node, ParserVisitorContext context) {
        return new SqlIntervalQualifier((TimeUnit)((Object)TIME_UNIT_MAP.get((Object)node.getFrom().name())), (TimeUnit)((Object)TIME_UNIT_MAP.get((Object)node.getTo().name())), this.getPos(node));
    }

    int getNumberFromNumericParameter(Node numericParameter) {
        return Integer.parseInt(((NumericParameter)numericParameter).getValue());
    }

    @Override
    protected SqlNode visitDateTimeType(DateTimeDataType node, ParserVisitorContext context) {
        int precision = node.getPrecision().isPresent() ? this.getNumberFromNumericParameter(node.getPrecision().get()) : -1;
        SqlParserPos pos = this.getPos(node);
        if (node.isWithTimeZone()) {
            if (node.getType().equals((Object)DateTimeDataType.Type.TIME)) {
                return new SqlDataTypeSpec(new SqlBasicTypeNameSpec(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, precision, pos), pos);
            }
            return new SqlDataTypeSpec(new SqlBasicTypeNameSpec(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, precision, pos), pos);
        }
        return new SqlDataTypeSpec(new SqlBasicTypeNameSpec(SqlTypeName.valueOf(node.getType().name()), precision, pos), pos);
    }

    @Override
    protected SqlNode visitNumericTypeParameter(NumericParameter node, ParserVisitorContext context) {
        return CalciteUtil.createLiteralNumber(this.getNumberFromNumericParameter(node), this.getPos(node));
    }

    @Override
    protected SqlNode visitTypeParameter(TypeParameter node, ParserVisitorContext context) {
        return (SqlNode)this.process(node.getValue(), context);
    }
}

