/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.calcite.$internal.com.google.common.base.CaseFormat;
import com.linkedin.coral.calcite.$internal.com.google.common.base.Converter;
import com.linkedin.coral.common.transformers.SqlCallTransformer;
import com.linkedin.coral.hive.hive2rel.functions.StaticHiveFunctionRegistry;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;

public class GenericCoralRegistryOperatorRenameSqlCallTransformer
extends SqlCallTransformer {
    private static final StaticHiveFunctionRegistry HIVE_FUNCTION_REGISTRY = new StaticHiveFunctionRegistry();

    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator().getName().startsWith("com.linkedin");
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        Converter<String, String> caseConverter = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);
        SqlOperator sourceOp = HIVE_FUNCTION_REGISTRY.getRegistry().containsKey(sqlCall.getOperator().getName()) ? HIVE_FUNCTION_REGISTRY.lookup(sqlCall.getOperator().getName()).iterator().next().getSqlOperator() : sqlCall.getOperator();
        String[] nameSplit = sourceOp.getName().split("\\.");
        String targetName = caseConverter.convert(nameSplit[nameSplit.length - 1]);
        SqlOperator targetOp = GenericCoralRegistryOperatorRenameSqlCallTransformer.createSqlOperator(targetName, sourceOp.getReturnTypeInference());
        return targetOp.createCall(new SqlNodeList(sqlCall.getOperandList(), SqlParserPos.ZERO));
    }
}

