/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.memory;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.Memory;
import com.linkedin.coral.calcite.$internal.com.yahoo.memory.MemoryRequest;
import com.linkedin.coral.calcite.$internal.com.yahoo.memory.MemoryUtil;
import com.linkedin.coral.calcite.$internal.com.yahoo.memory.NativeMemoryR;
import com.linkedin.coral.calcite.$internal.com.yahoo.memory.ReadOnlyMemoryException;
import com.linkedin.coral.calcite.$internal.com.yahoo.memory.UnsafeUtil;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;

public class NativeMemory
implements Memory {
    final long objectBaseOffset_;
    final Object memArray_;
    final ByteBuffer byteBuf_;
    final boolean direct_;
    long nativeBaseAddress_;
    long capacityBytes_;
    private long cumBaseOffset_;
    MemoryRequest memReq_ = null;

    protected NativeMemory(long nativeBaseAddress, long capacityBytes, long objectBaseOffset, Object memArray, ByteBuffer byteBuf) {
        this.nativeBaseAddress_ = nativeBaseAddress;
        this.capacityBytes_ = capacityBytes;
        this.objectBaseOffset_ = objectBaseOffset;
        this.memArray_ = memArray;
        this.byteBuf_ = byteBuf;
        this.cumBaseOffset_ = this.nativeBaseAddress_ + this.objectBaseOffset_;
        boolean bl = this.direct_ = this.nativeBaseAddress_ > 0L;
        if ((this.cumBaseOffset_ - 1L | nativeBaseAddress | objectBaseOffset | this.capacityBytes_ - 1L) < 0L) {
            throw new IllegalArgumentException("Illegal constructor arguments.");
        }
    }

    public NativeMemory(boolean[] booleanArray) {
        this(0L, MemoryUtil.checkBooleanArr(booleanArray), UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET, booleanArray, null);
    }

    public NativeMemory(byte[] byteArray) {
        this(0L, MemoryUtil.checkByteArr(byteArray), UnsafeUtil.ARRAY_BYTE_BASE_OFFSET, byteArray, null);
    }

    public NativeMemory(char[] charArray) {
        this(0L, MemoryUtil.checkCharArr(charArray), UnsafeUtil.ARRAY_CHAR_BASE_OFFSET, charArray, null);
    }

    public NativeMemory(short[] shortArray) {
        this(0L, MemoryUtil.checkShortArr(shortArray), UnsafeUtil.ARRAY_SHORT_BASE_OFFSET, shortArray, null);
    }

    public NativeMemory(int[] intArray) {
        this(0L, MemoryUtil.checkIntArr(intArray), UnsafeUtil.ARRAY_INT_BASE_OFFSET, intArray, null);
    }

    public NativeMemory(long[] longArray) {
        this(0L, MemoryUtil.checkLongArr(longArray), UnsafeUtil.ARRAY_LONG_BASE_OFFSET, longArray, null);
    }

    public NativeMemory(float[] floatArray) {
        this(0L, MemoryUtil.checkFloatArr(floatArray), UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET, floatArray, null);
    }

    public NativeMemory(double[] doubleArray) {
        this(0L, MemoryUtil.checkDoubleArr(doubleArray), UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET, doubleArray, null);
    }

    public static Memory wrap(ByteBuffer byteBuffer) {
        long capacityBytes = byteBuffer.capacity();
        ByteBuffer byteBuf = byteBuffer;
        boolean readOnly = byteBuffer.isReadOnly();
        boolean direct = byteBuffer.isDirect();
        if (readOnly) {
            Object memArray;
            long arrayOffset;
            if (direct) {
                long nativeBaseAddress = ((DirectBuffer)((Object)byteBuf)).address();
                long objectBaseOffset = 0L;
                Object memArray2 = null;
                NativeMemoryR nmr = new NativeMemoryR(nativeBaseAddress, capacityBytes, objectBaseOffset, memArray2, byteBuf);
                nmr.memReq_ = null;
                return nmr;
            }
            try {
                Field field = ByteBuffer.class.getDeclaredField("offset");
                field.setAccessible(true);
                arrayOffset = ((Integer)field.get(byteBuffer)).intValue();
                field = ByteBuffer.class.getDeclaredField("hb");
                field.setAccessible(true);
                memArray = field.get(byteBuffer);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Could not get offset/byteArray from OnHeap ByteBuffer instance: " + e.getClass());
            }
            long nativeBaseAddress = 0L;
            long objectBaseOffset = (long)UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + arrayOffset * (long)UnsafeUtil.ARRAY_BYTE_INDEX_SCALE;
            NativeMemoryR nmr = new NativeMemoryR(nativeBaseAddress, capacityBytes, objectBaseOffset, memArray, byteBuf);
            nmr.memReq_ = null;
            return nmr;
        }
        if (direct) {
            long nativeBaseAddress = ((DirectBuffer)((Object)byteBuf)).address();
            long objectBaseOffset = 0L;
            Object memArray = null;
            NativeMemory nm = new NativeMemory(nativeBaseAddress, capacityBytes, objectBaseOffset, memArray, byteBuf);
            nm.memReq_ = null;
            return nm;
        }
        long nativeBaseAddress = 0L;
        long objectBaseOffset = UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + byteBuf.arrayOffset() * UnsafeUtil.ARRAY_BYTE_INDEX_SCALE;
        byte[] memArray = byteBuf.array();
        NativeMemory nm = new NativeMemory(nativeBaseAddress, capacityBytes, objectBaseOffset, memArray, byteBuf);
        nm.memReq_ = null;
        return nm;
    }

    @Deprecated
    public NativeMemory(ByteBuffer byteBuf) {
        MemoryUtil.checkByteBufRO(byteBuf);
        if (byteBuf.isDirect()) {
            this.objectBaseOffset_ = 0L;
            this.memArray_ = null;
            this.nativeBaseAddress_ = ((DirectBuffer)((Object)byteBuf)).address();
            this.cumBaseOffset_ = this.nativeBaseAddress_ + this.objectBaseOffset_;
        } else {
            this.objectBaseOffset_ = UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + byteBuf.arrayOffset() * UnsafeUtil.ARRAY_BYTE_INDEX_SCALE;
            this.memArray_ = byteBuf.array();
            this.nativeBaseAddress_ = 0L;
            this.cumBaseOffset_ = this.nativeBaseAddress_ + this.objectBaseOffset_;
        }
        this.byteBuf_ = byteBuf;
        this.capacityBytes_ = byteBuf.capacity();
        this.direct_ = this.nativeBaseAddress_ > 0L;
    }

    @Override
    public boolean getBoolean(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BOOLEAN_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getBoolean(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getBooleanArray(long offsetBytes, boolean[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (dstOffset << 0), copyBytes);
    }

    @Override
    public byte getByte(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getByte(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getByteArray(long offsetBytes, byte[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (dstOffset << 0), copyBytes);
    }

    @Override
    public char getChar(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_CHAR_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getChar(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getCharArray(long offsetBytes, char[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_CHAR_BASE_OFFSET + (dstOffset << 1), copyBytes);
    }

    @Override
    public double getDouble(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_DOUBLE_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getDouble(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getDoubleArray(long offsetBytes, double[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET + (dstOffset << 3), copyBytes);
    }

    @Override
    public float getFloat(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_FLOAT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getFloat(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getFloatArray(long offsetBytes, float[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET + (dstOffset << 2), copyBytes);
    }

    @Override
    public int getInt(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getInt(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getIntArray(long offsetBytes, int[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_INT_BASE_OFFSET + (dstOffset << 2), copyBytes);
    }

    @Override
    public long getLong(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getLong(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getLongArray(long offsetBytes, long[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_LONG_BASE_OFFSET + (dstOffset << 3), copyBytes);
    }

    @Override
    public short getShort(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_SHORT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getShort(this.memArray_, this.getAddress(offsetBytes));
    }

    @Override
    public void getShortArray(long offsetBytes, short[] dstArray, int dstOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.memArray_, this.getAddress(offsetBytes), dstArray, UnsafeUtil.ARRAY_SHORT_BASE_OFFSET + (dstOffset << 1), copyBytes);
    }

    @Override
    public boolean isAllBitsClear(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        int value = ~UnsafeUtil.unsafe.getByte(this.memArray_, this.getAddress(offsetBytes)) & bitMask & 0xFF;
        return value == bitMask;
    }

    @Override
    public boolean isAllBitsSet(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        int value = UnsafeUtil.unsafe.getByte(this.memArray_, this.getAddress(offsetBytes)) & bitMask & 0xFF;
        return value == bitMask;
    }

    @Override
    public boolean isAnyBitsClear(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        int value = ~UnsafeUtil.unsafe.getByte(this.memArray_, this.getAddress(offsetBytes)) & bitMask & 0xFF;
        return value != 0;
    }

    @Override
    public boolean isAnyBitsSet(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        int value = UnsafeUtil.unsafe.getByte(this.memArray_, this.getAddress(offsetBytes)) & bitMask & 0xFF;
        return value != 0;
    }

    @Override
    public void putBoolean(long offsetBytes, boolean srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BOOLEAN_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putBoolean(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putBooleanArray(long offsetBytes, boolean[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (srcOffset << 0), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putByte(long offsetBytes, byte srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putByte(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putByteArray(long offsetBytes, byte[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (srcOffset << 0), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putChar(long offsetBytes, char srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_CHAR_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putChar(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putCharArray(long offsetBytes, char[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_CHAR_BASE_OFFSET + (srcOffset << 1), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putDouble(long offsetBytes, double srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_DOUBLE_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putDouble(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putDoubleArray(long offsetBytes, double[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET + (srcOffset << 3), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putFloat(long offsetBytes, float srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_FLOAT_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putFloat(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putFloatArray(long offsetBytes, float[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET + (srcOffset << 2), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putInt(long offsetBytes, int srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putInt(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putIntArray(long offsetBytes, int[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_INT_BASE_OFFSET + (srcOffset << 2), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putLong(long offsetBytes, long srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putLong(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putLongArray(long offsetBytes, long[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_LONG_BASE_OFFSET + (srcOffset << 3), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void putShort(long offsetBytes, short srcValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_SHORT_INDEX_SCALE, this.capacityBytes_);
        UnsafeUtil.unsafe.putShort(this.memArray_, this.getAddress(offsetBytes), srcValue);
    }

    @Override
    public void putShortArray(long offsetBytes, short[] srcArray, int srcOffset, int length) {
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_SHORT_BASE_OFFSET + (srcOffset << 1), this.memArray_, this.getAddress(offsetBytes), copyBytes);
    }

    @Override
    public void setBits(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        byte value = UnsafeUtil.unsafe.getByte(this.memArray_, unsafeRawAddress);
        UnsafeUtil.unsafe.putByte(this.memArray_, unsafeRawAddress, (byte)(value | bitMask));
    }

    @Override
    public int addAndGetInt(long offsetBytes, int delta) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getAndAddInt(this.memArray_, this.getAddress(offsetBytes), delta) + delta;
    }

    @Override
    public long addAndGetLong(long offsetBytes, long delta) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getAndAddLong(this.memArray_, this.getAddress(offsetBytes), delta) + delta;
    }

    @Override
    public boolean compareAndSwapInt(long offsetBytes, int expect, int update) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.compareAndSwapInt(this.memArray_, this.getAddress(offsetBytes), expect, update);
    }

    @Override
    public boolean compareAndSwapLong(long offsetBytes, long expect, long update) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.compareAndSwapLong(this.memArray_, this.getAddress(offsetBytes), expect, update);
    }

    @Override
    public int getAndSetInt(long offsetBytes, int newValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getAndSetInt(this.memArray_, this.getAddress(offsetBytes), newValue);
    }

    @Override
    public long getAndSetLong(long offsetBytes, long newValue) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacityBytes_);
        return UnsafeUtil.unsafe.getAndSetLong(this.memArray_, this.getAddress(offsetBytes), newValue);
    }

    @Override
    public Object array() {
        return this.memArray_;
    }

    @Override
    public Memory asReadOnlyMemory() {
        NativeMemoryR nmr = new NativeMemoryR(this);
        nmr.memReq_ = this.memReq_;
        return nmr;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.byteBuf_;
    }

    @Override
    public void clear() {
        this.fill(0L, this.capacityBytes_, (byte)0);
    }

    @Override
    public void clear(long offsetBytes, long lengthBytes) {
        this.fill(offsetBytes, lengthBytes, (byte)0);
    }

    @Override
    public void clearBits(long offsetBytes, byte bitMask) {
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        int value = UnsafeUtil.unsafe.getByte(this.memArray_, unsafeRawAddress) & 0xFF;
        UnsafeUtil.unsafe.putByte(this.memArray_, unsafeRawAddress, (byte)(value &= ~bitMask));
    }

    @Override
    @Deprecated
    public void copy(long srcOffsetBytes, long dstOffsetBytes, long lengthBytes) {
        this.copy(srcOffsetBytes, this, dstOffsetBytes, lengthBytes);
    }

    @Override
    public void copy(long srcOffsetBytes, Memory destination, long dstOffsetBytes, long lengthBytes) {
        if (destination.isReadOnly()) {
            throw new ReadOnlyMemoryException();
        }
        UnsafeUtil.assertBounds(srcOffsetBytes, lengthBytes, this.getCapacity());
        UnsafeUtil.assertBounds(dstOffsetBytes, lengthBytes, destination.getCapacity());
        assert (this != destination || UnsafeUtil.checkOverlap(srcOffsetBytes, dstOffsetBytes, lengthBytes));
        long srcAdd = this.getCumulativeOffset(srcOffsetBytes);
        long dstAdd = destination.getCumulativeOffset(dstOffsetBytes);
        Object srcParent = this.isDirect() ? null : this.memArray_;
        Object dstParent = destination.isDirect() ? null : destination.array();
        long lenBytes = lengthBytes;
        while (lenBytes > 0L) {
            long chunkBytes = lenBytes > 0x100000L ? 0x100000L : lenBytes;
            UnsafeUtil.unsafe.copyMemory(srcParent, srcAdd, dstParent, dstAdd, lenBytes);
            lenBytes -= chunkBytes;
            srcAdd += chunkBytes;
            dstAdd += chunkBytes;
        }
    }

    @Override
    public void fill(byte value) {
        this.fill(0L, this.capacityBytes_, value);
    }

    @Override
    public void fill(long offsetBytes, long lengthBytes, byte value) {
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacityBytes_);
        UnsafeUtil.unsafe.setMemory(this.memArray_, this.getAddress(offsetBytes), lengthBytes, value);
    }

    @Override
    public long getAddress(long offsetBytes) {
        UnsafeUtil.assertBounds(offsetBytes, 0L, this.capacityBytes_);
        return this.cumBaseOffset_ + offsetBytes;
    }

    @Override
    public long getCapacity() {
        return this.capacityBytes_;
    }

    @Override
    public long getCumulativeOffset(long offsetBytes) {
        return this.getAddress(offsetBytes);
    }

    @Override
    public MemoryRequest getMemoryRequest() {
        return this.memReq_;
    }

    @Override
    public Object getParent() {
        return this.memArray_;
    }

    @Override
    public boolean hasArray() {
        return this.memArray_ != null;
    }

    @Override
    public boolean hasByteBuffer() {
        return this.byteBuf_ != null;
    }

    @Override
    public boolean isAllocated() {
        return this.capacityBytes_ > 0L;
    }

    @Override
    public boolean isDirect() {
        return this.direct_;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setMemoryRequest(MemoryRequest memReq) {
        this.memReq_ = memReq;
    }

    @Override
    public String toHexString(String header, long offsetBytes, int lengthBytes) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(UnsafeUtil.LS);
        String s1 = String.format("(..., %d, %d)", offsetBytes, lengthBytes);
        sb.append(this.getClass().getSimpleName()).append(".toHexString").append(s1).append(", hash: ").append(this.hashCode()).append(UnsafeUtil.LS);
        sb.append("  MemoryRequest: ");
        if (this.memReq_ != null) {
            sb.append(this.memReq_.getClass().getSimpleName()).append(", hash: ").append(this.memReq_.hashCode());
        } else {
            sb.append("null");
        }
        return this.toHex(sb.toString(), offsetBytes, lengthBytes);
    }

    @Override
    public void freeMemory() {
        this.nativeBaseAddress_ = 0L;
        this.capacityBytes_ = 0L;
        this.cumBaseOffset_ = 0L;
        this.memReq_ = null;
    }

    @Deprecated
    public static final void copy(Memory source, long srcOffsetBytes, Memory destination, long dstOffsetBytes, long lengthBytes) {
        source.copy(srcOffsetBytes, destination, dstOffsetBytes, lengthBytes);
    }

    private String toHex(String header, long offsetBytes, int lengthBytes) {
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacityBytes_);
        long unsafeRawAddress = this.getAddress(offsetBytes);
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(UnsafeUtil.LS);
        sb.append("Native Base Address : ").append(this.nativeBaseAddress_).append(UnsafeUtil.LS);
        sb.append("Object Offset       : ").append(this.objectBaseOffset_).append(": ");
        sb.append(this.memArray_ == null ? "null" : this.memArray_.getClass().getSimpleName()).append(UnsafeUtil.LS);
        sb.append("Relative Offset     : ").append(offsetBytes).append(UnsafeUtil.LS);
        sb.append("Total Offset        : ").append(unsafeRawAddress).append(UnsafeUtil.LS);
        sb.append("Native Region       :  0  1  2  3  4  5  6  7");
        long j = offsetBytes;
        StringBuilder sb2 = new StringBuilder();
        for (long i = 0L; i < (long)lengthBytes; ++i) {
            int b = UnsafeUtil.unsafe.getByte(this.memArray_, unsafeRawAddress + i) & 0xFF;
            if (i != 0L && i % 8L == 0L) {
                sb.append(String.format("%n%20s: ", j)).append((CharSequence)sb2);
                j += 8L;
                sb2.setLength(0);
            }
            sb2.append(String.format("%02x ", b));
        }
        sb.append(String.format("%n%20s: ", j)).append((CharSequence)sb2).append(UnsafeUtil.LS);
        return sb.toString();
    }
}

