/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.jayway.jsonpath.internal.filter;

import com.linkedin.coral.calcite.$internal.com.jayway.jsonpath.Predicate;
import com.linkedin.coral.calcite.$internal.com.jayway.jsonpath.internal.filter.Evaluator;
import com.linkedin.coral.calcite.$internal.com.jayway.jsonpath.internal.filter.EvaluatorFactory;
import com.linkedin.coral.calcite.$internal.com.jayway.jsonpath.internal.filter.ExpressionNode;
import com.linkedin.coral.calcite.$internal.com.jayway.jsonpath.internal.filter.RelationalOperator;
import com.linkedin.coral.calcite.$internal.com.jayway.jsonpath.internal.filter.ValueNode;
import com.linkedin.coral.calcite.$internal.org.slf4j.Logger;
import com.linkedin.coral.calcite.$internal.org.slf4j.LoggerFactory;

public class RelationalExpressionNode
extends ExpressionNode {
    private static final Logger logger = LoggerFactory.getLogger(RelationalExpressionNode.class);
    private final ValueNode left;
    private final RelationalOperator relationalOperator;
    private final ValueNode right;

    public RelationalExpressionNode(ValueNode left, RelationalOperator relationalOperator, ValueNode right) {
        this.left = left;
        this.relationalOperator = relationalOperator;
        this.right = right;
        logger.trace("ExpressionNode {}", (Object)this.toString());
    }

    public String toString() {
        if (this.relationalOperator == RelationalOperator.EXISTS) {
            return this.left.toString();
        }
        return this.left.toString() + " " + this.relationalOperator.toString() + " " + this.right.toString();
    }

    @Override
    public boolean apply(Predicate.PredicateContext ctx) {
        Evaluator evaluator;
        ValueNode l = this.left;
        ValueNode r = this.right;
        if (this.left.isPathNode()) {
            l = this.left.asPathNode().evaluate(ctx);
        }
        if (this.right.isPathNode()) {
            r = this.right.asPathNode().evaluate(ctx);
        }
        if ((evaluator = EvaluatorFactory.createEvaluator(this.relationalOperator)) != null) {
            return evaluator.evaluate(l, r, ctx);
        }
        return false;
    }
}

