/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.esri.core.geometry;

import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Envelope1D;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Envelope2D;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.GeometryAccelerators;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.GeometryException;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.MultiPath;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.MultiPathImpl;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Point;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Point2D;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Polygon;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.QuadTree;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.QuadTreeImpl;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.RasterizedGeometry2D;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Segment;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.SegmentBuffer;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.SegmentIteratorImpl;

final class PointInPolygonHelper {
    private Point2D m_inputPoint;
    private int m_windnum;
    private SegmentBuffer[] m_monotoneParts = null;
    private double[] m_xOrds = null;
    private double m_tolerance;
    private double m_toleranceSqr;
    private double m_miny;
    private double m_maxy;
    private boolean m_bAlternate;
    private boolean m_bTestBorder;
    private boolean m_bBreak;
    private boolean m_bPointInAnyOuterRingTest;

    private int result() {
        return this.m_windnum != 0 ? 1 : 0;
    }

    private boolean _testBorder(Segment seg) {
        double t = seg.getClosestCoordinate(this.m_inputPoint, false);
        Point2D pt = seg.getCoord2D(t);
        return Point2D.sqrDistance(pt, this.m_inputPoint) <= this.m_toleranceSqr;
    }

    private void doOne(Segment seg) {
        if (!this.m_bTestBorder && (this.m_bAlternate && this.m_inputPoint.isEqual(seg.getStartXY()) || this.m_inputPoint.isEqual(seg.getEndXY()))) {
            this.m_bBreak = true;
            return;
        }
        if (seg.getStartY() == this.m_inputPoint.y && seg.getStartY() == seg.getEndY()) {
            if (this.m_bAlternate && !this.m_bTestBorder) {
                double minx = Math.min(seg.getStartX(), seg.getEndX());
                double maxx = Math.max(seg.getStartX(), seg.getEndX());
                if (this.m_inputPoint.x > minx && this.m_inputPoint.x < maxx) {
                    this.m_bBreak = true;
                }
            }
            return;
        }
        boolean bToTheRight = false;
        double maxx = Math.max(seg.getStartX(), seg.getEndX());
        if (this.m_inputPoint.x > maxx) {
            bToTheRight = true;
        } else if (this.m_inputPoint.x >= Math.min(seg.getStartX(), seg.getEndX())) {
            int n = seg.intersectionWithAxis2D(true, this.m_inputPoint.y, this.m_xOrds, null);
            boolean bl = bToTheRight = n > 0 && this.m_xOrds[0] <= this.m_inputPoint.x;
        }
        if (bToTheRight) {
            if (this.m_inputPoint.y == seg.getStartXY().y ? this.m_inputPoint.y < seg.getEndXY().y : this.m_inputPoint.y == seg.getEndXY().y && this.m_inputPoint.y < seg.getStartXY().y) {
                return;
            }
            this.m_windnum = this.m_bAlternate ? (this.m_windnum ^= 1) : (this.m_windnum += seg.getStartXY().y > seg.getEndXY().y ? 1 : -1);
        }
    }

    public PointInPolygonHelper(boolean bFillRule_Alternate, Point2D inputPoint, double tolerance) {
        this.m_inputPoint = inputPoint;
        this.m_miny = inputPoint.y - tolerance;
        this.m_maxy = inputPoint.y + tolerance;
        this.m_windnum = 0;
        this.m_bAlternate = bFillRule_Alternate;
        this.m_tolerance = tolerance;
        this.m_toleranceSqr = tolerance * tolerance;
        this.m_bTestBorder = tolerance != 0.0;
        this.m_bBreak = false;
    }

    private boolean processSegment(Segment segment) {
        int nparts;
        Envelope1D yrange = segment.queryInterval(0, 1);
        if (yrange.vmin > this.m_maxy || yrange.vmax < this.m_miny) {
            return false;
        }
        if (this.m_bTestBorder && this._testBorder(segment)) {
            return true;
        }
        if (yrange.vmin > this.m_inputPoint.y || yrange.vmax < this.m_inputPoint.y) {
            return false;
        }
        if (this.m_monotoneParts == null) {
            this.m_monotoneParts = new SegmentBuffer[5];
        }
        if (this.m_xOrds == null) {
            this.m_xOrds = new double[3];
        }
        if ((nparts = segment.getYMonotonicParts(this.m_monotoneParts)) > 0) {
            for (int i = 0; i < nparts; ++i) {
                Segment part = this.m_monotoneParts[i].get();
                this.doOne(part);
                if (!this.m_bBreak) continue;
                return true;
            }
        } else {
            this.doOne(segment);
            if (this.m_bBreak) {
                return true;
            }
        }
        return false;
    }

    private static int _isPointInPolygonInternal(Polygon inputPolygon, Point2D inputPoint, double tolerance) {
        boolean bAltenate = inputPolygon.getFillRule() == 0;
        PointInPolygonHelper helper = new PointInPolygonHelper(bAltenate, inputPoint, tolerance);
        MultiPathImpl mpImpl = (MultiPathImpl)inputPolygon._getImpl();
        SegmentIteratorImpl iter = mpImpl.querySegmentIterator();
        while (iter.nextPath()) {
            while (iter.hasNextSegment()) {
                Segment segment = iter.nextSegment();
                if (!helper.processSegment(segment)) continue;
                return -1;
            }
        }
        return helper.result();
    }

    private static int _isPointInPolygonInternalWithQuadTree(Polygon inputPolygon, QuadTreeImpl quadTree, Point2D inputPoint, double tolerance) {
        Envelope2D envPoly = new Envelope2D();
        inputPolygon.queryLooseEnvelope(envPoly);
        envPoly.inflate(tolerance, tolerance);
        boolean bAltenate = inputPolygon.getFillRule() == 0;
        PointInPolygonHelper helper = new PointInPolygonHelper(bAltenate, inputPoint, tolerance);
        MultiPathImpl mpImpl = (MultiPathImpl)inputPolygon._getImpl();
        SegmentIteratorImpl iter = mpImpl.querySegmentIterator();
        Envelope2D queryEnv = new Envelope2D();
        queryEnv.setCoords(envPoly);
        queryEnv.xmax = inputPoint.x + tolerance;
        queryEnv.ymin = inputPoint.y - tolerance;
        queryEnv.ymax = inputPoint.y + tolerance;
        QuadTreeImpl.QuadTreeIteratorImpl qiter = quadTree.getIterator(queryEnv, tolerance);
        int qhandle = qiter.next();
        while (qhandle != -1) {
            Segment segment;
            iter.resetToVertex(quadTree.getElement(qhandle));
            if (iter.hasNextSegment() && helper.processSegment(segment = iter.nextSegment())) {
                return -1;
            }
            qhandle = qiter.next();
        }
        return helper.result();
    }

    public static int isPointInPolygon(Polygon inputPolygon, Point2D inputPoint, double tolerance) {
        if (inputPolygon.isEmpty()) {
            return 0;
        }
        Envelope2D env = new Envelope2D();
        inputPolygon.queryLooseEnvelope(env);
        env.inflate(tolerance, tolerance);
        if (!env.contains(inputPoint)) {
            return 0;
        }
        MultiPathImpl mpImpl = (MultiPathImpl)inputPolygon._getImpl();
        GeometryAccelerators accel = mpImpl._getAccelerators();
        if (accel != null) {
            QuadTreeImpl qtree;
            RasterizedGeometry2D rgeom = accel.getRasterizedGeometry();
            if (rgeom != null) {
                RasterizedGeometry2D.HitType hit = rgeom.queryPointInGeometry(inputPoint.x, inputPoint.y);
                if (hit == RasterizedGeometry2D.HitType.Inside) {
                    return 1;
                }
                if (hit == RasterizedGeometry2D.HitType.Outside) {
                    return 0;
                }
            }
            if ((qtree = accel.getQuadTree()) != null) {
                return PointInPolygonHelper._isPointInPolygonInternalWithQuadTree(inputPolygon, qtree, inputPoint, tolerance);
            }
        }
        return PointInPolygonHelper._isPointInPolygonInternal(inputPolygon, inputPoint, tolerance);
    }

    static int isPointInPolygon(Polygon inputPolygon, double inputPointXVal, double inputPointYVal, double tolerance) {
        RasterizedGeometry2D rgeom;
        if (inputPolygon.isEmpty()) {
            return 0;
        }
        Envelope2D env = new Envelope2D();
        inputPolygon.queryLooseEnvelope(env);
        env.inflate(tolerance, tolerance);
        if (!env.contains(inputPointXVal, inputPointYVal)) {
            return 0;
        }
        MultiPathImpl mpImpl = (MultiPathImpl)inputPolygon._getImpl();
        GeometryAccelerators accel = mpImpl._getAccelerators();
        if (accel != null && (rgeom = accel.getRasterizedGeometry()) != null) {
            RasterizedGeometry2D.HitType hit = rgeom.queryPointInGeometry(inputPointXVal, inputPointYVal);
            if (hit == RasterizedGeometry2D.HitType.Inside) {
                return 1;
            }
            if (hit == RasterizedGeometry2D.HitType.Outside) {
                return 0;
            }
        }
        return PointInPolygonHelper._isPointInPolygonInternal(inputPolygon, new Point2D(inputPointXVal, inputPointYVal), tolerance);
    }

    public static int isPointInRing(MultiPathImpl inputPolygonImpl, int iRing, Point2D inputPoint, double tolerance, QuadTree quadTree) {
        Envelope2D env = new Envelope2D();
        inputPolygonImpl.queryLooseEnvelope2D(env);
        env.inflate(tolerance, tolerance);
        if (!env.contains(inputPoint)) {
            return 0;
        }
        boolean bAltenate = true;
        PointInPolygonHelper helper = new PointInPolygonHelper(bAltenate, inputPoint, tolerance);
        if (quadTree != null) {
            Envelope2D queryEnv = new Envelope2D();
            queryEnv.setCoords(env);
            queryEnv.xmax = inputPoint.x + tolerance;
            queryEnv.ymin = inputPoint.y - tolerance;
            queryEnv.ymax = inputPoint.y + tolerance;
            SegmentIteratorImpl iter = inputPolygonImpl.querySegmentIterator();
            QuadTree.QuadTreeIterator qiter = quadTree.getIterator(queryEnv, tolerance);
            int qhandle = qiter.next();
            while (qhandle != -1) {
                Segment segment;
                iter.resetToVertex(quadTree.getElement(qhandle), iRing);
                if (iter.hasNextSegment() && iter.getPathIndex() == iRing && helper.processSegment(segment = iter.nextSegment())) {
                    return -1;
                }
                qhandle = qiter.next();
            }
            return helper.result();
        }
        SegmentIteratorImpl iter = inputPolygonImpl.querySegmentIterator();
        iter.resetToPath(iRing);
        if (iter.nextPath()) {
            while (iter.hasNextSegment()) {
                Segment segment = iter.nextSegment();
                if (!helper.processSegment(segment)) continue;
                return -1;
            }
        }
        return helper.result();
    }

    public static int isPointInPolygon(Polygon inputPolygon, Point inputPoint, double tolerance) {
        if (inputPoint.isEmpty()) {
            return 0;
        }
        return PointInPolygonHelper.isPointInPolygon(inputPolygon, inputPoint.getXY(), tolerance);
    }

    public static int isPointInAnyOuterRing(Polygon inputPolygon, Point2D inputPoint, double tolerance) {
        Envelope2D env = new Envelope2D();
        inputPolygon.queryLooseEnvelope(env);
        env.inflate(tolerance, tolerance);
        if (!env.contains(inputPoint)) {
            return 0;
        }
        boolean bAltenate = false;
        PointInPolygonHelper helper = new PointInPolygonHelper(bAltenate, inputPoint, tolerance);
        MultiPathImpl mpImpl = (MultiPathImpl)inputPolygon._getImpl();
        SegmentIteratorImpl iter = mpImpl.querySegmentIterator();
        while (iter.nextPath()) {
            double ringArea = mpImpl.calculateRingArea2D(iter.getPathIndex());
            boolean bIsHole = ringArea < 0.0;
            if (bIsHole) continue;
            helper.m_windnum = 0;
            while (iter.hasNextSegment()) {
                Segment segment = iter.nextSegment();
                if (!helper.processSegment(segment)) continue;
                return -1;
            }
            if (helper.m_windnum == 0) continue;
            return 1;
        }
        return helper.result();
    }

    static boolean _isRingInRing2D(MultiPath polygon, int iRing1, int iRing2, double tolerance, QuadTree quadTree) {
        MultiPathImpl polygonImpl = (MultiPathImpl)polygon._getImpl();
        SegmentIteratorImpl segIter = polygonImpl.querySegmentIterator();
        segIter.resetToPath(iRing1);
        if (!segIter.nextPath() || !segIter.hasNextSegment()) {
            throw new GeometryException("corrupted geometry");
        }
        int res = 2;
        while (res == 2 && segIter.hasNextSegment()) {
            Segment segment = segIter.nextSegment();
            Point2D point = segment.getCoord2D(0.5);
            res = PointInPolygonHelper.isPointInRing(polygonImpl, iRing2, point, tolerance, quadTree);
        }
        if (res == 2) {
            throw GeometryException.GeometryInternalError();
        }
        return res == 1;
    }

    static boolean quadTreeWillHelp(Polygon polygon, int c_queries) {
        double c_brute_force;
        int n = polygon.getPointCount();
        if (n < 16) {
            return false;
        }
        double c_build_quad_tree = 2.0;
        double c_query_quad_tree = 1.0;
        double c_point_in_polygon_brute_force = 1.0;
        double c_quad_tree = c_build_quad_tree * (double)n + c_query_quad_tree * (Math.log(n) / Math.log(2.0)) * (double)c_queries;
        return c_quad_tree < (c_brute_force = c_point_in_polygon_brute_force * (double)n * (double)c_queries);
    }
}

