/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.esri.core.geometry;

import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.ConvexHull;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Envelope;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Envelope2D;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Geometry;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.GeometryCursor;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.GeometryException;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.MultiPath;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.MultiPoint;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.MultiVertexGeometry;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Point;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Polygon;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Polyline;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.ProgressTracker;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Segment;

class OperatorConvexHullCursor
extends GeometryCursor {
    private ProgressTracker m_progress_tracker;
    private boolean m_b_merge;
    private boolean m_b_done;
    private GeometryCursor m_inputGeometryCursor;
    private int m_index = -1;
    ConvexHull m_hull = new ConvexHull();

    OperatorConvexHullCursor(boolean b_merge, GeometryCursor geoms, ProgressTracker progress_tracker) {
        if (geoms == null) {
            throw new IllegalArgumentException();
        }
        this.m_b_merge = b_merge;
        this.m_b_done = false;
        this.m_inputGeometryCursor = geoms;
        this.m_progress_tracker = progress_tracker;
    }

    @Override
    public Geometry next() {
        if (this.m_b_merge) {
            if (!this.m_b_done) {
                Geometry result = this.calculateConvexHullMerging_(this.m_inputGeometryCursor, this.m_progress_tracker);
                this.m_b_done = true;
                return result;
            }
            return null;
        }
        if (!this.m_b_done) {
            Geometry geometry = this.m_inputGeometryCursor.next();
            if (geometry != null) {
                this.m_index = this.m_inputGeometryCursor.getGeometryID();
                return OperatorConvexHullCursor.calculateConvexHull_(geometry, this.m_progress_tracker);
            }
            this.m_b_done = true;
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    private Geometry calculateConvexHullMerging_(GeometryCursor geoms, ProgressTracker progress_tracker) {
        Geometry geometry;
        while ((geometry = geoms.next()) != null) {
            this.m_hull.addGeometry(geometry);
        }
        return this.m_hull.getBoundingGeometry();
    }

    @Override
    public boolean tock() {
        if (this.m_b_done) {
            return true;
        }
        if (!this.m_b_merge) {
            throw new GeometryException("Invalid call for non merging convex hull.");
        }
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_hull.addGeometry(geometry);
            return true;
        }
        throw new GeometryException("Expects a non-null geometry.");
    }

    static Geometry calculateConvexHull_(Geometry geom, ProgressTracker progress_tracker) {
        if (geom.isEmpty()) {
            return geom.createInstance();
        }
        Geometry.Type type = geom.getType();
        if (Geometry.isSegment(type.value())) {
            Segment segment = (Segment)geom;
            if (segment.getStartXY().equals(segment.getEndXY())) {
                Point point = new Point();
                segment.queryStart(point);
                return point;
            }
            Point pt = new Point();
            Polyline polyline = new Polyline(geom.getDescription());
            segment.queryStart(pt);
            polyline.startPath(pt);
            segment.queryEnd(pt);
            polyline.lineTo(pt);
            return polyline;
        }
        if (type == Geometry.Type.Envelope) {
            Envelope envelope = (Envelope)geom;
            Envelope2D env = new Envelope2D();
            envelope.queryEnvelope2D(env);
            if (env.xmin == env.xmax && env.ymin == env.ymax) {
                Point point = new Point();
                envelope.queryCornerByVal(0, point);
                return point;
            }
            if (env.xmin == env.xmax || env.ymin == env.ymax) {
                Point pt = new Point();
                Polyline polyline = new Polyline(geom.getDescription());
                envelope.queryCornerByVal(0, pt);
                polyline.startPath(pt);
                envelope.queryCornerByVal(1, pt);
                polyline.lineTo(pt);
                return polyline;
            }
            Polygon polygon = new Polygon(geom.getDescription());
            polygon.addEnvelope(envelope, false);
            return polygon;
        }
        if (OperatorConvexHullCursor.isConvex_(geom, progress_tracker)) {
            if (type == Geometry.Type.MultiPoint) {
                MultiPoint multi_point = (MultiPoint)geom;
                Point point = new Point();
                multi_point.getPointByVal(0, point);
                return point;
            }
            return geom;
        }
        assert (Geometry.isMultiVertex(type.value()));
        Geometry convex_hull = ConvexHull.construct((MultiVertexGeometry)geom);
        return convex_hull;
    }

    static boolean isConvex_(Geometry geom, ProgressTracker progress_tracker) {
        if (geom.isEmpty()) {
            return true;
        }
        Geometry.Type type = geom.getType();
        if (type == Geometry.Type.Point) {
            return true;
        }
        if (type == Geometry.Type.Envelope) {
            Envelope envelope = (Envelope)geom;
            return envelope.getXMin() != envelope.getXMax() && envelope.getYMin() != envelope.getYMax();
        }
        if (MultiPath.isSegment(type.value())) {
            Segment segment = (Segment)geom;
            return !segment.getStartXY().equals(segment.getEndXY());
        }
        if (type == Geometry.Type.MultiPoint) {
            MultiPoint multi_point = (MultiPoint)geom;
            return multi_point.getPointCount() == 1;
        }
        if (type == Geometry.Type.Polyline) {
            Polyline polyline = (Polyline)geom;
            return polyline.getPathCount() == 1 && polyline.getPointCount() == 2 && !polyline.getXY(0).equals(polyline.getXY(1));
        }
        Polygon polygon = (Polygon)geom;
        if (polygon.getPathCount() != 1 || polygon.getPointCount() < 3) {
            return false;
        }
        return ConvexHull.isPathConvex(polygon, 0, progress_tracker);
    }
}

