/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.io;

import com.linkedin.coral.;
import com.linkedin.coral.$internal.org.apache.hadoop.io.ElasticByteBufferPool;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;

@.InterfaceAudience.Private
@.InterfaceStability.Unstable
public final class WeakReferencedElasticByteBufferPool
extends ElasticByteBufferPool {
    private final TreeMap<ElasticByteBufferPool.Key, WeakReference<ByteBuffer>> directBuffers = new TreeMap();
    private final TreeMap<ElasticByteBufferPool.Key, WeakReference<ByteBuffer>> heapBuffers = new TreeMap();

    private TreeMap<ElasticByteBufferPool.Key, WeakReference<ByteBuffer>> getBufferTree(boolean isDirect) {
        return isDirect ? this.directBuffers : this.heapBuffers;
    }

    @Override
    public synchronized ByteBuffer getBuffer(boolean direct, int length) {
        TreeMap<ElasticByteBufferPool.Key, WeakReference<ByteBuffer>> buffersTree = this.getBufferTree(direct);
        buffersTree.entrySet().removeIf(next -> ((WeakReference)next.getValue()).get() == null);
        Map.Entry<ElasticByteBufferPool.Key, WeakReference<ByteBuffer>> entry = buffersTree.ceilingEntry(new ElasticByteBufferPool.Key(length, 0L));
        if (entry == null) {
            return direct ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
        }
        WeakReference<ByteBuffer> bufferInPool = entry.getValue();
        buffersTree.remove(entry.getKey());
        ByteBuffer buffer = (ByteBuffer)bufferInPool.get();
        if (buffer != null) {
            return buffer;
        }
        return direct ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
    }

    @Override
    public synchronized void putBuffer(ByteBuffer buffer) {
        ElasticByteBufferPool.Key keyToInsert;
        buffer.clear();
        TreeMap<ElasticByteBufferPool.Key, WeakReference<ByteBuffer>> buffersTree = this.getBufferTree(buffer.isDirect());
        while (buffersTree.containsKey(keyToInsert = new ElasticByteBufferPool.Key(buffer.capacity(), System.nanoTime()))) {
        }
        buffersTree.put(keyToInsert, new WeakReference<ByteBuffer>(buffer));
    }

    @Override
    public synchronized void release() {
        this.heapBuffers.clear();
        this.directBuffers.clear();
    }

    @.VisibleForTesting
    public synchronized int getCurrentBuffersCount(boolean isDirect) {
        return isDirect ? this.directBuffers.size() : this.heapBuffers.size();
    }
}

