/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.fast;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.DateWritableV2;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import java.io.IOException;
import java.util.Arrays;

public abstract class DeserializeRead {
    protected final TypeInfo[] typeInfos;
    protected DataTypePhysicalVariation[] dataTypePhysicalVariations;
    protected final boolean useExternalBuffer;
    protected final ObjectInspector.Category[] categories;
    protected final PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories;
    public boolean currentBoolean;
    public byte currentByte;
    public short currentShort;
    public int currentInt;
    public long currentLong;
    public float currentFloat;
    public double currentDouble;
    public boolean currentExternalBufferNeeded;
    public int currentExternalBufferNeededLen;
    public byte[] currentBytes;
    public int currentBytesStart;
    public int currentBytesLength;
    public DateWritableV2 currentDateWritable;
    public TimestampWritableV2 currentTimestampWritable;
    public HiveIntervalYearMonthWritable currentHiveIntervalYearMonthWritable;
    public HiveIntervalDayTimeWritable currentHiveIntervalDayTimeWritable;
    public HiveDecimalWritable currentHiveDecimalWritable;
    public long currentDecimal64;

    private void allocateCurrentWritable(TypeInfo typeInfo) {
        block0 : switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
                    case DATE: {
                        if (this.currentDateWritable != null) break block0;
                        this.currentDateWritable = new DateWritableV2();
                        break;
                    }
                    case TIMESTAMP: {
                        if (this.currentTimestampWritable != null) break block0;
                        this.currentTimestampWritable = new TimestampWritableV2();
                        break;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        if (this.currentHiveIntervalYearMonthWritable != null) break block0;
                        this.currentHiveIntervalYearMonthWritable = new HiveIntervalYearMonthWritable();
                        break;
                    }
                    case INTERVAL_DAY_TIME: {
                        if (this.currentHiveIntervalDayTimeWritable != null) break block0;
                        this.currentHiveIntervalDayTimeWritable = new HiveIntervalDayTimeWritable();
                        break;
                    }
                    case DECIMAL: {
                        if (this.currentHiveDecimalWritable != null) break block0;
                        this.currentHiveDecimalWritable = new HiveDecimalWritable();
                        break;
                    }
                }
                break;
            }
            case LIST: {
                this.allocateCurrentWritable(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                break;
            }
            case MAP: {
                this.allocateCurrentWritable(((MapTypeInfo)typeInfo).getMapKeyTypeInfo());
                this.allocateCurrentWritable(((MapTypeInfo)typeInfo).getMapValueTypeInfo());
                break;
            }
            case STRUCT: {
                for (TypeInfo fieldTypeInfo : ((StructTypeInfo)typeInfo).getAllStructFieldTypeInfos()) {
                    this.allocateCurrentWritable(fieldTypeInfo);
                }
                break;
            }
            case UNION: {
                for (TypeInfo fieldTypeInfo : ((UnionTypeInfo)typeInfo).getAllUnionObjectTypeInfos()) {
                    this.allocateCurrentWritable(fieldTypeInfo);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected category " + (Object)((Object)typeInfo.getCategory()));
            }
        }
    }

    public DeserializeRead(TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, boolean useExternalBuffer) {
        this.typeInfos = typeInfos;
        int count = typeInfos.length;
        if (dataTypePhysicalVariations != null) {
            this.dataTypePhysicalVariations = dataTypePhysicalVariations;
        } else {
            this.dataTypePhysicalVariations = new DataTypePhysicalVariation[count];
            Arrays.fill((Object[])this.dataTypePhysicalVariations, (Object)DataTypePhysicalVariation.NONE);
        }
        this.categories = new ObjectInspector.Category[count];
        this.primitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[count];
        for (int i = 0; i < count; ++i) {
            ObjectInspector.Category category;
            TypeInfo typeInfo = typeInfos[i];
            this.categories[i] = category = typeInfo.getCategory();
            if (category == ObjectInspector.Category.PRIMITIVE) {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                this.primitiveCategories[i] = primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
            }
            this.allocateCurrentWritable(typeInfo);
        }
        this.useExternalBuffer = useExternalBuffer;
    }

    public DeserializeRead(TypeInfo[] typeInfos, boolean useExternalBuffer) {
        this(typeInfos, null, useExternalBuffer);
    }

    protected DeserializeRead() {
        this.typeInfos = null;
        this.useExternalBuffer = false;
        this.categories = null;
        this.primitiveCategories = null;
    }

    public TypeInfo[] typeInfos() {
        return this.typeInfos;
    }

    public DataTypePhysicalVariation[] getDataTypePhysicalVariations() {
        return this.dataTypePhysicalVariations;
    }

    public abstract void set(byte[] var1, int var2, int var3);

    public abstract boolean readNextField() throws IOException;

    public abstract void skipNextField() throws IOException;

    public boolean isReadFieldSupported() {
        return false;
    }

    public boolean readField(int fieldIndex) throws IOException {
        throw new RuntimeException("Not supported");
    }

    public abstract boolean isNextComplexMultiValue() throws IOException;

    public abstract boolean readComplexField() throws IOException;

    public abstract void finishComplexVariableFieldsType();

    public abstract boolean isEndOfInputReached();

    public abstract String getDetailedReadPositionString();

    public void copyToExternalBuffer(byte[] externalBuffer, int externalBufferStart) throws IOException {
        throw new RuntimeException("Not implemented");
    }
}

