/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.columnar;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.columnar.ColumnarStructBase;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Text;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnarStruct
extends ColumnarStructBase {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnarStruct.class);
    Text nullSequence;
    int lengthNullSequence;

    public ColumnarStruct(ObjectInspector oi, List<Integer> notSkippedColumnIDs, Text nullSequence) {
        super(oi, notSkippedColumnIDs);
        if (nullSequence != null) {
            this.nullSequence = nullSequence;
            this.lengthNullSequence = nullSequence.getLength();
        }
    }

    @Override
    protected int getLength(ObjectInspector objectInspector, ByteArrayRef cachedByteArrayRef, int start, int fieldLen) {
        byte[] data;
        if (fieldLen == this.lengthNullSequence && LazyUtils.compare(data = cachedByteArrayRef.getData(), start, fieldLen, this.nullSequence.getBytes(), 0, this.lengthNullSequence) == 0) {
            return -1;
        }
        return fieldLen;
    }

    @Override
    protected LazyObjectBase createLazyObjectBase(ObjectInspector objectInspector) {
        return LazyFactory.createLazyObject(objectInspector);
    }
}

