/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.ByteStream;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.SerDeException;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.SerDeUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Writable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelimitedJSONSerDe
extends LazySimpleSerDe {
    public static final Logger LOG = LoggerFactory.getLogger((String)DelimitedJSONSerDe.class.getName());

    @Override
    public Object doDeserialize(Writable field) throws SerDeException {
        LOG.error("DelimitedJSONSerDe cannot deserialize.");
        throw new SerDeException("DelimitedJSONSerDe cannot deserialize.");
    }

    @Override
    protected void serializeField(ByteStream.Output out, Object obj, ObjectInspector objInspector, LazySerDeParameters serdeParams) throws SerDeException {
        if (!objInspector.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) || objInspector.getTypeName().equalsIgnoreCase("binary")) {
            try {
                DelimitedJSONSerDe.serialize(out, SerDeUtils.getJSONString(obj, objInspector, serdeParams.getNullSequence().toString()), PrimitiveObjectInspectorFactory.javaStringObjectInspector, serdeParams.getSeparators(), 1, serdeParams.getNullSequence(), serdeParams.isEscaped(), serdeParams.getEscapeChar(), serdeParams.getNeedsEscape());
            }
            catch (IOException e) {
                throw new SerDeException(e);
            }
        } else {
            super.serializeField(out, obj, objInspector, serdeParams);
        }
    }
}

