/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore;

import com.linkedin.coral.;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import com.linkedin.coral.hive.metastore.api.GetOpenTxnsResponse;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializationsRebuildLockCleanerTask
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializationsRebuildLockCleanerTask.class);
    private Configuration conf;
    private .TxnStore txnHandler;

    @Override
    public long runFrequency(TimeUnit unit) {
        return .MetastoreConf.getTimeVar((Configuration)this.conf, (.MetastoreConf.ConfVars).MetastoreConf.ConfVars.TXN_TIMEOUT, (TimeUnit)unit) / 2L;
    }

    @Override
    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.txnHandler = .TxnUtils.getTxnStore((Configuration)this.conf);
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleaning up materialization rebuild locks");
        }
        .TxnStore.MutexAPI.LockHandle handle = null;
        try {
            handle = this.txnHandler.getMutexAPI().acquireLock(.TxnStore.MUTEX_KEY.MaterializationRebuild.name());
            .ValidTxnList validTxnList = .TxnUtils.createValidReadTxnList((GetOpenTxnsResponse)this.txnHandler.getOpenTxns(), (long)0L);
            long removedCnt = this.txnHandler.cleanupMaterializationRebuildLocks(validTxnList, .MetastoreConf.getTimeVar((Configuration)this.conf, (.MetastoreConf.ConfVars).MetastoreConf.ConfVars.TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
            if (removedCnt > 0L && LOG.isDebugEnabled()) {
                LOG.debug("Number of materialization locks deleted: " + removedCnt);
            }
        }
        catch (Throwable t) {
            LOG.error("Serious error in {}", new Object[]{Thread.currentThread().getName(), ": {}" + t.getMessage(), t});
        }
        finally {
            if (handle != null) {
                handle.releaseLocks();
            }
        }
    }
}

