/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.base.Preconditions;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.DereferenceExpression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Expression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import com.linkedin.coral.$internal.io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GroupingOperation
extends Expression {
    private final List<Expression> groupingColumns;

    public GroupingOperation(Optional<NodeLocation> location, List<QualifiedName> groupingColumns) {
        super(location);
        Objects.requireNonNull(groupingColumns);
        Preconditions.checkArgument(!groupingColumns.isEmpty(), "grouping operation columns cannot be empty");
        this.groupingColumns = groupingColumns.stream().map(DereferenceExpression::from).collect(ImmutableList.toImmutableList());
    }

    public List<Expression> getGroupingColumns() {
        return this.groupingColumns;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupingOperation(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.groupingColumns;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingOperation other = (GroupingOperation)o;
        return Objects.equals(this.groupingColumns, other.groupingColumns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.groupingColumns);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return GroupingOperation.sameClass(this, other);
    }
}

