/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.tablestate;

import java.util.ArrayList;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableStateUtils.class);

    private TableStateUtils() {
    }

    public static boolean isAllSegmentsLoaded(HelixManager helixManager, String tableNameWithType) {
        PropertyKey.Builder keyBuilder;
        HelixDataAccessor dataAccessor = helixManager.getHelixDataAccessor();
        IdealState idealState = (IdealState)dataAccessor.getProperty((keyBuilder = dataAccessor.keyBuilder()).idealStates(tableNameWithType));
        if (idealState == null) {
            LOGGER.warn("Failed to find ideal state for table: {}", (Object)tableNameWithType);
            return false;
        }
        String instanceName = helixManager.getInstanceName();
        ArrayList<String> onlineSegments = new ArrayList<String>();
        Map idealStatesMap = idealState.getRecord().getMapFields();
        for (Map.Entry entry : idealStatesMap.entrySet()) {
            String segmentName = (String)entry.getKey();
            Map instanceStateMap = (Map)entry.getValue();
            String expectedState = (String)instanceStateMap.get(instanceName);
            if (!"ONLINE".equals(expectedState)) continue;
            onlineSegments.add(segmentName);
        }
        if (onlineSegments.size() > 0) {
            LiveInstance liveInstance = (LiveInstance)dataAccessor.getProperty(keyBuilder.liveInstance(instanceName));
            if (liveInstance == null) {
                LOGGER.warn("Failed to find live instance for instance: {}", (Object)instanceName);
                return false;
            }
            String sessionId = liveInstance.getEphemeralOwner();
            CurrentState currentState = (CurrentState)dataAccessor.getProperty(keyBuilder.currentState(instanceName, sessionId, tableNameWithType));
            if (currentState == null) {
                LOGGER.warn("Failed to find current state for instance: {}, sessionId: {}, table: {}", new Object[]{instanceName, sessionId, tableNameWithType});
                return false;
            }
            Map currentStateMap = currentState.getPartitionStateMap();
            for (String segmentName : onlineSegments) {
                String actualState = (String)currentStateMap.get(segmentName);
                if ("ONLINE".equals(actualState)) continue;
                if ("ERROR".equals(actualState)) {
                    LOGGER.error("Find ERROR segment: {}, table: {}, expected: {}", new Object[]{segmentName, tableNameWithType, "ONLINE"});
                } else {
                    LOGGER.info("Find unloaded segment: {}, table: {}, expected: {}, actual: {}", new Object[]{segmentName, tableNameWithType, "ONLINE", actualState});
                }
                return false;
            }
        }
        LOGGER.info("All segments loaded for table: {}", (Object)tableNameWithType);
        return true;
    }

    public static void waitForAllSegmentsLoaded(HelixManager helixManager, String tableNameWithType) {
        try {
            while (!TableStateUtils.isAllSegmentsLoaded(helixManager, tableNameWithType)) {
                LOGGER.info("Sleeping 1 second waiting for all segments loaded for table: {}", (Object)tableNameWithType);
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while waiting for all segments loaded for table: " + tableNameWithType, e);
        }
    }
}

