/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.pinot.segment.local.utils.nativefst.FST;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Automaton;
import org.apache.pinot.segment.local.utils.nativefst.automaton.CharacterRunAutomaton;
import org.apache.pinot.segment.local.utils.nativefst.automaton.RegExp;
import org.apache.pinot.segment.local.utils.nativefst.automaton.State;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Transition;
import org.roaringbitmap.IntConsumer;

public class RegexpMatcher {
    private final String _regexQuery;
    private final FST _fst;
    private final Automaton _automaton;
    private final IntConsumer _dest;

    public RegexpMatcher(String regexQuery, FST fst, IntConsumer dest) {
        this._regexQuery = regexQuery;
        this._fst = fst;
        this._dest = dest;
        this._automaton = new RegExp(this._regexQuery).toAutomaton();
    }

    public static void regexMatch(String regexQuery, FST fst, IntConsumer dest) {
        RegexpMatcher matcher = new RegexpMatcher(regexQuery, fst, dest);
        matcher.regexMatchOnFST();
    }

    public boolean match(String input) {
        CharacterRunAutomaton characterRunAutomaton = new CharacterRunAutomaton(this._automaton);
        return characterRunAutomaton.run(input);
    }

    public void regexMatchOnFST() {
        ArrayList<Path> queue = new ArrayList<Path>();
        if (this._automaton.getNumberOfStates() == 0) {
            return;
        }
        queue.add(new Path(this._automaton.getInitialState(), this._fst.getRootNode(), 0, new ArrayList<Character>()));
        Set<State> acceptStates = this._automaton.getAcceptStates();
        while (queue.size() != 0) {
            Path path = (Path)queue.remove(queue.size() - 1);
            if (acceptStates.contains(path._state) && this._fst.isArcFinal(path._fstArc)) {
                this._dest.accept(this._fst.getOutputSymbol(path._fstArc));
            }
            Set<Transition> stateTransitions = path._state.getTransitionSet();
            for (Transition t : stateTransitions) {
                int arc;
                char min = t._min;
                char max = t._max;
                if (min == max) {
                    int arc2 = this._fst.getArc(path._node, (byte)t._min);
                    if (arc2 == 0) continue;
                    queue.add(new Path(t._to, this._fst.getEndNode(arc2), arc2, path._pathState));
                    continue;
                }
                if (path._fstArc > 0 && this._fst.isArcTerminal(path._fstArc)) continue;
                if (path._fstArc == 0) {
                    arc = this._fst.getFirstArc(path._node);
                } else {
                    int node = this._fst.getEndNode(path._fstArc);
                    arc = this._fst.getFirstArc(node);
                }
                while (arc != 0) {
                    byte label = this._fst.getArcLabel(arc);
                    if (label >= min && label <= max) {
                        queue.add(new Path(t._to, this._fst.getEndNode(arc), arc, path._pathState));
                    }
                    arc = this._fst.isArcLast(arc) ? 0 : this._fst.getNextArc(arc);
                }
            }
        }
    }

    public final class Path {
        public final State _state;
        public final int _node;
        public final int _fstArc;
        public List<Character> _pathState;

        public Path(State state, int node, int fstArc, List<Character> pathState) {
            this._state = state;
            this._node = node;
            this._fstArc = fstArc;
            this._pathState = pathState;
            this._pathState.add(Character.valueOf((char)RegexpMatcher.this._fst.getArcLabel(fstArc)));
        }
    }
}

