/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.mutablefst;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableArc;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.utils.MutableFSTUtils;

public class MutableState {
    protected char _label;
    protected boolean _isTerminal;
    protected boolean _isStartState;
    private final ArrayList<MutableArc> _arcs;
    private final Set<MutableState> _incomingStates = Sets.newIdentityHashSet();

    public MutableState() {
        this._arcs = Lists.newArrayList();
    }

    public MutableState(boolean isStartState) {
        this._isStartState = isStartState;
        this._arcs = Lists.newArrayList();
    }

    public boolean isTerminal() {
        return this._isTerminal;
    }

    public boolean isStartState() {
        return this._isStartState;
    }

    public char getLabel() {
        return this._label;
    }

    public void setLabel(char label) {
        this._label = label;
    }

    public void setIsTerminal(boolean isTerminal) {
        this._isTerminal = isTerminal;
    }

    public int getArcCount() {
        return this._arcs.size();
    }

    public MutableArc getArc(int index) {
        return this._arcs.get(index);
    }

    public List<MutableArc> getArcs() {
        return this._arcs;
    }

    public String toString() {
        return "(" + this._label + ")";
    }

    void addArc(MutableArc arc) {
        this._arcs.add(arc);
    }

    void addIncomingState(MutableState inState) {
        if (inState == this) {
            return;
        }
        this._incomingStates.add(inState);
    }

    void removeIncomingState(MutableState inState) {
        this._incomingStates.remove(inState);
    }

    public Iterable<MutableState> getIncomingStates() {
        return this._incomingStates;
    }

    public boolean equals(Object o) {
        return MutableFSTUtils.stateEquals(this, o);
    }

    public int hashCode() {
        int result = this._label;
        long temp = 0L;
        result = 31 * result * (int)(temp ^ temp >>> 32);
        result = 31 * result + (this._arcs != null ? this._arcs.hashCode() : 0);
        return result;
    }
}

