/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.builder;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.BitSet;
import org.apache.pinot.segment.local.utils.nativefst.FST;

public final class FSTInfo {
    public final int _nodeCount;
    public final int _arcsCount;
    public final int _arcsCountTotal;
    public final int _finalStatesCount;

    public FSTInfo(FST fst) {
        NodeVisitor w = new NodeVisitor(fst);
        int root = fst.getRootNode();
        if (root > 0) {
            w.visitNode(root);
        }
        this._nodeCount = 1 + w._nodes;
        this._arcsCount = 1 + w._arcs;
        this._arcsCountTotal = 1 + w._totalArcs;
        FinalStateVisitor fsv = new FinalStateVisitor(fst);
        this._finalStatesCount = fsv.visitNode(fst.getRootNode());
    }

    public String toString() {
        return "Nodes: " + this._nodeCount + ", arcs visited: " + this._arcsCount + ", arcs total: " + this._arcsCountTotal + ", final states: " + this._finalStatesCount;
    }

    private static class FinalStateVisitor {
        final Int2IntOpenHashMap _visitedNodes = new Int2IntOpenHashMap();
        private final FST _fst;

        FinalStateVisitor(FST fst) {
            this._fst = fst;
        }

        public int visitNode(int node) {
            int value = this._visitedNodes.getOrDefault(node, -1);
            if (value >= 0) {
                return value;
            }
            int fromHere = 0;
            int arc = this._fst.getFirstArc(node);
            while (arc != 0) {
                if (this._fst.isArcFinal(arc)) {
                    ++fromHere;
                }
                if (!this._fst.isArcTerminal(arc)) {
                    fromHere += this.visitNode(this._fst.getEndNode(arc));
                }
                arc = this._fst.getNextArc(arc);
            }
            this._visitedNodes.put(node, fromHere);
            return fromHere;
        }
    }

    private static class NodeVisitor {
        final BitSet _visitedArcs = new BitSet();
        final BitSet _visitedNodes = new BitSet();
        private final FST _fst;
        int _nodes;
        int _arcs;
        int _totalArcs;

        NodeVisitor(FST fst) {
            this._fst = fst;
        }

        public void visitNode(int node) {
            if (this._visitedNodes.get(node)) {
                return;
            }
            this._visitedNodes.set(node);
            ++this._nodes;
            int arc = this._fst.getFirstArc(node);
            while (arc != 0) {
                if (!this._visitedArcs.get(arc)) {
                    ++this._arcs;
                }
                ++this._totalArcs;
                this._visitedArcs.set(arc);
                if (!this._fst.isArcTerminal(arc)) {
                    this.visitNode(this._fst.getEndNode(arc));
                }
                arc = this._fst.getNextArc(arc);
            }
        }
    }
}

