/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.automaton;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Automaton;
import org.apache.pinot.segment.local.utils.nativefst.automaton.BasicOperations;
import org.apache.pinot.segment.local.utils.nativefst.automaton.SpecialOperations;
import org.apache.pinot.segment.local.utils.nativefst.automaton.State;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Transition;

public final class MinimizationOperations {
    private MinimizationOperations() {
    }

    public static void minimize(Automaton a) {
        if (!a.isSingleton()) {
            switch (Automaton._minimization) {
                case 0: {
                    MinimizationOperations.minimizeHuffman(a);
                    break;
                }
                case 1: {
                    MinimizationOperations.minimizeBrzozowski(a);
                    break;
                }
                case 3: {
                    MinimizationOperations.minimizeValmari(a);
                    break;
                }
                default: {
                    MinimizationOperations.minimizeHopcroft(a);
                }
            }
        }
        a.recomputeHashCode();
    }

    private static boolean statesAgree(Transition[][] transitions, boolean[][] mark, int n1, int n2) {
        Transition[] t1 = transitions[n1];
        Transition[] t2 = transitions[n2];
        int k1 = 0;
        int k2 = 0;
        while (k1 < t1.length && k2 < t2.length) {
            if (t1[k1]._max < t2[k2]._min) {
                ++k1;
                continue;
            }
            if (t2[k2]._max < t1[k1]._min) {
                ++k2;
                continue;
            }
            int m1 = t1[k1]._to._number;
            int m2 = t2[k2]._to._number;
            if (m1 > m2) {
                int t = m1;
                m1 = m2;
                m2 = t;
            }
            if (mark[m1][m2]) {
                return false;
            }
            if (t1[k1]._max < t2[k2]._max) {
                ++k1;
                continue;
            }
            ++k2;
        }
        return true;
    }

    private static void addTriggers(Transition[][] transitions, ArrayList<ArrayList<HashSet<IntPair>>> triggers, int n1, int n2) {
        Transition[] t1 = transitions[n1];
        Transition[] t2 = transitions[n2];
        int k1 = 0;
        int k2 = 0;
        while (k1 < t1.length && k2 < t2.length) {
            if (t1[k1]._max < t2[k2]._min) {
                ++k1;
                continue;
            }
            if (t2[k2]._max < t1[k1]._min) {
                ++k2;
                continue;
            }
            if (t1[k1]._to != t2[k2]._to) {
                int m1 = t1[k1]._to._number;
                int m2 = t2[k2]._to._number;
                if (m1 > m2) {
                    int t = m1;
                    m1 = m2;
                    m2 = t;
                }
                if (triggers.get(m1).get(m2) == null) {
                    triggers.get(m1).set(m2, new HashSet());
                }
                triggers.get(m1).get(m2).add(new IntPair(n1, n2));
            }
            if (t1[k1]._max < t2[k2]._max) {
                ++k1;
                continue;
            }
            ++k2;
        }
    }

    private static void markPair(boolean[][] mark, ArrayList<ArrayList<HashSet<IntPair>>> triggers, int n1, int n2) {
        mark[n1][n2] = true;
        if (triggers.get(n1).get(n2) != null) {
            for (IntPair p : triggers.get(n1).get(n2)) {
                int m1 = p._first;
                int m2 = p._second;
                if (m1 > m2) {
                    int t = m1;
                    m1 = m2;
                    m2 = t;
                }
                if (mark[m1][m2]) continue;
                MinimizationOperations.markPair(mark, triggers, m1, m2);
            }
        }
    }

    private static <T> void initialize(ArrayList<T> list, int size) {
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
    }

    public static void minimizeHuffman(Automaton a) {
        int n;
        int n1;
        a.determinize();
        a.totalize();
        Set<State> ss = a.getStates();
        Transition[][] transitions = new Transition[ss.size()][];
        State[] states = ss.toArray(new State[ss.size()]);
        boolean[][] mark = new boolean[states.length][states.length];
        ArrayList<ArrayList<HashSet<IntPair>>> triggers = new ArrayList<ArrayList<HashSet<IntPair>>>();
        for (n1 = 0; n1 < states.length; ++n1) {
            ArrayList v = new ArrayList();
            MinimizationOperations.initialize(v, states.length);
            triggers.add(v);
        }
        for (n1 = 0; n1 < states.length; ++n1) {
            states[n1]._number = n1;
            transitions[n1] = states[n1].getSortedTransitionArray(false);
            for (int n2 = n1 + 1; n2 < states.length; ++n2) {
                if (states[n1]._accept == states[n2]._accept) continue;
                mark[n1][n2] = true;
            }
        }
        for (n1 = 0; n1 < states.length; ++n1) {
            for (int n2 = n1 + 1; n2 < states.length; ++n2) {
                if (mark[n1][n2]) continue;
                if (MinimizationOperations.statesAgree(transitions, mark, n1, n2)) {
                    MinimizationOperations.addTriggers(transitions, triggers, n1, n2);
                    continue;
                }
                MinimizationOperations.markPair(mark, triggers, n1, n2);
            }
        }
        int numclasses = 0;
        for (int n2 = 0; n2 < states.length; ++n2) {
            states[n2]._number = -1;
        }
        for (int n12 = 0; n12 < states.length; ++n12) {
            if (states[n12]._number != -1) continue;
            states[n12]._number = numclasses;
            for (int n2 = n12 + 1; n2 < states.length; ++n2) {
                if (mark[n12][n2]) continue;
                states[n2]._number = numclasses;
            }
            ++numclasses;
        }
        State[] newstates = new State[numclasses];
        for (n = 0; n < numclasses; ++n) {
            newstates[n] = new State();
        }
        for (n = 0; n < states.length; ++n) {
            newstates[states[n]._number]._number = n;
            if (states[n] != a._initial) continue;
            a._initial = newstates[states[n]._number];
        }
        for (n = 0; n < numclasses; ++n) {
            State s = newstates[n];
            s._accept = states[s._number]._accept;
            for (Transition t : states[s._number]._transitionSet) {
                s._transitionSet.add(new Transition(t._min, t._max, newstates[t._to._number]));
            }
        }
        a.removeDeadTransitions();
    }

    public static void minimizeBrzozowski(Automaton a) {
        if (a.isSingleton()) {
            return;
        }
        BasicOperations.determinize(a, SpecialOperations.reverse(a));
        BasicOperations.determinize(a, SpecialOperations.reverse(a));
    }

    public static void minimizeHopcroft(Automaton a) {
        int n;
        int q;
        a.determinize();
        Set<Transition> tr = a._initial.getTransitionSet();
        if (tr.size() == 1) {
            Transition t = tr.iterator().next();
            if (t._to == a._initial && t._min == '\u0000' && t._max == '\uffff') {
                return;
            }
        }
        a.totalize();
        Set<State> ss = a.getStates();
        State[] states = new State[ss.size()];
        int number = 0;
        Iterator<State> iterator = ss.iterator();
        while (iterator.hasNext()) {
            State q2;
            states[number] = q2 = iterator.next();
            q2._number = number++;
        }
        char[] sigma = a.getStartPoints();
        ArrayList reverse = new ArrayList();
        for (int q3 = 0; q3 < states.length; ++q3) {
            ArrayList v = new ArrayList();
            MinimizationOperations.initialize(v, sigma.length);
            reverse.add(v);
        }
        boolean[][] reverseNonempty = new boolean[states.length][sigma.length];
        ArrayList partition = new ArrayList();
        MinimizationOperations.initialize(partition, states.length);
        int[] block = new int[states.length];
        StateList[][] active = new StateList[states.length][sigma.length];
        StateListNode[][] active2 = new StateListNode[states.length][sigma.length];
        LinkedList<IntPair> pending = new LinkedList<IntPair>();
        boolean[][] pending2 = new boolean[sigma.length][states.length];
        ArrayList<State> split = new ArrayList<State>();
        boolean[] split2 = new boolean[states.length];
        ArrayList<Integer> refine = new ArrayList<Integer>();
        boolean[] refine2 = new boolean[states.length];
        ArrayList splitblock = new ArrayList();
        MinimizationOperations.initialize(splitblock, states.length);
        for (q = 0; q < states.length; ++q) {
            splitblock.set(q, new ArrayList());
            partition.set(q, new LinkedList());
            for (int x = 0; x < sigma.length; ++x) {
                ((ArrayList)reverse.get(q)).set(x, new LinkedList());
                active[q][x] = new StateList();
            }
        }
        for (q = 0; q < states.length; ++q) {
            State qq = states[q];
            int j = qq._accept ? 0 : 1;
            ((LinkedList)partition.get(j)).add(qq);
            block[qq._number] = j;
            for (int x = 0; x < sigma.length; ++x) {
                char y = sigma[x];
                State p = qq.step(y);
                ((LinkedList)((ArrayList)reverse.get(p._number)).get(x)).add(qq);
                reverseNonempty[p._number][x] = true;
            }
        }
        for (int j = 0; j <= 1; ++j) {
            for (int x = 0; x < sigma.length; ++x) {
                for (State qq : (LinkedList)partition.get(j)) {
                    if (!reverseNonempty[qq._number][x]) continue;
                    active2[qq._number][x] = active[j][x].add(qq);
                }
            }
        }
        for (int x = 0; x < sigma.length; ++x) {
            int a0 = active[0][x]._size;
            int a1 = active[1][x]._size;
            int j = a0 <= a1 ? 0 : 1;
            pending.add(new IntPair(j, x));
            pending2[x][j] = true;
        }
        int k = 2;
        while (!pending.isEmpty()) {
            IntPair ip = (IntPair)pending.removeFirst();
            int p = ip._first;
            int x = ip._second;
            pending2[x][p] = false;
            StateListNode m = active[p][x]._first;
            while (m != null) {
                for (State s : (LinkedList)((ArrayList)reverse.get(m._q._number)).get(x)) {
                    if (split2[s._number]) continue;
                    split2[s._number] = true;
                    split.add(s);
                    int j = block[s._number];
                    ((ArrayList)splitblock.get(j)).add(s);
                    if (refine2[j]) continue;
                    refine2[j] = true;
                    refine.add(j);
                }
                m = m._next;
            }
            Iterator iterator2 = refine.iterator();
            while (iterator2.hasNext()) {
                int j = (Integer)iterator2.next();
                if (((ArrayList)splitblock.get(j)).size() < ((LinkedList)partition.get(j)).size()) {
                    LinkedList b1 = (LinkedList)partition.get(j);
                    LinkedList b2 = (LinkedList)partition.get(k);
                    for (State s : (ArrayList)splitblock.get(j)) {
                        b1.remove(s);
                        b2.add(s);
                        block[s._number] = k;
                        for (int c = 0; c < sigma.length; ++c) {
                            StateListNode sn = active2[s._number][c];
                            if (sn == null || sn._stateList != active[j][c]) continue;
                            sn.remove();
                            active2[s._number][c] = active[k][c].add(s);
                        }
                    }
                    for (int c = 0; c < sigma.length; ++c) {
                        int aj = active[j][c]._size;
                        int ak = active[k][c]._size;
                        if (!pending2[c][j] && 0 < aj && aj <= ak) {
                            pending2[c][j] = true;
                            pending.add(new IntPair(j, c));
                            continue;
                        }
                        pending2[c][k] = true;
                        pending.add(new IntPair(k, c));
                    }
                    ++k;
                }
                for (State s : (ArrayList)splitblock.get(j)) {
                    split2[s._number] = false;
                }
                refine2[j] = false;
                ((ArrayList)splitblock.get(j)).clear();
            }
            split.clear();
            refine.clear();
        }
        State[] newstates = new State[k];
        for (n = 0; n < newstates.length; ++n) {
            State s;
            newstates[n] = s = new State();
            for (State q4 : (LinkedList)partition.get(n)) {
                if (q4 == a._initial) {
                    a._initial = s;
                }
                s._accept = q4._accept;
                s._number = q4._number;
                q4._number = n;
            }
        }
        for (n = 0; n < newstates.length; ++n) {
            State s = newstates[n];
            s._accept = states[s._number]._accept;
            for (Transition t : states[s._number]._transitionSet) {
                s._transitionSet.add(new Transition(t._min, t._max, newstates[t._to._number]));
            }
        }
        a.removeDeadTransitions();
    }

    public static void minimizeValmari(Automaton automaton) {
        automaton.determinize();
        Set<State> states = automaton.getStates();
        MinimizationOperations.splitTransitions(states);
        int stateCount = states.size();
        int transitionCount = automaton.getNumberOfTransitions();
        Set<State> acceptStates = automaton.getAcceptStates();
        Partition blocks = new Partition(stateCount);
        Partition cords = new Partition(transitionCount);
        IntPair[] labels = new IntPair[transitionCount];
        int[] tails = new int[transitionCount];
        int[] heads = new int[transitionCount];
        Automaton.setStateNumbers(states);
        int number = 0;
        for (State s : automaton.getStates()) {
            for (Transition t : s.getTransitionSet()) {
                tails[number] = s._number;
                labels[number] = new IntPair(t._min, t._max);
                heads[number] = t.getDest()._number;
                ++number;
            }
        }
        for (State s : acceptStates) {
            blocks.mark(s._number);
        }
        blocks.split();
        if (transitionCount > 0) {
            Arrays.sort(cords._elements, new LabelComparator(labels));
            cords._setCount = 0;
            cords._markedElementCount[0] = 0;
            IntPair firstPair = labels[cords._elements[0]];
            int i = 0;
            while (i < transitionCount) {
                int t = cords._elements[i];
                if (labels[t]._first != firstPair._first || labels[t]._second != firstPair._second) {
                    firstPair = labels[t];
                    cords._past[cords._setCount++] = i;
                    cords._first[cords._setCount] = i;
                    cords._markedElementCount[cords._setCount] = 0;
                }
                cords._setNo[t] = cords._setCount;
                cords._locations[t] = i++;
            }
            cords._past[cords._setCount++] = transitionCount;
        }
        int[] firstBlock = new int[transitionCount];
        int[] secondBlock = new int[stateCount + 1];
        MinimizationOperations.makeAdjacent(firstBlock, secondBlock, heads, stateCount, transitionCount);
        for (int c = 0; c < cords._setCount; ++c) {
            for (int i = cords._first[c]; i < cords._past[c]; ++i) {
                blocks.mark(tails[cords._elements[i]]);
            }
            blocks.split();
            for (int b = 1; b < blocks._setCount; ++b) {
                for (int i = blocks._first[b]; i < blocks._past[b]; ++i) {
                    for (int j = secondBlock[blocks._elements[i]]; j < secondBlock[blocks._elements[i] + 1]; ++j) {
                        cords.mark(firstBlock[j]);
                    }
                }
                cords.split();
            }
        }
        State[] newStates = new State[blocks._setCount];
        for (int bl = 0; bl < blocks._setCount; ++bl) {
            newStates[bl] = new State();
            if (blocks._first[bl] >= acceptStates.size()) continue;
            newStates[bl]._accept = true;
        }
        for (int t = 0; t < transitionCount; ++t) {
            if (blocks._locations[tails[t]] != blocks._first[blocks._setNo[tails[t]]]) continue;
            State tail = newStates[blocks._setNo[tails[t]]];
            State head = newStates[blocks._setNo[heads[t]]];
            tail.addTransition(new Transition((char)labels[t]._first, (char)labels[t]._second, head));
        }
        automaton.setInitialState(newStates[blocks._setNo[automaton.getInitialState()._number]]);
        automaton.reduce();
    }

    private static void makeAdjacent(int[] firstBlock, int[] secondBlock, int[] heads, int stateCount, int transitionCount) {
        int t;
        int q;
        for (q = 0; q <= stateCount; ++q) {
            secondBlock[q] = 0;
        }
        for (t = 0; t < transitionCount; ++t) {
            int n = heads[t];
            secondBlock[n] = secondBlock[n] + 1;
        }
        for (q = 0; q < stateCount; ++q) {
            int n = q + 1;
            secondBlock[n] = secondBlock[n] + secondBlock[q];
        }
        t = transitionCount;
        while (t-- > 0) {
            int n = heads[t];
            int n2 = secondBlock[n] - 1;
            secondBlock[n] = n2;
            firstBlock[n2] = t;
        }
    }

    private static void splitTransitions(Set<State> states) {
        TreeSet<Character> pointSet = new TreeSet<Character>();
        for (State s : states) {
            for (Transition t : s.getTransitionSet()) {
                pointSet.add(Character.valueOf(t._min));
                pointSet.add(Character.valueOf(t._max));
            }
        }
        for (State s : states) {
            Set<Transition> transitions = s.getTransitionSet();
            s.resetTransitions();
            for (Transition t : transitions) {
                if (t._min == t._max) {
                    s.addTransition(t);
                    continue;
                }
                NavigableSet<Character> headSet = pointSet.headSet(Character.valueOf(t._max), true);
                NavigableSet<Character> tailSet = pointSet.tailSet(Character.valueOf(t._min), false);
                TreeSet<Character> intersection = new TreeSet<Character>((SortedSet<Character>)headSet);
                intersection.retainAll(tailSet);
                char start = t._min;
                for (Character c : intersection) {
                    s.addTransition(new Transition(start, t._to));
                    s.addTransition(new Transition(c.charValue(), t._to));
                    if (c.charValue() - start > 1) {
                        s.addTransition(new Transition((char)(start + '\u0001'), (char)(c.charValue() - '\u0001'), t._to));
                    }
                    start = c.charValue();
                }
            }
        }
    }

    static class LabelComparator
    implements Comparator<Integer> {
        private IntPair[] _labels;

        LabelComparator(IntPair[] labels) {
            this._labels = labels;
        }

        @Override
        public int compare(Integer i, Integer j) {
            IntPair p1 = this._labels[i];
            IntPair p2 = this._labels[j];
            if (p1._first < p2._first) {
                return -1;
            }
            if (p1._first > p2._first) {
                return 1;
            }
            if (p1._second < p2._second) {
                return -1;
            }
            if (p1._second > p2._second) {
                return 1;
            }
            return 0;
        }
    }

    static class Partition {
        int[] _markedElementCount;
        int[] _touchedSets;
        int _touchedSetCount;
        int _setCount;
        Integer[] _elements;
        int[] _locations;
        int[] _setNo;
        int[] _first;
        int[] _past;

        Partition(int size) {
            this._setCount = size == 0 ? 0 : 1;
            this._elements = new Integer[size];
            this._locations = new int[size];
            this._setNo = new int[size];
            this._first = new int[size];
            this._past = new int[size];
            this._markedElementCount = new int[size];
            this._touchedSets = new int[size];
            for (int i = 0; i < size; ++i) {
                this._elements[i] = i;
                this._locations[i] = i;
                this._setNo[i] = 0;
            }
            if (this._setCount != 0) {
                this._first[0] = 0;
                this._past[0] = size;
            }
        }

        void mark(int e) {
            int s = this._setNo[e];
            int i = this._locations[e];
            int j = this._first[s] + this._markedElementCount[s];
            this._elements[i] = this._elements[j];
            this._locations[this._elements[i].intValue()] = i;
            this._elements[j] = e;
            this._locations[e] = j;
            int n = s;
            int n2 = this._markedElementCount[n];
            this._markedElementCount[n] = n2 + 1;
            if (n2 == 0) {
                this._touchedSets[this._touchedSetCount++] = s;
            }
        }

        void split() {
            while (this._touchedSetCount > 0) {
                int s;
                int j;
                if ((j = this._first[s = this._touchedSets[--this._touchedSetCount]] + this._markedElementCount[s]) == this._past[s]) {
                    this._markedElementCount[s] = 0;
                    continue;
                }
                if (this._markedElementCount[s] <= this._past[s] - j) {
                    this._first[this._setCount] = this._first[s];
                    this._past[this._setCount] = j;
                    this._first[s] = j;
                } else {
                    this._past[this._setCount] = this._past[s];
                    this._first[this._setCount] = j;
                    this._past[s] = j;
                }
                for (int i = this._first[this._setCount]; i < this._past[this._setCount]; ++i) {
                    this._setNo[this._elements[i].intValue()] = this._setCount;
                }
                this._markedElementCount[s] = 0;
                this._markedElementCount[this._setCount++] = 0;
            }
        }
    }

    static class StateListNode {
        State _q;
        StateListNode _next;
        StateListNode _prev;
        StateList _stateList;

        StateListNode(State q, StateList stateList) {
            this._q = q;
            this._stateList = stateList;
            if (this._stateList._size++ == 0) {
                this._stateList._first = this;
                this._stateList._last = this;
            } else {
                this._stateList._last._next = this;
                this._prev = this._stateList._last;
                this._stateList._last = this;
            }
        }

        void remove() {
            --this._stateList._size;
            if (this._stateList._first == this) {
                this._stateList._first = this._next;
            } else {
                this._prev._next = this._next;
            }
            if (this._stateList._last == this) {
                this._stateList._last = this._prev;
            } else {
                this._next._prev = this._prev;
            }
        }
    }

    static class StateList {
        int _size;
        StateListNode _first;
        StateListNode _last;

        StateList() {
        }

        StateListNode add(State q) {
            return new StateListNode(q, this);
        }
    }

    static class IntPair {
        int _first;
        int _second;

        IntPair(int first, int second) {
            this._first = first;
            this._second = second;
        }
    }
}

