/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst;

import org.apache.pinot.segment.local.utils.nativefst.FST;
import org.apache.pinot.segment.local.utils.nativefst.MatchResult;

public final class FSTTraversal {
    private final FST _fst;

    public FSTTraversal(FST fst) {
        this._fst = fst;
    }

    public MatchResult match(MatchResult reuse, byte[] sequence, int start, int length, int node) {
        if (node == 0) {
            reuse.reset(-1, start, node);
            return reuse;
        }
        FST fst = this._fst;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            int arc = fst.getArc(node, sequence[i]);
            if (arc != 0) {
                if (i + 1 == end && fst.isArcFinal(arc)) {
                    reuse.reset(0, i, node);
                    return reuse;
                }
                if (fst.isArcTerminal(arc)) {
                    reuse.reset(-3, i + 1, node);
                    return reuse;
                }
            } else {
                if (i > start) {
                    reuse.reset(-3, i, node);
                } else {
                    reuse.reset(-1, i, node);
                }
                return reuse;
            }
            node = fst.getEndNode(arc);
        }
        reuse.reset(-4, 0, node);
        return reuse;
    }

    public MatchResult match(byte[] sequence, int start, int length, int node) {
        return this.match(new MatchResult(), sequence, start, length, node);
    }

    public MatchResult match(byte[] sequence, int node) {
        return this.match(sequence, 0, sequence.length, node);
    }

    public MatchResult match(byte[] sequence) {
        return this.match(sequence, this._fst.getRootNode());
    }
}

